/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.application.api;

import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.JsonDecoder;
import com.yahoo.slime.JsonFormat;
import com.yahoo.slime.Slime;
import com.yahoo.text.Utf8;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

public class ApplicationMetaData {
    private final String deployedByUser;
    private final String deployedFromDir;
    private final long deployTimestamp;
    private final long generation;
    private final long previousActiveGeneration;
    private final String checkSum;
    private final String appName;

    public ApplicationMetaData(File appDir, String deployedByUser, String deployedFromDir, Long deployTimestamp, String checkSum, Long generation, long previousActiveGeneration) {
        this(deployedByUser, deployedFromDir, deployTimestamp, appDir.getName(), checkSum, generation, previousActiveGeneration);
    }

    public ApplicationMetaData(String deployedByUser, String deployedFromDir, Long deployTimestamp, String applicationName, String checkSum, Long generation, long previousActiveGeneration) {
        this.appName = applicationName;
        this.deployedByUser = deployedByUser;
        this.deployedFromDir = deployedFromDir;
        this.deployTimestamp = deployTimestamp;
        this.checkSum = checkSum;
        this.generation = generation;
        this.previousActiveGeneration = previousActiveGeneration;
    }

    public String getApplicationName() {
        return this.appName;
    }

    public String getDeployedByUser() {
        return this.deployedByUser;
    }

    public String getDeployPath() {
        return this.deployedFromDir;
    }

    public Long getDeployTimestamp() {
        return this.deployTimestamp;
    }

    public Long getGeneration() {
        return this.generation;
    }

    public String getCheckSum() {
        return this.checkSum;
    }

    public long getPreviousActiveGeneration() {
        return this.previousActiveGeneration;
    }

    public String toString() {
        return this.deployedByUser + ", " + this.deployedFromDir + ", " + this.deployTimestamp + ", " + this.generation + ", " + this.checkSum + ", " + this.previousActiveGeneration;
    }

    public static ApplicationMetaData fromJsonString(String jsonString) {
        try {
            Slime data = new Slime();
            new JsonDecoder().decode(data, Utf8.toBytes((String)jsonString));
            Cursor root = data.get();
            Inspector deploy = root.field("deploy");
            Inspector app = root.field("application");
            return new ApplicationMetaData(deploy.field("user").asString(), deploy.field("from").asString(), deploy.field("timestamp").asLong(), app.field("name").asString(), app.field("checksum").asString(), (Long)app.field("generation").asLong(), app.field("previousActiveGeneration").asLong());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error parsing json metadata", e);
        }
    }

    public Slime getSlime() {
        Slime slime = new Slime();
        Cursor meta = slime.setObject();
        Cursor deploy = meta.setObject("deploy");
        deploy.setString("user", this.deployedByUser);
        deploy.setString("from", this.deployedFromDir);
        deploy.setLong("timestamp", this.deployTimestamp);
        Cursor app = meta.setObject("application");
        app.setString("name", this.appName);
        app.setString("checksum", this.checkSum);
        app.setLong("generation", this.generation);
        app.setLong("previousActiveGeneration", this.previousActiveGeneration);
        return slime;
    }

    public String asJsonString() {
        Slime slime = this.getSlime();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            new JsonFormat(false).encode((OutputStream)baos, slime);
            return baos.toString("UTF-8");
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to encode metadata", e);
        }
    }
}

