/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.application.api;

import com.google.common.collect.ImmutableList;
import com.yahoo.config.provision.Environment;
import com.yahoo.config.provision.RegionName;
import com.yahoo.io.IOUtils;
import com.yahoo.text.XML;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.w3c.dom.Element;

public class DeploymentSpec {
    public static final DeploymentSpec empty = new DeploymentSpec(Optional.empty(), UpgradePolicy.defaultPolicy, (List<Step>)ImmutableList.of(), "<deployment version='1.0'/>");
    private final Optional<String> globalServiceId;
    private final UpgradePolicy upgradePolicy;
    private final List<Step> steps;
    private final String xmlForm;

    public DeploymentSpec(Optional<String> globalServiceId, UpgradePolicy upgradePolicy, List<Step> steps) {
        this(globalServiceId, upgradePolicy, steps, null);
    }

    private DeploymentSpec(Optional<String> globalServiceId, UpgradePolicy upgradePolicy, List<Step> steps, String xmlForm) {
        DeploymentSpec.validateTotalDelay(steps);
        this.globalServiceId = globalServiceId;
        this.upgradePolicy = upgradePolicy;
        this.steps = ImmutableList.copyOf(DeploymentSpec.completeSteps(new ArrayList<Step>(steps)));
        this.xmlForm = xmlForm;
        this.validateZones(this.steps);
    }

    private static void validateTotalDelay(List<Step> steps) {
        long totalDelaySeconds = steps.stream().filter(step -> step instanceof Delay).mapToLong(delay -> ((Delay)delay).duration().getSeconds()).sum();
        if (totalDelaySeconds > Duration.ofHours(24L).getSeconds()) {
            throw new IllegalArgumentException("The total delay specified is " + Duration.ofSeconds(totalDelaySeconds) + " but max 24 hours is allowed");
        }
    }

    private void validateZones(List<Step> steps) {
        HashSet<DeclaredZone> zones = new HashSet<DeclaredZone>();
        for (Step step : steps) {
            for (DeclaredZone zone : step.zones()) {
                this.ensureUnique(zone, zones);
            }
        }
    }

    private void ensureUnique(DeclaredZone zone, Set<DeclaredZone> zones) {
        if (!zones.add(zone)) {
            throw new IllegalArgumentException(zone + " is listed twice in deployment.xml");
        }
    }

    private static List<Step> completeSteps(List<Step> steps) {
        DeclaredZone stagingStep;
        DeclaredZone testStep;
        if ((steps = new ArrayList<Step>(new LinkedHashSet<Step>(steps))).stream().anyMatch(step -> step.deploysTo(Environment.prod)) && steps.stream().noneMatch(step -> step.deploysTo(Environment.staging))) {
            steps.add(new DeclaredZone(Environment.staging));
        }
        if (steps.stream().anyMatch(step -> step.deploysTo(Environment.staging)) && steps.stream().noneMatch(step -> step.deploysTo(Environment.test))) {
            steps.add(new DeclaredZone(Environment.test));
        }
        if ((testStep = DeploymentSpec.remove(Environment.test, steps)) != null) {
            steps.add(0, testStep);
        }
        if ((stagingStep = DeploymentSpec.remove(Environment.staging, steps)) != null) {
            steps.add(1, stagingStep);
        }
        return steps;
    }

    private static DeclaredZone remove(Environment environment, List<Step> steps) {
        for (int i = 0; i < steps.size(); ++i) {
            if (!steps.get(i).deploysTo(environment)) continue;
            return (DeclaredZone)steps.remove(i);
        }
        return null;
    }

    public Optional<String> globalServiceId() {
        return this.globalServiceId;
    }

    public UpgradePolicy upgradePolicy() {
        return this.upgradePolicy;
    }

    public List<Step> steps() {
        return this.steps;
    }

    public List<DeclaredZone> zones() {
        return this.steps.stream().flatMap(step -> step.zones().stream()).collect(Collectors.toList());
    }

    public String xmlForm() {
        return this.xmlForm;
    }

    public boolean includes(Environment environment, Optional<RegionName> region) {
        for (Step step : this.steps) {
            if (!step.deploysTo(environment, region)) continue;
            return true;
        }
        return false;
    }

    public static DeploymentSpec fromXml(Reader reader) {
        try {
            return DeploymentSpec.fromXml(IOUtils.readAll((Reader)reader));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read deployment spec", e);
        }
    }

    public static DeploymentSpec fromXml(String xmlForm) {
        ArrayList<Step> steps = new ArrayList<Step>();
        Optional<String> globalServiceId = Optional.empty();
        Element root = XML.getDocument((String)xmlForm).getDocumentElement();
        for (Element environmentTag : XML.getChildren((Element)root)) {
            if (!DeploymentSpec.isEnvironmentName(environmentTag.getTagName())) continue;
            Environment environment = Environment.from((String)environmentTag.getTagName());
            if (environment == Environment.prod) {
                for (Element stepTag : XML.getChildren((Element)environmentTag)) {
                    if (stepTag.getTagName().equals("delay")) {
                        steps.add(new Delay(Duration.ofSeconds(DeploymentSpec.longAttribute("hours", stepTag) * 60L * 60L + DeploymentSpec.longAttribute("minutes", stepTag) * 60L + DeploymentSpec.longAttribute("seconds", stepTag))));
                        continue;
                    }
                    if (stepTag.getTagName().equals("parallel")) {
                        ArrayList<DeclaredZone> zones = new ArrayList<DeclaredZone>();
                        for (Element regionTag : XML.getChildren((Element)stepTag)) {
                            zones.add(DeploymentSpec.readDeclaredZone(environment, regionTag));
                        }
                        steps.add(new ParallelZones(zones));
                        continue;
                    }
                    steps.add(DeploymentSpec.readDeclaredZone(environment, stepTag));
                }
            } else {
                steps.add(new DeclaredZone(environment));
            }
            if (environment == Environment.prod) {
                globalServiceId = DeploymentSpec.readGlobalServiceId(environmentTag);
                continue;
            }
            if (!DeploymentSpec.readGlobalServiceId(environmentTag).isPresent()) continue;
            throw new IllegalArgumentException("Attribute 'global-service-id' is only valid on 'prod' tag.");
        }
        return new DeploymentSpec(globalServiceId, DeploymentSpec.readUpgradePolicy(root), steps, xmlForm);
    }

    private static long longAttribute(String attributeName, Element tag) {
        String value = tag.getAttribute(attributeName);
        if (value == null || value.isEmpty()) {
            return 0L;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Expected an integer for attribute '" + attributeName + "' but got '" + value + "'");
        }
    }

    private static boolean isEnvironmentName(String tagName) {
        return tagName.equals("test") || tagName.equals("staging") || tagName.equals("prod");
    }

    private static DeclaredZone readDeclaredZone(Environment environment, Element regionTag) {
        return new DeclaredZone(environment, Optional.of(RegionName.from((String)XML.getValue((Element)regionTag).trim())), DeploymentSpec.readActive(regionTag));
    }

    private static Optional<String> readGlobalServiceId(Element environmentTag) {
        String globalServiceId = environmentTag.getAttribute("global-service-id");
        if (globalServiceId == null || globalServiceId.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(globalServiceId);
    }

    private static UpgradePolicy readUpgradePolicy(Element root) {
        String policy;
        Element upgradeElement = XML.getChild((Element)root, (String)"upgrade");
        if (upgradeElement == null) {
            return UpgradePolicy.defaultPolicy;
        }
        switch (policy = upgradeElement.getAttribute("policy")) {
            case "canary": {
                return UpgradePolicy.canary;
            }
            case "default": {
                return UpgradePolicy.defaultPolicy;
            }
            case "conservative": {
                return UpgradePolicy.conservative;
            }
        }
        throw new IllegalArgumentException("Illegal upgrade policy '" + policy + "': Must be one of " + Arrays.toString((Object[])UpgradePolicy.values()));
    }

    private static boolean readActive(Element regionTag) {
        String activeValue = regionTag.getAttribute("active");
        if ("true".equals(activeValue)) {
            return true;
        }
        if ("false".equals(activeValue)) {
            return false;
        }
        throw new IllegalArgumentException("Region tags must have an 'active' attribute set to 'true' or 'false' to control whether the region should receive production traffic");
    }

    public static String toMessageString(Throwable t) {
        StringBuilder b = new StringBuilder();
        String lastMessage = null;
        while (t != null) {
            String message = t.getMessage();
            if (message != null && !message.equals(lastMessage)) {
                if (b.length() > 0) {
                    b.append(": ");
                }
                b.append(message);
                lastMessage = message;
            }
            t = t.getCause();
        }
        return b.toString();
    }

    public static void main(String[] args) {
        if (args.length != 2 && args.length != 3) {
            System.err.println("Usage: DeploymentSpec [file] [environment] [region]?Returns 0 if the specified zone matches the deployment spec, 1 otherwise");
            System.exit(1);
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(args[0]));){
            Optional<RegionName> region;
            DeploymentSpec spec = DeploymentSpec.fromXml(reader);
            Environment environment = Environment.from((String)args[1]);
            Optional<RegionName> optional = region = args.length == 3 ? Optional.of(RegionName.from((String)args[2])) : Optional.empty();
            if (spec.includes(environment, region)) {
                System.exit(0);
            } else {
                System.exit(1);
            }
        }
        catch (Exception e) {
            System.err.println("Exception checking deployment spec: " + DeploymentSpec.toMessageString(e));
            System.exit(1);
        }
    }

    public static enum UpgradePolicy {
        canary,
        defaultPolicy,
        conservative;

    }

    public static class ParallelZones
    extends Step {
        private final List<DeclaredZone> zones;

        public ParallelZones(List<DeclaredZone> zones) {
            this.zones = ImmutableList.copyOf(zones);
        }

        @Override
        public List<DeclaredZone> zones() {
            return this.zones;
        }

        @Override
        public boolean deploysTo(Environment environment, Optional<RegionName> region) {
            return this.zones.stream().anyMatch(zone -> zone.deploysTo(environment, region));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ParallelZones)) {
                return false;
            }
            ParallelZones that = (ParallelZones)o;
            return Objects.equals(this.zones, that.zones);
        }

        public int hashCode() {
            return Objects.hash(this.zones);
        }
    }

    public static class DeclaredZone
    extends Step {
        private final Environment environment;
        private Optional<RegionName> region;
        private final boolean active;

        public DeclaredZone(Environment environment) {
            this(environment, Optional.empty(), false);
        }

        public DeclaredZone(Environment environment, Optional<RegionName> region, boolean active) {
            if (environment != Environment.prod && region.isPresent()) {
                throw new IllegalArgumentException("Non-prod environments cannot specify a region");
            }
            if (environment == Environment.prod && !region.isPresent()) {
                throw new IllegalArgumentException("Prod environments must be specified with a region");
            }
            this.environment = environment;
            this.region = region;
            this.active = active;
        }

        public Environment environment() {
            return this.environment;
        }

        public Optional<RegionName> region() {
            return this.region;
        }

        public boolean active() {
            return this.active;
        }

        @Override
        public List<DeclaredZone> zones() {
            return Collections.singletonList(this);
        }

        @Override
        public boolean deploysTo(Environment environment, Optional<RegionName> region) {
            if (environment != this.environment) {
                return false;
            }
            return !region.isPresent() || region.equals(this.region);
        }

        public int hashCode() {
            return Objects.hash(this.environment, this.region);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DeclaredZone)) {
                return false;
            }
            DeclaredZone other = (DeclaredZone)o;
            if (this.environment != other.environment) {
                return false;
            }
            return this.region.equals(other.region());
        }

        public String toString() {
            return this.environment + (this.region.isPresent() ? "." + this.region.get() : "");
        }
    }

    public static class Delay
    extends Step {
        private final Duration duration;

        public Delay(Duration duration) {
            this.duration = duration;
        }

        public Duration duration() {
            return this.duration;
        }

        @Override
        public boolean deploysTo(Environment environment, Optional<RegionName> region) {
            return false;
        }
    }

    public static abstract class Step {
        public final boolean deploysTo(Environment environment) {
            return this.deploysTo(environment, Optional.empty());
        }

        public abstract boolean deploysTo(Environment var1, Optional<RegionName> var2);

        public List<DeclaredZone> zones() {
            return Collections.emptyList();
        }
    }
}

