/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.text;

import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;

public class StringUtilities {
    private static Charset UTF8 = Charset.forName("utf8");
    private static final ReplacementCharacters replacementCharacters = new ReplacementCharacters();

    private static byte toHex(int val) {
        return (byte)(val < 10 ? 48 + val : 97 + (val - 10));
    }

    public static String escape(String source) {
        return StringUtilities.escape(source, '\u0000');
    }

    public static String escape(String source, char delimiter) {
        byte[] bytes = source.getBytes(UTF8);
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        for (int n : bytes) {
            int val = n;
            if (val < 0) {
                val += 256;
            }
            if (n == delimiter) {
                result.write(92);
                result.write(120);
                result.write(StringUtilities.toHex(val >> 4 & 0xF));
                result.write(StringUtilities.toHex(val & 0xF));
                continue;
            }
            if (StringUtilities.replacementCharacters.needEscape[val] == 0) {
                result.write(n);
                continue;
            }
            if (StringUtilities.replacementCharacters.needEscape[val] == 3) {
                result.write(92);
                result.write(120);
            }
            result.write(StringUtilities.replacementCharacters.replacement1[val]);
            result.write(StringUtilities.replacementCharacters.replacement2[val]);
        }
        return new String(result.toByteArray(), UTF8);
    }

    private static class ReplacementCharacters {
        public byte[] needEscape = new byte[256];
        public byte[] replacement1 = new byte[256];
        public byte[] replacement2 = new byte[256];

        public ReplacementCharacters() {
            for (int i = 0; i < 256; ++i) {
                if (i >= 32 && i <= 126) {
                    this.needEscape[i] = 0;
                    continue;
                }
                if (i > 127) {
                    this.needEscape[i] = 0;
                    continue;
                }
                this.needEscape[i] = 3;
                this.replacement1[i] = StringUtilities.toHex(i >> 4 & 0xF);
                this.replacement2[i] = StringUtilities.toHex(i & 0xF);
            }
            this.makeSimpleEscape('\"', '\"');
            this.makeSimpleEscape('\\', '\\');
            this.makeSimpleEscape('\t', 't');
            this.makeSimpleEscape('\n', 'n');
            this.makeSimpleEscape('\r', 'r');
            this.makeSimpleEscape('\f', 'f');
        }

        private void makeSimpleEscape(char source, char dest) {
            this.needEscape[source] = 1;
            this.replacement1[source] = 92;
            this.replacement2[source] = (byte)dest;
        }
    }
}

