/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.application;

import com.yahoo.config.application.PreProcessor;
import com.yahoo.config.application.Xml;
import com.yahoo.config.provision.Environment;
import com.yahoo.config.provision.RegionName;
import com.yahoo.log.LogLevel;
import com.yahoo.text.XML;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

class OverrideProcessor
implements PreProcessor {
    private static final Logger log = Logger.getLogger(OverrideProcessor.class.getName());
    private final Environment environment;
    private final RegionName region;
    private static final String ATTR_ID = "id";
    private static final String ATTR_ENV = "environment";
    private static final String ATTR_REG = "region";

    public OverrideProcessor(Environment environment, RegionName region) {
        this.environment = environment;
        this.region = region;
    }

    @Override
    public Document process(Document input) throws TransformerException {
        log.log((Level)LogLevel.DEBUG, "Preprocessing overrides with " + this.environment + "." + this.region);
        Document ret = Xml.copyDocument(input);
        Element root = ret.getDocumentElement();
        this.applyOverrides(root, Context.empty());
        return ret;
    }

    private void applyOverrides(Element parent, Context context) {
        context = this.getParentContext(parent, context);
        Map<String, List<Element>> elementsByTagName = this.elementsByTagNameAndId(XML.getChildren((Element)parent));
        this.retainOverriddenElements(elementsByTagName);
        for (Map.Entry<String, List<Element>> entry : elementsByTagName.entrySet()) {
            this.pruneOverrides(parent, entry.getValue(), context);
        }
        for (Element child : XML.getChildren((Element)parent)) {
            this.applyOverrides(child, context);
            child.removeAttributeNS("vespa", ATTR_ENV);
            child.removeAttributeNS("vespa", ATTR_REG);
        }
    }

    private Context getParentContext(Element parent, Context context) {
        Optional<Environment> environment = context.environment;
        RegionName region = context.region;
        if (!environment.isPresent()) {
            environment = this.getEnvironment(parent);
        }
        if (region.isDefault()) {
            region = this.getRegion(parent);
        }
        return Context.create(environment, region);
    }

    private void pruneOverrides(Element parent, List<Element> children, Context context) {
        this.checkConsistentInheritance(children, context);
        this.pruneNonMatchingEnvironmentsAndRegions(parent, children);
        this.retainMostSpecificEnvironmentAndRegion(parent, children, context);
    }

    private void checkConsistentInheritance(List<Element> children, Context context) {
        for (Element child : children) {
            Optional<Environment> env = this.getEnvironment(child);
            RegionName reg = this.getRegion(child);
            if (env.isPresent() && context.environment.isPresent() && !env.equals(context.environment)) {
                throw new IllegalArgumentException("Environment in child (" + env.get() + ") differs from that inherited from parent (" + context.environment + ") at " + child);
            }
            if (reg.isDefault() || context.region.isDefault() || reg.equals((Object)context.region)) continue;
            throw new IllegalArgumentException("Region in child (" + reg + ") differs from that inherited from parent (" + context.region + ") at " + child);
        }
    }

    private void pruneNonMatchingEnvironmentsAndRegions(Element parent, List<Element> children) {
        Iterator<Element> elemIt = children.iterator();
        while (elemIt.hasNext()) {
            Element child = elemIt.next();
            if (this.matches(this.getEnvironment(child), this.getRegion(child))) continue;
            parent.removeChild(child);
            elemIt.remove();
        }
    }

    private boolean matches(Optional<Environment> elementEnvironment, RegionName elementRegion) {
        if (elementEnvironment.isPresent() && !this.environment.equals((Object)elementEnvironment.get())) {
            return false;
        }
        if (!elementRegion.isDefault()) {
            if (!this.region.equals((Object)elementRegion)) {
                return false;
            }
            if (!elementEnvironment.isPresent() && !this.environment.equals((Object)Environment.prod)) {
                return false;
            }
        }
        return true;
    }

    private void retainMostSpecificEnvironmentAndRegion(Element parent, List<Element> children, Context context) {
        ArrayList<Element> bestMatches = new ArrayList<Element>();
        int bestMatch = 0;
        for (Element child : children) {
            bestMatch = this.updateBestMatches(bestMatches, child, bestMatch, context);
        }
        if (bestMatch > 0) {
            this.doElementSpecificProcessingOnOverride(bestMatches);
            for (Element child : children) {
                if (bestMatches.contains(child)) continue;
                parent.removeChild(child);
            }
        }
    }

    private int updateBestMatches(List<Element> bestMatches, Element child, int bestMatch, Context context) {
        int overrideCount = this.getNumberOfOverrides(child, context);
        if (overrideCount >= bestMatch) {
            if (overrideCount > bestMatch) {
                bestMatches.clear();
            }
            bestMatches.add(child);
            return overrideCount;
        }
        return bestMatch;
    }

    private int getNumberOfOverrides(Element child, Context context) {
        RegionName elementRegion;
        int currentMatch = 0;
        Optional<Environment> elementEnvironment = this.hasEnvironment(child) ? this.getEnvironment(child) : context.environment;
        RegionName regionName = elementRegion = this.hasRegion(child) ? this.getRegion(child) : context.region;
        if (elementEnvironment.isPresent() && elementEnvironment.get().equals((Object)this.environment)) {
            ++currentMatch;
        }
        if (!elementRegion.isDefault() && elementRegion.equals((Object)this.region)) {
            ++currentMatch;
        }
        return currentMatch;
    }

    private void doElementSpecificProcessingOnOverride(List<Element> elements) {
        elements.forEach(element -> {
            if (element.getTagName().equals("nodes") && element.getChildNodes().getLength() == 0) {
                element.setAttribute("required", "true");
            }
        });
    }

    private void retainOverriddenElements(Map<String, List<Element>> elementsByTagName) {
        Iterator<Map.Entry<String, List<Element>>> it = elementsByTagName.entrySet().iterator();
        while (it.hasNext()) {
            List<Element> elements = it.next().getValue();
            boolean hasOverrides = false;
            for (Element element : elements) {
                if (!this.hasEnvironment(element) && !this.hasRegion(element)) continue;
                hasOverrides = true;
            }
            if (hasOverrides) continue;
            it.remove();
        }
    }

    private boolean hasRegion(Element element) {
        return element.hasAttributeNS("vespa", ATTR_REG);
    }

    private boolean hasEnvironment(Element element) {
        return element.hasAttributeNS("vespa", ATTR_ENV);
    }

    private Optional<Environment> getEnvironment(Element element) {
        String env = element.getAttributeNS("vespa", ATTR_ENV);
        if (env == null || env.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(Environment.from((String)env));
    }

    private RegionName getRegion(Element element) {
        String reg = element.getAttributeNS("vespa", ATTR_REG);
        if (reg == null || reg.isEmpty()) {
            return RegionName.defaultName();
        }
        return RegionName.from((String)reg);
    }

    private Map<String, List<Element>> elementsByTagNameAndId(List<Element> children) {
        LinkedHashMap<String, List<Element>> elementsByTagName = new LinkedHashMap<String, List<Element>>();
        for (Element child : children) {
            String key = child.getTagName();
            if (child.hasAttribute(ATTR_ID)) {
                key = key + child.getAttribute(ATTR_ID);
            }
            if (!elementsByTagName.containsKey(key)) {
                elementsByTagName.put(key, new ArrayList());
            }
            ((List)elementsByTagName.get(key)).add(child);
        }
        return elementsByTagName;
    }

    private static String getPrintableElement(Element element) {
        StringBuilder sb = new StringBuilder(element.getTagName());
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            sb.append(" ").append(attributes.item(i).getNodeName());
        }
        return sb.toString();
    }

    private static String getPrintableElementRecursive(Element element) {
        StringBuilder sb = new StringBuilder();
        sb.append(element.getTagName());
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            sb.append(" ").append(attributes.item(i).getNodeName()).append("=").append(attributes.item(i).getNodeValue());
        }
        List children = XML.getChildren((Element)element);
        if (children.size() > 0) {
            sb.append("\n");
            for (Element e : children) {
                sb.append("\t").append(OverrideProcessor.getPrintableElementRecursive(e));
            }
        }
        return sb.toString();
    }

    private static final class Context {
        final Optional<Environment> environment;
        final RegionName region;

        private Context(Optional<Environment> environment, RegionName region) {
            this.environment = environment;
            this.region = region;
        }

        static Context empty() {
            return new Context(Optional.empty(), RegionName.defaultName());
        }

        public static Context create(Optional<Environment> environment, RegionName region) {
            return new Context(environment, region);
        }
    }
}

