/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.application.provider;

import com.yahoo.config.FileReference;
import com.yahoo.config.application.api.FileRegistry;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class PreGeneratedFileRegistry
implements FileRegistry {
    private final String fileSourceHost;
    private final Map<String, String> path2Hash = new LinkedHashMap<String, String>();
    private static String entryDelimiter = "\t";
    private static Pattern entryDelimiterPattern = Pattern.compile(entryDelimiter, 16);

    private PreGeneratedFileRegistry(Reader readerArg) {
        BufferedReader reader = new BufferedReader(readerArg);
        try {
            String line;
            this.fileSourceHost = reader.readLine();
            if (this.fileSourceHost == null) {
                throw new RuntimeException("Error while reading pre generated file registry");
            }
            while ((line = reader.readLine()) != null) {
                this.addFromLine(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error while reading pre generated file registry", e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void addFromLine(String line) {
        String[] parts = entryDelimiterPattern.split(line);
        this.addEntry(parts[0], parts[1]);
    }

    private void addEntry(String relativePath, String hash) {
        this.path2Hash.put(relativePath, hash);
    }

    public static String exportRegistry(FileRegistry registry) {
        List entries = registry.export();
        StringBuilder builder = new StringBuilder();
        builder.append(registry.fileSourceHost()).append('\n');
        for (FileRegistry.Entry entry : entries) {
            builder.append(entry.relativePath).append(entryDelimiter).append(entry.reference.value()).append('\n');
        }
        return builder.toString();
    }

    public static PreGeneratedFileRegistry importRegistry(Reader reader) {
        return new PreGeneratedFileRegistry(reader);
    }

    public FileReference addFile(String relativePath) {
        return new FileReference(this.path2Hash.get(relativePath));
    }

    public String fileSourceHost() {
        return this.fileSourceHost;
    }

    public Set<String> getPaths() {
        return this.path2Hash.keySet();
    }

    public List<FileRegistry.Entry> export() {
        ArrayList<FileRegistry.Entry> entries = new ArrayList<FileRegistry.Entry>();
        for (Map.Entry<String, String> entry : this.path2Hash.entrySet()) {
            entries.add(new FileRegistry.Entry(entry.getKey(), new FileReference(entry.getValue())));
        }
        return entries;
    }
}

