/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.component;

import com.yahoo.component.ComponentId;
import com.yahoo.component.Spec;
import com.yahoo.component.SpecSplitter;
import com.yahoo.component.Version;
import com.yahoo.component.VersionSpecification;

public final class ComponentSpecification {
    private final Spec<VersionSpecification> spec;
    private final String stringValue;

    public static ComponentSpecification fromString(String componentSpecification) {
        try {
            return componentSpecification != null ? new ComponentSpecification(componentSpecification) : null;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Illegal component specification: '" + componentSpecification + "'", e);
        }
    }

    public ComponentSpecification(String name, VersionSpecification versionSpecification, ComponentId namespace) {
        this.spec = new Spec<VersionSpecification>(new VersionHandler(), name, versionSpecification, namespace);
        this.stringValue = this.spec.createStringValue();
    }

    public ComponentSpecification(String name, VersionSpecification versionSpec) {
        this(name, versionSpec, null);
    }

    public ComponentSpecification(String id) {
        this(new SpecSplitter(id));
    }

    private ComponentSpecification(SpecSplitter splitter) {
        this(splitter.name, VersionSpecification.fromString(splitter.version), splitter.namespace);
    }

    public ComponentSpecification nestInNamespace(ComponentId namespace) {
        ComponentId newNameSpace = this.getNamespace() == null ? namespace : this.getNamespace().nestInNamespace(namespace);
        return new ComponentSpecification(this.getName(), this.getVersionSpecification(), newNameSpace);
    }

    public ComponentId getNamespace() {
        return this.spec.namespace;
    }

    public String getName() {
        return this.spec.name;
    }

    public VersionSpecification getVersionSpecification() {
        return (VersionSpecification)this.spec.version;
    }

    public String stringValue() {
        return this.stringValue;
    }

    public String toString() {
        return this.toId().toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ComponentSpecification)) {
            return false;
        }
        ComponentSpecification c = (ComponentSpecification)o;
        return c.stringValue.equals(this.stringValue());
    }

    public int hashCode() {
        return this.stringValue.hashCode();
    }

    public ComponentId toId() {
        Version version = this.getVersionSpecification() == VersionSpecification.emptyVersionSpecification ? Version.emptyVersion : this.getVersionSpecification().lowestMatchingVersion();
        return new ComponentId(this.getName(), version, this.getNamespace());
    }

    public boolean matches(ComponentId id) {
        boolean versionMatch = this.getVersionSpecification().matches(id.getVersion());
        return this.getName().equals(id.getName()) && versionMatch && this.namespaceMatch(id.getNamespace());
    }

    public ComponentSpecification intersect(ComponentSpecification other) {
        if (!this.getName().equals(other.getName())) {
            throw new RuntimeException("The names of the component specifications does not match(" + this.getName() + "!=" + other.getName() + ").");
        }
        if (!this.namespaceMatch(other.getNamespace())) {
            throw new RuntimeException("The namespaces of the component specifications does not match(" + this + ", " + other + ")");
        }
        return new ComponentSpecification(this.getName(), this.getVersionSpecification().intersect(other.getVersionSpecification()), this.getNamespace());
    }

    public ComponentSpecification withoutNamespace() {
        return new ComponentSpecification(this.getName(), this.getVersionSpecification(), null);
    }

    private boolean namespaceMatch(ComponentId otherNamespace) {
        if (this.getNamespace() == otherNamespace) {
            return true;
        }
        if (this.getNamespace() == null || otherNamespace == null) {
            return false;
        }
        return this.getNamespace().equals(otherNamespace);
    }

    private final class VersionHandler
    implements Spec.VersionHandler<VersionSpecification> {
        private VersionHandler() {
        }

        @Override
        public VersionSpecification emptyVersion() {
            return VersionSpecification.emptyVersionSpecification;
        }

        @Override
        public int compare(VersionSpecification v1, VersionSpecification v2) {
            return v1.compareTo(v2);
        }
    }
}

