/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.component.provider;

import com.yahoo.component.AbstractComponent;
import com.yahoo.component.ComponentId;
import com.yahoo.config.ConfigInstance;
import com.yahoo.vespa.config.ConfigKey;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class ComponentClass<T extends AbstractComponent> {
    private static Logger log = Logger.getLogger(ComponentClass.class.getName());
    private final Class<T> clazz;
    private final ComponentConstructor<T> constructor;

    public ComponentClass(Class<T> clazz) {
        this.clazz = clazz;
        this.constructor = this.findPreferredConstructor();
        if (!this.constructor.isLegal) {
            throw new IllegalArgumentException("Class '" + clazz.getName() + "' must have at least one public constructor with an optional component ID followed by an optional FileAcquirer and zero or more config arguments: " + clazz.getSimpleName() + "([ComponentId] [ConfigInstance ...])");
        }
    }

    public T createComponent(ComponentId id, Map<ConfigKey, ConfigInstance> availableConfigs, String configId) {
        if (configId == null) {
            configId = System.getProperty("config.id");
        }
        boolean hasId = false;
        LinkedList<ComponentId> params = new LinkedList<ComponentId>();
        for (Class cc : ((ComponentConstructor)this.constructor).parameters) {
            if (cc.equals(ComponentId.class)) {
                params.add(id);
                hasId = true;
                continue;
            }
            if (!cc.getSuperclass().equals(ConfigInstance.class)) continue;
            ConfigKey key = new ConfigKey(cc, configId);
            if (availableConfigs == null || !availableConfigs.containsKey(key)) {
                throw new IllegalStateException("Could not resolve config instance '" + key + "' required to instantiate " + this.clazz);
            }
            params.add((ComponentId)availableConfigs.get(key));
        }
        T component = this.construct(params.toArray());
        if (hasId && ((AbstractComponent)component).hasInitializedId() && !id.equals(((AbstractComponent)component).getId())) {
            log.warning("Component with id '" + id + "' tried to set illegal component id: '" + ((AbstractComponent)component).getId() + "', or the component takes ComponentId as a constructor arg without calling super(id).");
        }
        ((AbstractComponent)component).initId(id);
        return component;
    }

    public ComponentConstructor<T> getPreferredConstructor() {
        return this.constructor;
    }

    private T construct(Object ... arguments) {
        String args = Arrays.toString(arguments);
        try {
            return (T)((AbstractComponent)this.constructor.getConstructor().newInstance(arguments));
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Exception while instantiating " + this.clazz + " from " + args, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not access " + this.constructor + " of " + this.clazz);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Exception while executing constructor of " + this.clazz + " with " + args, e);
        }
        catch (IllegalArgumentException e) {
            log.warning(this.clazz.getName() + " expected ctor arguments:");
            for (Class<?> expectedArg : this.constructor.getConstructor().getParameterTypes()) {
                log.warning("   " + expectedArg + " - " + System.identityHashCode(expectedArg));
            }
            log.warning(this.clazz.getName() + " actual ctor arguments: ");
            for (Object actualArg : arguments) {
                log.warning("   " + actualArg.getClass() + " - " + System.identityHashCode(actualArg.getClass()));
            }
            throw new RuntimeException("Exception while executing constructor of " + this.clazz + " with " + args, e);
        }
    }

    private ComponentConstructor<T> findPreferredConstructor() {
        Constructor<?>[] constructors = this.clazz.getConstructors();
        if (constructors.length < 1) {
            throw new RuntimeException("Class has no public constructors: " + this.clazz.getName());
        }
        ComponentConstructor best = new ComponentConstructor(constructors[0]);
        for (int i = 1; i < constructors.length; ++i) {
            Constructor<?> c = constructors[i];
            ComponentConstructor cc = new ComponentConstructor(c);
            if (!cc.preferredTo(best)) continue;
            best = cc;
        }
        return best;
    }

    public static class ComponentConstructor<T> {
        private static final Set<Class> legalArgs = Collections.singleton(ComponentId.class);
        private final Constructor<T> constructor;
        private final Class[] parameters;
        private final List<Class<? extends ConfigInstance>> configArgs;
        public final boolean isLegal;
        public final boolean hasComponentId;

        public ComponentConstructor(Constructor<T> c) {
            this.constructor = c;
            this.parameters = c.getParameterTypes();
            this.isLegal = ComponentConstructor.isLegal(this.parameters);
            this.hasComponentId = ComponentConstructor.hasComponentId(this.parameters);
            this.configArgs = ComponentConstructor.findConfigArgs(this.parameters);
        }

        public Constructor<T> getConstructor() {
            return this.constructor;
        }

        public boolean preferredTo(ComponentConstructor<T> other) {
            if (this.isLegal && !other.isLegal) {
                return true;
            }
            if (!this.isLegal && other.isLegal) {
                return false;
            }
            if (this.parameters.length > other.parameters.length) {
                return true;
            }
            if (this.parameters.length < other.parameters.length) {
                return false;
            }
            if (this.configArgs.size() > other.configArgs.size()) {
                return true;
            }
            if (this.configArgs.size() < other.configArgs.size()) {
                return false;
            }
            if (this.hasComponentId && !other.hasComponentId) {
                return true;
            }
            return this.hasComponentId || !other.hasComponentId;
        }

        private static boolean isLegal(Class[] args) {
            HashSet<Class> used = new HashSet<Class>();
            for (Class cl : args) {
                if (legalArgs.contains(cl)) {
                    if (used.contains(cl)) {
                        return false;
                    }
                    if (cl.equals(String.class) || cl.equals(ComponentId.class)) {
                        used.add(String.class);
                        used.add(ComponentId.class);
                        continue;
                    }
                    used.add(cl);
                    continue;
                }
                Class superclass = cl.getSuperclass();
                if (superclass != null && superclass.equals(ConfigInstance.class)) continue;
                return false;
            }
            return true;
        }

        private static boolean hasComponentId(Class[] args) {
            for (Class cl : args) {
                if (!cl.equals(ComponentId.class)) continue;
                return true;
            }
            return false;
        }

        private static List<Class<? extends ConfigInstance>> findConfigArgs(Class[] args) {
            ArrayList<Class<? extends ConfigInstance>> configs = new ArrayList<Class<? extends ConfigInstance>>();
            for (Class cl : args) {
                Class superclass = cl.getSuperclass();
                if (superclass == null || !superclass.equals(ConfigInstance.class)) continue;
                configs.add(cl);
            }
            return configs;
        }
    }
}

