/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.utils.communication.http;

import com.yahoo.vespa.clustercontroller.utils.communication.http.HttpRequest;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class HttpResult {
    private HttpReturnCode httpReturnCode;
    private final List<HttpRequest.KeyValuePair> headers;
    private Object content;

    public HttpResult() {
        this.httpReturnCode = new HttpReturnCode(200, "OK");
        this.headers = new LinkedList<HttpRequest.KeyValuePair>();
    }

    public HttpResult(HttpResult other) {
        this.httpReturnCode = other.httpReturnCode;
        this.headers = other.headers;
        this.content = other.content;
    }

    public HttpResult setHttpCode(int code, String description) {
        this.httpReturnCode = new HttpReturnCode(code, description);
        return this;
    }

    public HttpResult setContent(Object content) {
        this.content = content;
        return this;
    }

    public HttpResult addHeader(String key, String value) {
        this.headers.add(new HttpRequest.KeyValuePair(key, value));
        return this;
    }

    public boolean isSuccess() {
        return this.httpReturnCode.isSuccess();
    }

    public int getHttpReturnCode() {
        return this.httpReturnCode.getCode();
    }

    public String getHttpReturnCodeDescription() {
        return this.httpReturnCode.getMessage();
    }

    public Collection<HttpRequest.KeyValuePair> getHeaders() {
        return this.headers;
    }

    public String getHeader(String key) {
        for (HttpRequest.KeyValuePair p : this.headers) {
            if (!p.getKey().equals(key)) continue;
            return p.getValue();
        }
        return null;
    }

    public Object getContent() {
        return this.content;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean verbose) {
        StringBuilder sb = new StringBuilder();
        sb.append("HTTP ").append(this.httpReturnCode.getCode()).append('/').append(this.httpReturnCode.getMessage());
        if (verbose) {
            for (HttpRequest.KeyValuePair header : this.headers) {
                sb.append('\n').append(header.getKey()).append(": ").append(header.getValue());
            }
            if (this.content != null) {
                StringBuilder contentBuilder = new StringBuilder();
                this.printContent(contentBuilder);
                String s = contentBuilder.toString();
                if (!s.isEmpty()) {
                    sb.append("\n\n").append(s);
                }
            }
        }
        return sb.toString();
    }

    public void printContent(StringBuilder sb) {
        sb.append(this.content.toString());
    }

    private static class HttpReturnCode {
        private final int code;
        private final String message;

        public HttpReturnCode(int code, String message) {
            this.code = code;
            this.message = message;
        }

        public boolean isSuccess() {
            return this.code >= 200 && this.code < 300;
        }

        public int getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

