/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.vespa.clustercontroller.core.NodeInfo;

public abstract class GetNodeStateRequest {
    private final NodeInfo nodeInfo;
    private Reply reply;

    public GetNodeStateRequest(NodeInfo nodeInfo) {
        this.nodeInfo = nodeInfo;
    }

    public Reply getReply() {
        return this.reply;
    }

    public void setReply(Reply reply) {
        this.reply = reply;
    }

    public NodeInfo getNodeInfo() {
        return this.nodeInfo;
    }

    public abstract void abort();

    public static class Reply {
        private final int returnCode;
        private final String returnMessage;
        private final String stateString;
        private final String hostInfo;

        public Reply(int returnCode, String errorMessage) {
            this.returnCode = returnCode;
            this.returnMessage = errorMessage;
            this.stateString = null;
            this.hostInfo = null;
        }

        public Reply(String stateString, String hostInfo) {
            this.returnCode = 0;
            this.returnMessage = null;
            this.stateString = stateString;
            this.hostInfo = hostInfo;
        }

        public int getReturnCode() {
            return this.returnCode;
        }

        public String getReturnMessage() {
            return this.returnMessage;
        }

        public String getStateString() {
            return this.stateString;
        }

        public String getHostInfo() {
            return this.hostInfo;
        }

        public boolean isError() {
            return this.returnCode != 0;
        }
    }
}

