/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core.status;

import com.yahoo.vdslib.distribution.ConfiguredNode;
import com.yahoo.vdslib.distribution.Group;
import com.yahoo.vdslib.state.ClusterState;
import com.yahoo.vdslib.state.Node;
import com.yahoo.vdslib.state.NodeType;
import com.yahoo.vespa.clustercontroller.core.AggregatedClusterStats;
import com.yahoo.vespa.clustercontroller.core.ClusterStateBundle;
import com.yahoo.vespa.clustercontroller.core.ClusterStateHistoryEntry;
import com.yahoo.vespa.clustercontroller.core.ContentCluster;
import com.yahoo.vespa.clustercontroller.core.EventLog;
import com.yahoo.vespa.clustercontroller.core.FleetControllerOptions;
import com.yahoo.vespa.clustercontroller.core.GlobalBucketSyncStatsCalculator;
import com.yahoo.vespa.clustercontroller.core.LeafGroups;
import com.yahoo.vespa.clustercontroller.core.MasterElectionHandler;
import com.yahoo.vespa.clustercontroller.core.NodeInfo;
import com.yahoo.vespa.clustercontroller.core.RealTimer;
import com.yahoo.vespa.clustercontroller.core.StateVersionTracker;
import com.yahoo.vespa.clustercontroller.core.Timer;
import com.yahoo.vespa.clustercontroller.core.status.statuspage.HtmlTable;
import com.yahoo.vespa.clustercontroller.core.status.statuspage.StatusPageResponse;
import com.yahoo.vespa.clustercontroller.core.status.statuspage.StatusPageServer;
import com.yahoo.vespa.clustercontroller.core.status.statuspage.VdsClusterHtmlRenderer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class LegacyIndexPageRequestHandler
implements StatusPageServer.RequestHandler {
    private static final DecimalFormat DecimalDot2 = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.ENGLISH));
    private final Timer timer;
    private final ContentCluster cluster;
    private final MasterElectionHandler masterElectionHandler;
    private final StateVersionTracker stateVersionTracker;
    private final EventLog eventLog;
    private final long startedTime;
    private FleetControllerOptions options;

    public LegacyIndexPageRequestHandler(Timer timer, ContentCluster cluster, MasterElectionHandler masterElectionHandler, StateVersionTracker stateVersionTracker, EventLog eventLog, FleetControllerOptions options) {
        this.timer = timer;
        this.cluster = cluster;
        this.masterElectionHandler = masterElectionHandler;
        this.stateVersionTracker = stateVersionTracker;
        this.eventLog = eventLog;
        this.startedTime = timer.getCurrentTimeInMillis();
        this.options = options;
    }

    public void propagateOptions(FleetControllerOptions options) {
        this.options = options;
    }

    @Override
    public StatusPageResponse handle(StatusPageServer.HttpRequest request) {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        long currentTime = this.timer.getCurrentTimeInMillis();
        StatusPageResponse response = new StatusPageResponse();
        response.setContentType("text/html");
        StringBuilder content = new StringBuilder();
        content.append("<!-- Answer to request " + String.valueOf(request) + " -->\n");
        response.writeHtmlHeader(content, this.cluster.getName() + " Cluster Controller " + this.options.fleetControllerIndex() + " Status Page");
        content.append("<p><font size=\"-1\">").append(" [ <a href=\"#config\">Current config</a>").append(" | <a href=\"#clusterstates\">Cluster states</a>").append(" | <a href=\"#eventlog\">Event log</a>").append(" ]</font></p>\n");
        content.append("<table><tr><td>UTC time when creating this page:</td><td align=\"right\">").append(RealTimer.printDateNoMilliSeconds(currentTime, tz)).append("</td></tr>");
        content.append("<tr><td>Cluster controller uptime:</td><td align=\"right\">" + RealTimer.printDuration(currentTime - this.startedTime) + "</td></tr></table>");
        if (this.masterElectionHandler.isFirstInLine()) {
            this.writeHtmlState(this.cluster, content, this.timer, this.stateVersionTracker, this.options, this.eventLog);
            this.writeHtmlState(this.stateVersionTracker, content);
        } else {
            this.writeHtmlState(content, this.options);
        }
        this.masterElectionHandler.writeHtmlState(content);
        this.writeHtmlState(content, this.options);
        this.eventLog.writeHtmlState(content, null);
        response.writeHtmlFooter(content, "");
        response.writeContent(content.toString());
        return response;
    }

    @Override
    public String pattern() {
        return "^/$";
    }

    public void writeHtmlState(StateVersionTracker stateVersionTracker, StringBuilder sb) {
        sb.append("<h2 id=\"clusterstates\">Cluster states</h2>\n");
        LegacyIndexPageRequestHandler.writeClusterStates(sb, stateVersionTracker.getVersionedClusterStateBundle());
        LegacyIndexPageRequestHandler.writeDistributionConfig(sb, stateVersionTracker.getVersionedClusterStateBundle());
        if (!stateVersionTracker.getClusterStateHistory().isEmpty()) {
            TimeZone tz = TimeZone.getTimeZone("UTC");
            sb.append("<h3 id=\"clusterstatehistory\">Cluster state history</h3>\n");
            sb.append("<table border=\"1\" cellspacing=\"0\"><tr>\n").append("  <th>Creation date (").append(tz.getDisplayName(false, 0)).append(")</th>\n").append("  <th>Bucket space</th>\n").append("  <th>Cluster state</th>\n").append("</tr>\n");
            for (ClusterStateHistoryEntry historyEntry : stateVersionTracker.getClusterStateHistory()) {
                this.writeClusterStateEntry(historyEntry, sb, tz);
            }
            sb.append("</table>\n");
        }
    }

    private static void writeClusterStates(StringBuilder sb, ClusterStateBundle clusterStates) {
        sb.append("<p>Baseline cluster state:<br><code>").append(LegacyIndexPageRequestHandler.escaped(clusterStates.getBaselineClusterState().toString())).append("</code></p>\n");
        clusterStates.getDerivedBucketSpaceStates().forEach((bucketSpace, state) -> sb.append("<p>").append((String)bucketSpace).append(" cluster state:<br><code>").append(LegacyIndexPageRequestHandler.escaped(state.getClusterState().toString())).append("</code></p>\n"));
    }

    private static void writeDistributionConfig(StringBuilder sb, ClusterStateBundle stateBundle) {
        if (stateBundle.distributionConfig().isEmpty()) {
            return;
        }
        sb.append("<h3 id=\"distribution-config\">Current distribution config</h3>\n<p>").append(LegacyIndexPageRequestHandler.escaped(stateBundle.distributionConfig().get().highLevelDescription())).append("</p>\n");
    }

    private void writeClusterStateEntry(ClusterStateHistoryEntry entry, StringBuilder sb, TimeZone tz) {
        sb.append("<tr><td rowspan=\"").append(entry.getRawStates().size()).append("\">").append(RealTimer.printDate(entry.time(), tz)).append("</td>");
        for (String space : entry.getRawStates().keySet()) {
            if (!space.equals("-")) {
                sb.append("<tr>");
            }
            this.writeClusterStateTransition(space, entry.getStateString(space), entry.getDiffString(space), entry.getStateString("-"), entry.getDiffString("-"), sb);
        }
    }

    private void writeClusterStateTransition(String bucketSpace, String state, String diff, String baselineState, String baselineDiff, StringBuilder sb) {
        sb.append("<td align=\"center\">").append(bucketSpace).append("</td><td>");
        if (!bucketSpace.equals("-") && state.equals(baselineState) && diff.equals(baselineDiff)) {
            sb.append("<span style=\"color: gray\">(identical to baseline state)</span>");
        } else {
            sb.append(state);
            if (!diff.isEmpty()) {
                sb.append("<br><b>Diff</b>: ").append(diff);
            }
        }
        sb.append("</td></tr>\n");
    }

    private void writeHtmlState(ContentCluster cluster, StringBuilder sb, Timer timer, StateVersionTracker stateVersionTracker, FleetControllerOptions options, EventLog eventLog) {
        VdsClusterHtmlRenderer renderer = new VdsClusterHtmlRenderer();
        VdsClusterHtmlRenderer.Table table = renderer.createNewClusterHtmlTable(cluster.getName(), cluster.getSlobrokGenerationCount());
        ClusterStateBundle state = stateVersionTracker.getVersionedClusterStateBundle();
        LegacyIndexPageRequestHandler.renderClusterFeedBlockIfPresent(state, table);
        LegacyIndexPageRequestHandler.renderClusterOutOfSyncRatio(state, stateVersionTracker, table);
        List<Group> groups = LeafGroups.enumerateFrom(cluster.getDistribution().getRootGroup());
        for (Group group : groups) {
            assert (group != null);
            String localName = group.getUnixStylePath();
            assert (localName != null);
            TreeMap<Integer, NodeInfo> storageNodeInfoByIndex = new TreeMap<Integer, NodeInfo>();
            TreeMap<Integer, NodeInfo> distributorNodeInfoByIndex = new TreeMap<Integer, NodeInfo>();
            for (ConfiguredNode configuredNode : group.getNodes()) {
                this.storeNodeInfo(cluster, configuredNode.index(), NodeType.STORAGE, storageNodeInfoByIndex);
                this.storeNodeInfo(cluster, configuredNode.index(), NodeType.DISTRIBUTOR, distributorNodeInfoByIndex);
            }
            table.renderNodes(storageNodeInfoByIndex, distributorNodeInfoByIndex, timer, state, stateVersionTracker.getAggregatedClusterStats(), options.minMergeCompletionRatio(), options.maxPrematureCrashes(), options.clusterFeedBlockLimit(), eventLog, cluster.getName(), localName);
        }
        table.addTable(sb, options.stableStateTimePeriod());
    }

    private static void renderClusterFeedBlockIfPresent(ClusterStateBundle state, VdsClusterHtmlRenderer.Table table) {
        if (state.clusterFeedIsBlocked()) {
            table.appendRaw("<h3 style=\"color: red\">Cluster feeding is blocked!</h3>\n");
            table.appendRaw(String.format("<p>Summary: <strong>%s</strong></p>\n", LegacyIndexPageRequestHandler.escaped(state.getFeedBlockOrNull().getDescription())));
        }
    }

    private static void renderClusterOutOfSyncRatio(ClusterStateBundle state, StateVersionTracker stateVersionTracker, VdsClusterHtmlRenderer.Table table) {
        AggregatedClusterStats stats = stateVersionTracker.getAggregatedClusterStats().getAggregatedStats();
        if (!stats.hasUpdatesFromAllDistributors()) {
            table.appendRaw("<p>Current cluster out of sync ratio cannot be computed, as not all distributors have reported in statistics for the most recent cluster state.</p>\n");
            return;
        }
        Optional<Double> outOfSync = GlobalBucketSyncStatsCalculator.clusterBucketsOutOfSyncRatio(stats.getGlobalStats());
        if (outOfSync.isEmpty()) {
            table.appendRaw("<p>Current cluster out of sync ratio cannot be computed, as not all distributors have reported valid statistics.</p>\n");
            return;
        }
        boolean hasMaintenance = LegacyIndexPageRequestHandler.stateHasAtLeastOneMaintenanceNode(state);
        if (!hasMaintenance && outOfSync.get() == 0.0) {
            table.appendRaw("<p>Cluster is currently in sync.</p>\n");
        } else {
            table.appendRaw("<p>Cluster is currently <strong>%.2f%% out of sync</strong>.</p>\n".formatted(outOfSync.get() * 100.0));
            if (hasMaintenance) {
                table.appendRaw("<p><strong>Note:</strong> since one or more nodes are currently in Maintenance mode, the true out of sync ratio may be higher.</p>\n");
            }
        }
    }

    private static boolean stateHasAtLeastOneMaintenanceNode(ClusterStateBundle state) {
        ClusterState baseline = state.getBaselineClusterState();
        int nodes = baseline.getNodeCount(NodeType.STORAGE);
        for (int i = 0; i < nodes; ++i) {
            if (!baseline.getNodeState(Node.ofStorage((int)i)).getState().oneOf("m")) continue;
            return true;
        }
        return false;
    }

    private void storeNodeInfo(ContentCluster cluster, int nodeIndex, NodeType nodeType, Map<Integer, NodeInfo> nodeInfoByIndex) {
        NodeInfo nodeInfo = cluster.getNodeInfo(new Node(nodeType, nodeIndex));
        if (nodeInfo == null) {
            return;
        }
        nodeInfoByIndex.put(nodeIndex, nodeInfo);
    }

    public void writeHtmlState(StringBuilder sb, FleetControllerOptions options) {
        Object slobrokspecs = "";
        for (int i = 0; i < options.slobrokConnectionSpecs().length; ++i) {
            if (i != 0) {
                slobrokspecs = (String)slobrokspecs + "<br>";
            }
            slobrokspecs = (String)slobrokspecs + options.slobrokConnectionSpecs()[i];
        }
        sb.append("<h1>Current config</h1>\n").append("<table border=\"1\" cellspacing=\"0\"><tr><th>Property</th><th>Value</th></tr>\n");
        sb.append("<tr><td><nobr>Cluster name</nobr></td><td align=\"right\">").append(LegacyIndexPageRequestHandler.escaped(options.clusterName())).append("</td></tr>");
        sb.append("<tr><td><nobr>Fleet controller index</nobr></td><td align=\"right\">").append(options.fleetControllerIndex()).append("/").append(options.fleetControllerCount()).append("</td></tr>");
        sb.append("<tr><td><nobr>Location broker spec</nobr></td><td align=\"right\">").append(LegacyIndexPageRequestHandler.escaped((String)slobrokspecs)).append("</td></tr>");
        sb.append("<tr><td><nobr>RPC port</nobr></td><td align=\"right\">").append(options.rpcPort() == 0 ? "Pick random available" : Integer.valueOf(options.rpcPort())).append("</td></tr>");
        sb.append("<tr><td><nobr>HTTP port</nobr></td><td align=\"right\">").append(options.httpPort() == 0 ? "Pick random available" : Integer.valueOf(options.httpPort())).append("</td></tr>");
        sb.append("<tr><td><nobr>Master cooldown period</nobr></td><td align=\"right\">").append(RealTimer.printDuration(options.masterZooKeeperCooldownPeriod())).append("</td></tr>");
        String zooKeeperAddress = LegacyIndexPageRequestHandler.splitZooKeeperAddress(options.zooKeeperServerAddress());
        sb.append("<tr><td><nobr>Zookeeper server address</nobr></td><td align=\"right\">").append(LegacyIndexPageRequestHandler.escaped(zooKeeperAddress)).append("</td></tr>");
        sb.append("<tr><td><nobr>Zookeeper session timeout</nobr></td><td align=\"right\">").append(RealTimer.printDuration(options.zooKeeperSessionTimeout())).append("</td></tr>");
        sb.append("<tr><td><nobr>Cycle wait time</nobr></td><td align=\"right\">").append(options.cycleWaitTime()).append(" ms</td></tr>");
        sb.append("<tr><td><nobr>Minimum time before first clusterstate broadcast as master</nobr></td><td align=\"right\">").append(RealTimer.printDuration(options.minTimeBeforeFirstSystemStateBroadcast())).append("</td></tr>");
        sb.append("<tr><td><nobr>Minimum time between official cluster states</nobr></td><td align=\"right\">").append(RealTimer.printDuration(options.minTimeBetweenNewSystemStates())).append("</td></tr>");
        sb.append("<tr><td><nobr>Node state request timeout</nobr></td><td align=\"right\">").append(RealTimer.printDuration(options.nodeStateRequestTimeoutMS())).append("</td></tr>");
        sb.append("<tr><td><nobr>Maximum distributor transition time</nobr></td><td align=\"right\">").append(RealTimer.printDuration(options.maxTransitionTime().get(NodeType.DISTRIBUTOR).intValue())).append("</td></tr>");
        sb.append("<tr><td><nobr>Maximum storage transition time</nobr></td><td align=\"right\">").append(RealTimer.printDuration(options.maxTransitionTime().get(NodeType.STORAGE).intValue())).append("</td></tr>");
        sb.append("<tr><td><nobr>Maximum initialize without progress time</nobr></td><td align=\"right\">").append(RealTimer.printDuration(options.maxInitProgressTime())).append("</td></tr>");
        sb.append("<tr><td><nobr>Maximum premature crashes</nobr></td><td align=\"right\">").append(options.maxPrematureCrashes()).append("</td></tr>");
        sb.append("<tr><td><nobr>Stable state time period</nobr></td><td align=\"right\">").append(RealTimer.printDuration(options.stableStateTimePeriod())).append("</td></tr>");
        sb.append("<tr><td><nobr>Slobrok disconnect grace period</nobr></td><td align=\"right\">").append(RealTimer.printDuration(options.maxSlobrokDisconnectGracePeriod())).append("</td></tr>");
        sb.append("<tr><td><nobr>Number of distributor nodes</nobr></td><td align=\"right\">").append(options.nodes() == null ? "Autodetect" : Integer.valueOf(options.nodes().size())).append("</td></tr>");
        sb.append("<tr><td><nobr>Number of storage nodes</nobr></td><td align=\"right\">").append(options.nodes() == null ? "Autodetect" : Integer.valueOf(options.nodes().size())).append("</td></tr>");
        sb.append("<tr><td><nobr>Minimum distributor nodes being up for cluster to be up</nobr></td><td align=\"right\">").append(options.minDistributorNodesUp()).append("</td></tr>");
        sb.append("<tr><td><nobr>Minimum storage nodes being up for cluster to be up</nobr></td><td align=\"right\">").append(options.minStorageNodesUp()).append("</td></tr>");
        sb.append("<tr><td><nobr>Minimum percentage of distributor nodes being up for cluster to be up</nobr></td><td align=\"right\">").append(DecimalDot2.format(100.0 * options.minRatioOfDistributorNodesUp())).append(" %</td></tr>");
        sb.append("<tr><td><nobr>Minimum percentage of storage nodes being up for cluster to be up</nobr></td><td align=\"right\">").append(DecimalDot2.format(100.0 * options.minRatioOfStorageNodesUp())).append(" %</td></tr>");
        sb.append("<tr><td><nobr>Show local cluster state changes</nobr></td><td align=\"right\">").append(options.showLocalSystemStatesInEventLog()).append("</td></tr>");
        sb.append("<tr><td><nobr>Maximum event log size</nobr></td><td align=\"right\">").append(options.eventLogMaxSize()).append("</td></tr>");
        sb.append("<tr><td><nobr>Maximum node event log size</nobr></td><td align=\"right\">").append(options.eventNodeLogMaxSize()).append("</td></tr>");
        sb.append("<tr><td><nobr>Wanted distribution bits</nobr></td><td align=\"right\">").append(options.distributionBits()).append("</td></tr>");
        sb.append("<tr><td><nobr>Max deferred task version wait time</nobr></td><td align=\"right\">").append(options.maxDeferredTaskVersionWaitTime().toMillis()).append("ms</td></tr>");
        sb.append("<tr><td><nobr>Cluster has global document types configured</nobr></td><td align=\"right\">").append(options.clusterHasGlobalDocumentTypes()).append("</td></tr>");
        sb.append("<tr><td><nobr>Enable 2-phase cluster state activation protocol</nobr></td><td align=\"right\">").append(options.enableTwoPhaseClusterStateActivation()).append("</td></tr>");
        sb.append("<tr><td><nobr>Cluster auto feed block on resource exhaustion enabled</nobr></td><td align=\"right\">").append(options.clusterFeedBlockEnabled()).append("</td></tr>");
        sb.append("<tr><td><nobr>Feed block limits</nobr></td><td align=\"right\">").append(options.clusterFeedBlockLimit().entrySet().stream().map(kv -> String.format("%s: %.2f%%", LegacyIndexPageRequestHandler.escaped((String)kv.getKey()), (Double)kv.getValue() * 100.0)).sorted().collect(Collectors.joining("<br/>"))).append("</td></tr>");
        sb.append("<tr><td><nobr>Feed block noise level (low watermark limit will be feed block limit minus this value)</nobr></td><td align=\"right\">").append(options.clusterFeedBlockNoiseLevel()).append("</td></tr>");
        sb.append("</table>");
    }

    private static String escaped(String input) {
        return HtmlTable.escape(input);
    }

    private static String splitZooKeeperAddress(String s) {
        int index;
        StringBuilder sb = new StringBuilder();
        while ((index = s.indexOf(44)) > 0) {
            sb.append(s.substring(0, index + 1)).append(' ');
            s = s.substring(index + 1);
        }
        sb.append(s);
        return sb.toString();
    }
}

