/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.vdslib.state.ClusterState;
import com.yahoo.vdslib.state.Node;
import com.yahoo.vdslib.state.NodeType;
import com.yahoo.vdslib.state.State;
import com.yahoo.vespa.clustercontroller.core.ContentCluster;
import com.yahoo.vespa.clustercontroller.core.NodeInfo;
import com.yahoo.vespa.clustercontroller.core.ResourceUsageStats;
import com.yahoo.vespa.clustercontroller.core.Timer;
import com.yahoo.vespa.clustercontroller.utils.util.ComponentMetricReporter;
import com.yahoo.vespa.clustercontroller.utils.util.MetricReporter;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.BooleanSupplier;

public class MetricUpdater {
    private final ComponentMetricReporter metricReporter;
    private final Timer timer;
    private Duration stateVersionConvergenceGracePeriod = Duration.ofSeconds(30L);

    public MetricUpdater(MetricReporter metricReporter, Timer timer, int controllerIndex, String clusterName) {
        this.metricReporter = new ComponentMetricReporter(metricReporter, "%s.".formatted("cluster-controller"));
        this.metricReporter.addDimension("controller-index", String.valueOf(controllerIndex));
        this.metricReporter.addDimension("cluster", clusterName);
        this.metricReporter.addDimension("clusterid", clusterName);
        this.timer = timer;
    }

    public MetricReporter.Context createContext(Map<String, String> dimensions) {
        return this.metricReporter.createContext(dimensions);
    }

    public void setStateVersionConvergenceGracePeriod(Duration gracePeriod) {
        this.stateVersionConvergenceGracePeriod = gracePeriod;
    }

    private static int nodesInAvailableState(Map<State, Integer> nodeCounts) {
        return nodeCounts.getOrDefault(State.INITIALIZING, 0) + nodeCounts.getOrDefault(State.RETIRED, 0) + nodeCounts.getOrDefault(State.UP, 0) + nodeCounts.getOrDefault(State.MAINTENANCE, 0);
    }

    public void updateClusterStateMetrics(ContentCluster cluster, ClusterState state, ResourceUsageStats resourceUsage, Instant lastStateBroadcastTimePoint) {
        HashMap<String, String> dimensions = new HashMap<String, String>();
        Instant now = this.timer.getCurrentWallClockTime();
        int effectiveStateVersion = state.getVersion() > 0 ? state.getVersion() : -1;
        boolean convergenceDeadlinePassed = lastStateBroadcastTimePoint.plus(this.stateVersionConvergenceGracePeriod).isBefore(now);
        for (NodeType type : NodeType.getTypes()) {
            dimensions.put("node-type", type.toString().toLowerCase());
            MetricReporter.Context context = this.createContext(dimensions);
            HashMap<State, Integer> nodeCounts = new HashMap<State, Integer>();
            for (State s : State.values()) {
                nodeCounts.put(s, 0);
            }
            int nodesNotConverged = 0;
            for (Integer i : cluster.getConfiguredNodes().keySet()) {
                Node node = new Node(type, i.intValue());
                State s = state.getNodeState(node);
                Integer count = (Integer)nodeCounts.get(s.getState());
                nodeCounts.put(s.getState(), count + 1);
                NodeInfo info = cluster.getNodeInfo(node);
                if (info == null || !convergenceDeadlinePassed || !s.getState().oneOf("uir") || info.getClusterStateVersionBundleAcknowledged() == effectiveStateVersion) continue;
                ++nodesNotConverged;
            }
            for (State s : State.values()) {
                String name = s.toString().toLowerCase() + ".count";
                this.metricReporter.set(name, (Number)nodeCounts.get(s), context);
            }
            int availableNodes = MetricUpdater.nodesInAvailableState(nodeCounts);
            int totalNodes = Math.max(cluster.getConfiguredNodes().size(), 1);
            this.metricReporter.set("available-nodes.ratio", (Number)((double)availableNodes / (double)totalNodes), context);
            this.metricReporter.set("nodes-not-converged", (Number)nodesNotConverged, context);
        }
        dimensions.remove("node-type");
        MetricReporter.Context context = this.createContext(dimensions);
        this.metricReporter.add("cluster-state-change", (Number)1, context);
        this.metricReporter.set("resource_usage.max_disk_utilization", (Number)resourceUsage.getMaxDiskUtilization(), context);
        this.metricReporter.set("resource_usage.max_memory_utilization", (Number)resourceUsage.getMaxMemoryUtilization(), context);
        this.metricReporter.set("resource_usage.nodes_above_limit", (Number)resourceUsage.getNodesAboveLimit(), context);
        this.metricReporter.set("resource_usage.disk_limit", (Number)resourceUsage.getDiskLimit(), context);
        this.metricReporter.set("resource_usage.memory_limit", (Number)resourceUsage.getMemoryLimit(), context);
    }

    public void updateMasterElectionMetrics(Map<Integer, Integer> data) {
        HashMap<Integer, Integer> voteCounts = new HashMap<Integer, Integer>();
        for (Integer i : data.values()) {
            int count = voteCounts.get(i) == null ? 0 : (Integer)voteCounts.get(i);
            voteCounts.put(i, count + 1);
        }
        TreeSet counts = new TreeSet(voteCounts.values());
        if (counts.size() > 1 && (Integer)counts.first() > (Integer)counts.last()) {
            throw new IllegalStateException("Assumed smallest count is sorted first");
        }
        int maxCount = counts.isEmpty() ? 0 : (Integer)counts.last();
        this.metricReporter.set("agreed-master-votes", (Number)maxCount);
    }

    public void updateMasterState(boolean isMaster) {
        this.metricReporter.set("is-master", (Number)(isMaster ? 1 : 0));
        if (!isMaster) {
            this.resetNodeStateAndResourceUsageMetricsToZero();
        }
    }

    private void resetNodeStateAndResourceUsageMetricsToZero() {
        for (NodeType type : NodeType.getTypes()) {
            Map<String, String> dimensions = Map.of("node-type", type.toString().toLowerCase());
            MetricReporter.Context context = this.createContext(dimensions);
            for (State s : State.values()) {
                String name = s.toString().toLowerCase() + ".count";
                this.metricReporter.set(name, (Number)0, context);
            }
            this.metricReporter.set("nodes-not-converged", (Number)0, context);
        }
    }

    public void updateClusterBucketsOutOfSyncRatio(double ratio) {
        this.metricReporter.set("cluster-buckets-out-of-sync-ratio", (Number)ratio);
    }

    public void updateClusterDocumentMetrics(long docsTotal, long bytesTotal) {
        this.metricReporter.set("stored-document-count", (Number)docsTotal);
        this.metricReporter.set("stored-document-bytes", (Number)bytesTotal);
    }

    public void addTickTime(long millis, boolean didWork) {
        if (didWork) {
            this.metricReporter.set("busy-tick-time-ms", (Number)millis);
        } else {
            this.metricReporter.set("idle-tick-time-ms", (Number)millis);
        }
    }

    public void recordNewNodeEvent() {
        this.metricReporter.add("node-event", (Number)1);
    }

    public void updateRemoteTaskQueueSize(int size) {
        this.metricReporter.set("remote-task-queue.size", (Number)size);
    }

    public boolean forWork(String workId, BooleanSupplier work) {
        long startNanos = System.nanoTime();
        boolean didWork = work.getAsBoolean();
        double seconds = (double)Duration.ofNanos(System.nanoTime() - startNanos).toMillis() / 1000.0;
        MetricReporter.Context context = this.createContext(Map.of("didWork", Boolean.toString(didWork), "workId", workId));
        this.metricReporter.set("work-ms", (Number)seconds, context);
        return didWork;
    }
}

