/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core.hostinfo;

import com.yahoo.vespa.clustercontroller.core.ContentClusterErrorStats;
import com.yahoo.vespa.clustercontroller.core.ContentClusterStats;
import com.yahoo.vespa.clustercontroller.core.ContentNodeErrorStats;
import com.yahoo.vespa.clustercontroller.core.ContentNodeStats;
import com.yahoo.vespa.clustercontroller.core.hostinfo.Distributor;
import com.yahoo.vespa.clustercontroller.core.hostinfo.StorageNode;
import java.util.HashMap;
import java.util.Optional;

public class StorageNodeStatsBridge {
    private StorageNodeStatsBridge() {
    }

    public static ContentClusterStats generate(Distributor distributor) {
        HashMap<Integer, ContentNodeStats> mapToNodeStats = new HashMap<Integer, ContentNodeStats>();
        for (StorageNode storageNode : distributor.getStorageNodes()) {
            mapToNodeStats.put(storageNode.getIndex(), new ContentNodeStats(storageNode));
        }
        long docsTotal = Optional.ofNullable(distributor.documentCountTotalOrNull()).orElse(0L);
        long bytesTotal = Optional.ofNullable(distributor.bytesTotalOrNull()).orElse(0L);
        return new ContentClusterStats(docsTotal, bytesTotal, mapToNodeStats);
    }

    public static ContentClusterErrorStats generateErrors(int distributorIndex, Distributor distributor) {
        HashMap<Integer, ContentNodeErrorStats> nodeErrorStats = new HashMap<Integer, ContentNodeErrorStats>();
        for (StorageNode storageNode : distributor.getStorageNodes()) {
            if (!storageNode.getResponseStats().hasNetworkErrors()) continue;
            ContentNodeErrorStats nodeErrors = new ContentNodeErrorStats(storageNode.getIndex());
            nodeErrors.getStatsFromDistributors().put(distributorIndex, ContentNodeErrorStats.DistributorErrorStats.fromHostInfoStats(storageNode.getResponseStats()));
            nodeErrorStats.put(storageNode.getIndex(), nodeErrors);
        }
        return new ContentClusterErrorStats(nodeErrorStats);
    }
}

