/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.vdslib.state.ClusterState;
import com.yahoo.vespa.clustercontroller.core.AnnotatedClusterState;
import com.yahoo.vespa.clustercontroller.core.ClusterStateDeriver;
import com.yahoo.vespa.clustercontroller.core.DistributionConfigBundle;
import com.yahoo.vespa.clustercontroller.core.NodeResourceExhaustion;
import com.yahoo.vespa.config.content.StorDistributionConfig;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ClusterStateBundle {
    private final AnnotatedClusterState baselineState;
    private final Map<String, AnnotatedClusterState> derivedBucketSpaceStates;
    private final DistributionConfigBundle distributionConfig;
    private final FeedBlock feedBlock;
    private final boolean deferredActivation;

    private ClusterStateBundle(AnnotatedClusterState baselineState, Map<String, AnnotatedClusterState> derivedBucketSpaceStates) {
        this(baselineState, derivedBucketSpaceStates, null, null, false);
    }

    private ClusterStateBundle(AnnotatedClusterState baselineState, Map<String, AnnotatedClusterState> derivedBucketSpaceStates, DistributionConfigBundle distributionConfig, FeedBlock feedBlock, boolean deferredActivation) {
        this.baselineState = baselineState;
        this.derivedBucketSpaceStates = Map.copyOf(derivedBucketSpaceStates);
        this.distributionConfig = distributionConfig;
        this.feedBlock = feedBlock;
        this.deferredActivation = deferredActivation;
    }

    public static Builder builder(AnnotatedClusterState baselineState) {
        return new Builder(baselineState);
    }

    public static ClusterStateBundle of(AnnotatedClusterState baselineState, Map<String, AnnotatedClusterState> derivedBucketSpaceStates) {
        return new ClusterStateBundle(baselineState, derivedBucketSpaceStates);
    }

    public static ClusterStateBundle of(AnnotatedClusterState baselineState, Map<String, AnnotatedClusterState> derivedBucketSpaceStates, FeedBlock feedBlock, boolean deferredActivation) {
        return new ClusterStateBundle(baselineState, derivedBucketSpaceStates, null, feedBlock, deferredActivation);
    }

    public static ClusterStateBundle of(AnnotatedClusterState baselineState, Map<String, AnnotatedClusterState> derivedBucketSpaceStates, FeedBlock feedBlock, DistributionConfigBundle distributionConfig, boolean deferredActivation) {
        return new ClusterStateBundle(baselineState, derivedBucketSpaceStates, distributionConfig, feedBlock, deferredActivation);
    }

    public static ClusterStateBundle ofBaselineOnly(AnnotatedClusterState baselineState, FeedBlock feedBlock, boolean deferredActivation) {
        return new ClusterStateBundle(baselineState, Map.of(), null, feedBlock, deferredActivation);
    }

    public static ClusterStateBundle ofBaselineOnly(AnnotatedClusterState baselineState, DistributionConfigBundle distributionConfig, FeedBlock feedBlock, boolean deferredActivation) {
        return new ClusterStateBundle(baselineState, Map.of(), distributionConfig, feedBlock, deferredActivation);
    }

    public static ClusterStateBundle ofBaselineOnly(AnnotatedClusterState baselineState) {
        return new ClusterStateBundle(baselineState, Map.of());
    }

    public static ClusterStateBundle empty() {
        return ClusterStateBundle.ofBaselineOnly(AnnotatedClusterState.emptyState());
    }

    public AnnotatedClusterState getBaselineAnnotatedState() {
        return this.baselineState;
    }

    public ClusterState getBaselineClusterState() {
        return this.baselineState.getClusterState();
    }

    public Map<String, AnnotatedClusterState> getDerivedBucketSpaceStates() {
        return this.derivedBucketSpaceStates;
    }

    public boolean deferredActivation() {
        return this.deferredActivation;
    }

    public ClusterStateBundle cloneWithMapper(Function<ClusterState, ClusterState> mapper) {
        AnnotatedClusterState clonedBaseline = this.baselineState.cloneWithClusterState(mapper.apply(this.baselineState.getClusterState().clone()));
        Map<String, AnnotatedClusterState> clonedDerived = this.derivedBucketSpaceStates.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((AnnotatedClusterState)e.getValue()).cloneWithClusterState((ClusterState)mapper.apply(((AnnotatedClusterState)e.getValue()).getClusterState().clone()))));
        return new ClusterStateBundle(clonedBaseline, clonedDerived, this.distributionConfig, this.feedBlock, this.deferredActivation);
    }

    public ClusterStateBundle clonedWithVersionSet(int version) {
        return this.cloneWithMapper(state -> {
            state.setVersion(version);
            return state;
        });
    }

    public boolean similarTo(ClusterStateBundle other) {
        if (!this.baselineState.getClusterState().similarToIgnoringInitProgress(other.baselineState.getClusterState())) {
            return false;
        }
        if (this.clusterFeedIsBlocked() != other.clusterFeedIsBlocked()) {
            return false;
        }
        if (this.clusterFeedIsBlocked() && !this.feedBlock.similarTo(other.feedBlock)) {
            return false;
        }
        if (!Objects.equals(this.distributionConfig, other.distributionConfig)) {
            return false;
        }
        return this.derivedBucketSpaceStates.entrySet().stream().allMatch(entry -> other.derivedBucketSpaceStates.getOrDefault(entry.getKey(), (AnnotatedClusterState)entry.getValue()).getClusterState().similarToIgnoringInitProgress(((AnnotatedClusterState)entry.getValue()).getClusterState()));
    }

    public int getVersion() {
        return this.baselineState.getClusterState().getVersion();
    }

    public Optional<DistributionConfigBundle> distributionConfig() {
        return Optional.ofNullable(this.distributionConfig);
    }

    public Optional<FeedBlock> getFeedBlock() {
        return Optional.ofNullable(this.feedBlock);
    }

    public FeedBlock getFeedBlockOrNull() {
        return this.feedBlock;
    }

    public boolean clusterFeedIsBlocked() {
        return this.feedBlock != null && this.feedBlock.blockFeedInCluster();
    }

    public String toString() {
        String distributionConfigStr;
        String feedBlockedStr = this.clusterFeedIsBlocked() ? String.format(", feed blocked: '%s'", this.feedBlock.description) : "";
        String string = distributionConfigStr = this.distributionConfig != null ? ", distribution config: %s".formatted(this.distributionConfig.highLevelDescription()) : "";
        if (this.derivedBucketSpaceStates.isEmpty()) {
            return String.format("ClusterStateBundle('%s'%s%s%s)", this.baselineState, this.deferredActivation ? " (deferred activation)" : "", feedBlockedStr, distributionConfigStr);
        }
        TreeMap<String, AnnotatedClusterState> orderedStates = new TreeMap<String, AnnotatedClusterState>(this.derivedBucketSpaceStates);
        return String.format("ClusterStateBundle('%s', %s%s%s%s)", this.baselineState, orderedStates.entrySet().stream().map(e -> String.format("%s '%s'", e.getKey(), e.getValue())).collect(Collectors.joining(", ")), this.deferredActivation ? " (deferred activation)" : "", feedBlockedStr, distributionConfigStr);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterStateBundle that = (ClusterStateBundle)o;
        return this.deferredActivation == that.deferredActivation && Objects.equals(this.baselineState, that.baselineState) && Objects.equals(this.derivedBucketSpaceStates, that.derivedBucketSpaceStates) && Objects.equals(this.distributionConfig, that.distributionConfig) && Objects.equals(this.feedBlock, that.feedBlock);
    }

    public int hashCode() {
        return Objects.hash(this.baselineState, this.derivedBucketSpaceStates, this.distributionConfig, this.feedBlock, this.deferredActivation);
    }

    public static class FeedBlock {
        private final boolean blockFeedInCluster;
        private final String description;
        private final Set<NodeResourceExhaustion> concreteExhaustions;

        public FeedBlock(boolean blockFeedInCluster, String description) {
            this.blockFeedInCluster = blockFeedInCluster;
            this.description = description;
            this.concreteExhaustions = Set.of();
        }

        public FeedBlock(boolean blockFeedInCluster, String description, Set<NodeResourceExhaustion> concreteExhaustions) {
            this.blockFeedInCluster = blockFeedInCluster;
            this.description = description;
            this.concreteExhaustions = concreteExhaustions;
        }

        public static FeedBlock blockedWithDescription(String desc) {
            return new FeedBlock(true, desc);
        }

        public static FeedBlock blockedWith(String description, Set<NodeResourceExhaustion> concreteExhaustions) {
            return new FeedBlock(true, description, concreteExhaustions);
        }

        public boolean blockFeedInCluster() {
            return this.blockFeedInCluster;
        }

        public String getDescription() {
            return this.description;
        }

        public Set<NodeResourceExhaustion> getConcreteExhaustions() {
            return this.concreteExhaustions;
        }

        public boolean similarTo(FeedBlock other) {
            return this.blockFeedInCluster == other.blockFeedInCluster && Objects.equals(this.concreteExhaustions, other.concreteExhaustions);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FeedBlock feedBlock = (FeedBlock)o;
            return this.blockFeedInCluster == feedBlock.blockFeedInCluster && Objects.equals(this.description, feedBlock.description) && Objects.equals(this.concreteExhaustions, feedBlock.concreteExhaustions);
        }

        public int hashCode() {
            return Objects.hash(this.blockFeedInCluster, this.description, this.concreteExhaustions);
        }
    }

    public static class Builder {
        private final AnnotatedClusterState baselineState;
        private Map<String, AnnotatedClusterState> explicitDerivedStates;
        private DistributionConfigBundle distributionConfig;
        private ClusterStateDeriver stateDeriver;
        private Set<String> bucketSpaces;
        private boolean deferredActivation = false;
        private FeedBlock feedBlock = null;

        public Builder(AnnotatedClusterState baselineState) {
            this.baselineState = baselineState;
        }

        public Builder stateDeriver(ClusterStateDeriver stateDeriver) {
            this.stateDeriver = stateDeriver;
            return this;
        }

        public Builder bucketSpaces(Set<String> bucketSpaces) {
            if (this.explicitDerivedStates != null) {
                throw new IllegalStateException("Cannot set bucket spaces on Builder that already has explicit derived states set");
            }
            this.bucketSpaces = bucketSpaces;
            return this;
        }

        public Builder bucketSpaces(String ... bucketSpaces) {
            return this.bucketSpaces(new TreeSet<String>(List.of(bucketSpaces)));
        }

        public Builder explicitDerivedStates(Map<String, AnnotatedClusterState> derivedStates) {
            if (this.bucketSpaces != null || this.stateDeriver != null) {
                throw new IllegalStateException("Cannot set explicitly derived states on Builder that already has bucket spaces or deriver set");
            }
            this.explicitDerivedStates = derivedStates;
            return this;
        }

        public Builder distributionConfig(StorDistributionConfig config) {
            this.distributionConfig = DistributionConfigBundle.of(config);
            return this;
        }

        public Builder distributionConfig(DistributionConfigBundle config) {
            this.distributionConfig = config;
            return this;
        }

        public Builder deferredActivation(boolean deferred) {
            this.deferredActivation = deferred;
            return this;
        }

        public Builder feedBlock(FeedBlock fb) {
            this.feedBlock = fb;
            return this;
        }

        public ClusterStateBundle deriveAndBuild() {
            if ((this.stateDeriver == null || this.bucketSpaces == null || this.bucketSpaces.isEmpty()) && this.explicitDerivedStates == null) {
                return ClusterStateBundle.ofBaselineOnly(this.baselineState, this.distributionConfig, this.feedBlock, this.deferredActivation);
            }
            Map derived = Objects.requireNonNullElseGet(this.explicitDerivedStates, () -> this.bucketSpaces.stream().collect(Collectors.toUnmodifiableMap(Function.identity(), s -> this.stateDeriver.derivedFrom(this.baselineState, (String)s))));
            return new ClusterStateBundle(this.baselineState, derived, this.distributionConfig, this.feedBlock, this.deferredActivation);
        }
    }
}

