/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core.hostinfo;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

public record ResponseStats(double sampleWindowSec, long totalResponseCount, long networkErrorCount, long clockSkewErrorCount, long uncategorizedErrorCount) {
    @JsonCreator
    public ResponseStats(@JsonProperty(value="sample-window-sec") Double sampleWindowSec, @JsonProperty(value="total-count") Long totalResponseCount, @JsonProperty(value="errors") Errors errors) {
        this(Math.max(sampleWindowSec != null ? sampleWindowSec : 60.0, 1.0), totalResponseCount != null ? totalResponseCount : 0L, errors != null ? ResponseStats.valueOrZero(errors.network) : 0L, errors != null ? ResponseStats.valueOrZero(errors.clockSkew) : 0L, errors != null ? ResponseStats.valueOrZero(errors.uncategorized) : 0L);
    }

    private static long valueOrZero(Long valOrNull) {
        return valOrNull != null ? valOrNull : 0L;
    }

    public static ResponseStats makeEmpty() {
        return new ResponseStats(60.0, 0L, 0L, 0L, 0L);
    }

    public boolean hasNetworkErrors() {
        return this.networkErrorCount > 0L;
    }

    public boolean hasClockSkewErrors() {
        return this.clockSkewErrorCount > 0L;
    }

    public boolean hasUncategorizedErrors() {
        return this.uncategorizedErrorCount > 0L;
    }

    public boolean hasErrors() {
        return this.hasNetworkErrors() || this.hasClockSkewErrors() || this.hasUncategorizedErrors();
    }

    public record Errors(@JsonProperty(value="network") Long network, @JsonProperty(value="clock-skew") Long clockSkew, @JsonProperty(value="uncategorized") Long uncategorized) {
    }
}

