/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.vespa.clustercontroller.core.ContentNodeStats;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public record ContentClusterStats(long documentCountTotal, long bytesTotal, Map<Integer, ContentNodeStats> mapToNodeStats) implements Iterable<ContentNodeStats>
{
    public ContentClusterStats(long documentCountTotal, long bytesTotal, Set<Integer> storageNodes) {
        this(documentCountTotal, bytesTotal, ContentClusterStats.toEmptyNodeStats(storageNodes));
    }

    public ContentClusterStats(Set<Integer> storageNodes) {
        this(0L, 0L, storageNodes);
    }

    public ContentClusterStats(Map<Integer, ContentNodeStats> mapToNodeStats) {
        this(0L, 0L, mapToNodeStats);
    }

    private static Map<Integer, ContentNodeStats> toEmptyNodeStats(Set<Integer> storageNodes) {
        HashMap<Integer, ContentNodeStats> mapToNodeStats = new HashMap<Integer, ContentNodeStats>(storageNodes.size());
        for (Integer index : storageNodes) {
            mapToNodeStats.put(index, new ContentNodeStats(index));
        }
        return mapToNodeStats;
    }

    @Override
    public Iterator<ContentNodeStats> iterator() {
        return this.mapToNodeStats.values().iterator();
    }

    public long getDocumentCountTotal() {
        return this.documentCountTotal;
    }

    public long getBytesTotal() {
        return this.bytesTotal;
    }

    public ContentNodeStats getNodeStats(Integer index) {
        return this.mapToNodeStats.get(index);
    }

    public int size() {
        return this.mapToNodeStats.size();
    }
}

