/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.vespa.clustercontroller.core.ContentNodeStats;
import java.util.Optional;

public class GlobalBucketSyncStatsCalculator {
    public static Optional<Double> clusterBucketsOutOfSyncRatio(ContentNodeStats globalStats) {
        long totalBuckets = 0L;
        long pendingBuckets = 0L;
        for (ContentNodeStats.BucketSpaceStats space : globalStats.getBucketSpaces().values()) {
            if (!space.valid()) {
                return Optional.empty();
            }
            totalBuckets += space.getBucketsTotal();
            pendingBuckets += space.getBucketsPending();
        }
        pendingBuckets = Math.min(pendingBuckets, totalBuckets);
        if (totalBuckets <= 0L) {
            return Optional.of(0.0);
        }
        return Optional.of((double)pendingBuckets / (double)totalBuckets);
    }
}

