/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core.restapiv2.requests;

import com.yahoo.vespa.clustercontroller.core.RemoteClusterControllerTask;
import com.yahoo.vespa.clustercontroller.core.restapiv2.Id;
import com.yahoo.vespa.clustercontroller.core.restapiv2.Request;
import com.yahoo.vespa.clustercontroller.core.restapiv2.Response;
import com.yahoo.vespa.clustercontroller.core.restapiv2.requests.NodeStateRequest;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.errors.StateRestApiException;

public class ServiceStateRequest
extends Request<Response.ServiceResponse> {
    private final Id.Service id;
    private final int recursive;

    public ServiceStateRequest(Id.Service id, int recursive) {
        super(Request.MasterState.MUST_BE_MASTER);
        this.id = id;
        this.recursive = recursive;
    }

    @Override
    public Response.ServiceResponse calculateResult(RemoteClusterControllerTask.Context context) throws StateRestApiException {
        Response.ServiceResponse result = new Response.ServiceResponse();
        for (Integer i : context.cluster.getConfiguredNodes().keySet()) {
            Id.Node nodeId = new Id.Node(this.id, i);
            if (this.recursive > 0) {
                NodeStateRequest nsr = new NodeStateRequest(nodeId);
                result.addEntry("node", String.valueOf(i), nsr.calculateResult(context));
                continue;
            }
            result.addLink("node", String.valueOf(i), nodeId.toString());
        }
        return result;
    }
}

