/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.jrt.Spec;
import com.yahoo.vdslib.state.Node;
import com.yahoo.vespa.clustercontroller.core.hostinfo.ResourceUsage;
import java.util.Locale;
import java.util.Objects;

public class NodeResourceExhaustion {
    public final Node node;
    public final String resourceType;
    public final ResourceUsage resourceUsage;
    public final Limit limit;
    public final String rpcAddress;

    public NodeResourceExhaustion(Node node, String resourceType, ResourceUsage resourceUsage, Limit limit, String rpcAddress) {
        this.node = node;
        this.resourceType = resourceType;
        this.resourceUsage = resourceUsage;
        this.limit = limit;
        this.rpcAddress = rpcAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeResourceExhaustion that = (NodeResourceExhaustion)o;
        return Objects.equals(this.limit, that.limit) && Objects.equals(this.node, that.node) && Objects.equals(this.resourceType, that.resourceType) && Objects.equals(this.resourceUsage, that.resourceUsage) && Objects.equals(this.rpcAddress, that.rpcAddress);
    }

    public int hashCode() {
        return Objects.hash(this.node, this.resourceType, this.resourceUsage, this.limit, this.rpcAddress);
    }

    public String toExhaustionAddedDescription() {
        String extraInfo = this.limit.isBlocked() && this.limit.noiseLevel() > 0.001 ? String.format(Locale.US, ", effective limit lowered to %.1f%% until feed unblocked", this.limit.effectiveLimit() * 100.0) : "";
        return String.format(Locale.US, "%s is %.1f%% full (the configured limit is %.1f%%%s)", this.makeDescriptionPrefix(), this.resourceUsage.getUsage() * 100.0, this.limit.configuredLimit * 100.0, extraInfo);
    }

    public String toExhaustionRemovedDescription() {
        return String.format(Locale.US, "%s (<= %.1f%%)", this.makeDescriptionPrefix(), this.limit.configuredLimit * 100.0);
    }

    public String toShorthandDescription() {
        return String.format(Locale.US, "%s%s %.1f%% > %.1f%%", this.resourceType, this.resourceUsage.getName() != null ? ":" + this.resourceUsage.getName() : "", this.resourceUsage.getUsage() * 100.0, this.limit.configuredLimit * 100.0);
    }

    private String makeDescriptionPrefix() {
        return String.format(Locale.US, "%s%s on node %d [%s]", this.resourceType, this.resourceUsage.getName() != null ? ":" + this.resourceUsage.getName() : "", this.node.getIndex(), NodeResourceExhaustion.inferHostnameFromRpcAddress(this.rpcAddress));
    }

    private static String inferHostnameFromRpcAddress(String rpcAddress) {
        if (rpcAddress == null) {
            return "unknown hostname";
        }
        Spec spec = new Spec(rpcAddress);
        if (spec.malformed()) {
            return "unknown hostname";
        }
        return spec.host();
    }

    public record Limit(double configuredLimit, double noiseLevel, boolean isBlocked) {
        double effectiveLimit() {
            return this.isBlocked ? Math.max(this.configuredLimit - this.noiseLevel, 0.0) : this.configuredLimit;
        }
    }
}

