/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.vespa.clustercontroller.core.Event;
import com.yahoo.vespa.clustercontroller.core.NodeInfo;
import java.util.Optional;

public class NodeEvent
implements Event {
    private final NodeInfo node;
    private final String description;
    private final long eventTime;
    private final Optional<String> bucketSpace;
    private final Type type;

    private NodeEvent(NodeInfo node, String description, Type type, long currentTime) {
        this.node = node;
        this.description = description;
        this.eventTime = currentTime;
        this.type = type;
        this.bucketSpace = Optional.empty();
    }

    private NodeEvent(NodeInfo node, String bucketSpace, String description, Type type, long currentTime) {
        this.node = node;
        this.description = description;
        this.eventTime = currentTime;
        this.type = type;
        this.bucketSpace = Optional.of(bucketSpace);
    }

    public static NodeEvent forBaseline(NodeInfo node, String description, Type type, long currentTime) {
        return new NodeEvent(node, description, type, currentTime);
    }

    public static NodeEvent forBucketSpace(NodeInfo node, String bucketSpace, String description, Type type, long currentTime) {
        return new NodeEvent(node, bucketSpace, description, type, currentTime);
    }

    public NodeInfo getNode() {
        return this.node;
    }

    @Override
    public long getTimeMs() {
        return this.eventTime;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "Event: " + this.getNodeBucketSpaceDescription() + ": " + this.description;
    }

    private String getNodeBucketSpaceDescription() {
        if (this.bucketSpace.isPresent()) {
            return String.valueOf(this.node.getNode()) + " (" + this.bucketSpace.get() + ")";
        }
        return this.node.getNode().toString();
    }

    @Override
    public String getCategory() {
        return this.type.toString();
    }

    public Type getType() {
        return this.type;
    }

    public Optional<String> getBucketSpace() {
        return this.bucketSpace;
    }

    public static enum Type {
        REPORTED,
        CURRENT,
        WANTED;

    }
}

