/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.config.ConfigInstance;
import com.yahoo.config.InnerNode;
import com.yahoo.config.Serializer;
import com.yahoo.config.subscription.ConfigInstanceSerializer;
import com.yahoo.slime.Slime;
import com.yahoo.vdslib.distribution.Distribution;
import com.yahoo.vdslib.distribution.Group;
import com.yahoo.vdslib.distribution.GroupVisitor;
import com.yahoo.vespa.config.content.StorDistributionConfig;
import java.util.Objects;

public class DistributionConfigBundle {
    private final StorDistributionConfig config;
    private final String canonicalStringRepr;
    private final Slime precomputedSlimeRepr;
    private final Distribution distribution;
    private final int groupsTotal;
    private final int nodesTotal;

    public DistributionConfigBundle(StorDistributionConfig config) {
        Objects.requireNonNull(config);
        this.config = config;
        this.canonicalStringRepr = config.toString();
        this.precomputedSlimeRepr = new Slime();
        ConfigInstance.serialize((InnerNode)config, (Serializer)new ConfigInstanceSerializer(this.precomputedSlimeRepr, this.precomputedSlimeRepr.setObject()));
        this.distribution = new Distribution(config);
        var gv = new GroupVisitor(){
            int groupsTotal = 0;
            int nodesTotal = 0;

            public boolean visitGroup(Group g) {
                if (g.isLeafGroup()) {
                    ++this.groupsTotal;
                    this.nodesTotal += g.getNodes().size();
                }
                return true;
            }
        };
        this.distribution.visitGroups(gv);
        this.groupsTotal = gv.groupsTotal;
        this.nodesTotal = gv.nodesTotal;
    }

    public static DistributionConfigBundle of(StorDistributionConfig config) {
        return new DistributionConfigBundle(config);
    }

    public StorDistributionConfig config() {
        return this.config;
    }

    public Slime precomputedSlimeRepr() {
        return this.precomputedSlimeRepr;
    }

    public Distribution distribution() {
        return this.distribution;
    }

    public int totalLeafGroupCount() {
        return this.groupsTotal;
    }

    public int totalNodeCount() {
        return this.nodesTotal;
    }

    public int redundancy() {
        return this.config.redundancy();
    }

    public int searchableCopies() {
        return this.config.ready_copies();
    }

    public String highLevelDescription() {
        return "%d nodes; %d groups; redundancy %d; searchable-copies %d".formatted(this.totalNodeCount(), this.totalLeafGroupCount(), this.redundancy(), this.searchableCopies());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DistributionConfigBundle that = (DistributionConfigBundle)o;
        return Objects.equals(this.canonicalStringRepr, that.canonicalStringRepr);
    }

    public int hashCode() {
        return this.canonicalStringRepr.hashCode();
    }

    public String toString() {
        return this.canonicalStringRepr;
    }
}

