/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.vespa.clustercontroller.core.ContentNodeStats;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ContentClusterStats
implements Iterable<ContentNodeStats> {
    private final long documentCountTotal;
    private final long bytesTotal;
    private final Map<Integer, ContentNodeStats> mapToNodeStats;

    public ContentClusterStats(long documentCountTotal, long bytesTotal, Set<Integer> storageNodes) {
        this.documentCountTotal = documentCountTotal;
        this.bytesTotal = bytesTotal;
        this.mapToNodeStats = new HashMap<Integer, ContentNodeStats>(storageNodes.size());
        for (Integer index : storageNodes) {
            this.mapToNodeStats.put(index, new ContentNodeStats(index));
        }
    }

    public ContentClusterStats(Set<Integer> storageNodes) {
        this(0L, 0L, storageNodes);
    }

    public ContentClusterStats(long documentCountTotal, long bytesTotal, Map<Integer, ContentNodeStats> mapToNodeStats) {
        this.documentCountTotal = documentCountTotal;
        this.bytesTotal = bytesTotal;
        this.mapToNodeStats = mapToNodeStats;
    }

    public ContentClusterStats(Map<Integer, ContentNodeStats> mapToNodeStats) {
        this(0L, 0L, mapToNodeStats);
    }

    @Override
    public Iterator<ContentNodeStats> iterator() {
        return this.mapToNodeStats.values().iterator();
    }

    public long getDocumentCountTotal() {
        return this.documentCountTotal;
    }

    public long getBytesTotal() {
        return this.bytesTotal;
    }

    public ContentNodeStats getNodeStats(Integer index) {
        return this.mapToNodeStats.get(index);
    }

    public int size() {
        return this.mapToNodeStats.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContentClusterStats that = (ContentClusterStats)o;
        return Objects.equals(this.mapToNodeStats, that.mapToNodeStats);
    }

    public int hashCode() {
        return Objects.hash(this.mapToNodeStats);
    }

    public String toString() {
        return String.format("{mapToNodeStats=[%s]}", Arrays.toString(this.mapToNodeStats.entrySet().toArray()));
    }
}

