/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.vespa.clustercontroller.core.DistributionConfigBundle;
import com.yahoo.vespa.clustercontroller.core.DistributionDiff;
import com.yahoo.vespa.config.content.StorDistributionConfig;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class DistributionDiffCalculator {
    public static DistributionDiff computeDiff(DistributionConfigBundle oldCfg, DistributionConfigBundle newCfg) {
        return new DistributionDiff(DistributionDiffCalculator.computeGroupDiff(oldCfg, newCfg), DistributionDiff.IntegerDiff.of(oldCfg.totalLeafGroupCount(), newCfg.totalLeafGroupCount()), DistributionDiff.IntegerDiff.of(oldCfg.redundancy(), newCfg.redundancy()), DistributionDiff.IntegerDiff.of(oldCfg.searchableCopies(), newCfg.searchableCopies()));
    }

    private static TreeMap<String, DistributionDiff.NodeDiff> computeGroupDiff(DistributionConfigBundle oldCfg, DistributionConfigBundle newCfg) {
        TreeMap<String, GroupNodes> oldGroupNodes = DistributionDiffCalculator.enumerateGroupNodes(oldCfg);
        TreeMap<String, GroupNodes> newGroupNodes = DistributionDiffCalculator.enumerateGroupNodes(newCfg);
        HashSet<String> unionLeafGroupNames = new HashSet<String>(oldGroupNodes.keySet());
        unionLeafGroupNames.addAll(newGroupNodes.keySet());
        GroupNodes emptySentinel = new GroupNodes(Set.of());
        TreeMap<String, DistributionDiff.NodeDiff> diff = new TreeMap<String, DistributionDiff.NodeDiff>();
        for (String leafName : unionLeafGroupNames) {
            GroupNodes oldG = oldGroupNodes.getOrDefault(leafName, emptySentinel);
            GroupNodes newG = newGroupNodes.getOrDefault(leafName, emptySentinel);
            diff.put(leafName, oldG.sortedDiff(newG));
        }
        return diff;
    }

    private static TreeMap<String, GroupNodes> enumerateGroupNodes(DistributionConfigBundle cfg) {
        TreeMap<String, GroupNodes> groups = new TreeMap<String, GroupNodes>();
        for (StorDistributionConfig.Group g : cfg.config().group()) {
            String name = "invalid".equals(g.index()) ? "root group" : "group %s".formatted(g.index());
            groups.put(name, new GroupNodes(g.nodes().stream().map(n -> n.index()).collect(Collectors.toSet())));
        }
        return groups;
    }

    private record GroupNodes(Set<Integer> nodes) {
        DistributionDiff.NodeDiff sortedDiff(GroupNodes other) {
            List<Integer> added = other.nodes.stream().filter(n -> !this.nodes.contains(n)).sorted().toList();
            List<Integer> removed = this.nodes.stream().filter(n -> !other.nodes.contains(n)).sorted().toList();
            return new DistributionDiff.NodeDiff(added, removed);
        }
    }
}

