/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.vdslib.state.ClusterState;
import com.yahoo.vdslib.state.Node;
import com.yahoo.vespa.clustercontroller.core.ClusterStateReason;
import com.yahoo.vespa.clustercontroller.core.NodeStateReason;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class AnnotatedClusterState
implements Cloneable {
    private final ClusterState clusterState;
    private final Map<Node, NodeStateReason> nodeStateReasons;
    private final Optional<ClusterStateReason> clusterStateReason;

    public AnnotatedClusterState(ClusterState clusterState, Optional<ClusterStateReason> clusterStateReason, Map<Node, NodeStateReason> nodeStateReasons) {
        this.clusterState = Objects.requireNonNull(clusterState, "Cluster state cannot be null");
        this.clusterStateReason = Objects.requireNonNull(clusterStateReason, "Cluster state reason cannot be null");
        this.nodeStateReasons = Map.copyOf(Objects.requireNonNull(nodeStateReasons, "Node state reasons cannot be null"));
    }

    public static AnnotatedClusterState emptyState() {
        return new AnnotatedClusterState(ClusterState.emptyState(), Optional.empty(), AnnotatedClusterState.emptyNodeStateReasons());
    }

    public static AnnotatedClusterState withoutAnnotations(ClusterState state) {
        return new AnnotatedClusterState(state, Optional.empty(), AnnotatedClusterState.emptyNodeStateReasons());
    }

    static Map<Node, NodeStateReason> emptyNodeStateReasons() {
        return Map.of();
    }

    public ClusterState getClusterState() {
        return this.clusterState;
    }

    public Map<Node, NodeStateReason> getNodeStateReasons() {
        return this.nodeStateReasons;
    }

    public Optional<ClusterStateReason> getClusterStateReason() {
        return this.clusterStateReason;
    }

    public AnnotatedClusterState clone() {
        return this.cloneWithClusterState(this.clusterState.clone());
    }

    public AnnotatedClusterState cloneWithClusterState(ClusterState newClusterState) {
        return new AnnotatedClusterState(newClusterState, this.getClusterStateReason(), this.getNodeStateReasons());
    }

    public String toString() {
        return this.clusterState.toString();
    }

    public String toString(boolean verbose) {
        return this.clusterState.toString(verbose);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnotatedClusterState that = (AnnotatedClusterState)o;
        return Objects.equals(this.clusterState, that.clusterState) && Objects.equals(this.nodeStateReasons, that.nodeStateReasons) && Objects.equals(this.clusterStateReason, that.clusterStateReason);
    }

    public int hashCode() {
        return Objects.hash(this.clusterState, this.nodeStateReasons, this.clusterStateReason);
    }

    public static class Builder {
        private ClusterState clusterState = ClusterState.emptyState();
        private Optional<ClusterStateReason> clusterReason = Optional.empty();
        private final Map<Node, NodeStateReason> nodeStateReasons = new HashMap<Node, NodeStateReason>();

        public Builder clusterState(String stateStr) {
            this.clusterState = ClusterState.stateFromString((String)stateStr);
            return this;
        }

        public Builder clusterReason(ClusterStateReason reason) {
            this.clusterReason = Optional.of(reason);
            return this;
        }

        public Builder storageNodeReason(int nodeIndex, NodeStateReason reason) {
            this.nodeStateReasons.put(Node.ofStorage((int)nodeIndex), reason);
            return this;
        }

        AnnotatedClusterState build() {
            return new AnnotatedClusterState(this.clusterState, this.clusterReason, this.nodeStateReasons);
        }
    }
}

