/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.vespa.clustercontroller.core.AggregatedClusterStats;
import com.yahoo.vespa.clustercontroller.core.AggregatedStatsMergePendingChecker;
import com.yahoo.vespa.clustercontroller.core.ContentClusterStats;
import com.yahoo.vespa.clustercontroller.core.ContentNodeStats;
import com.yahoo.vespa.clustercontroller.core.MergePendingChecker;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ClusterStatsAggregator {
    private final Set<Integer> distributors;
    private final Set<Integer> nonUpdatedDistributors;
    private final Map<Integer, ContentClusterStats> distributorToStats = new HashMap<Integer, ContentClusterStats>();
    private final ContentClusterStats aggregatedStats;
    private final ContentNodeStats globallyAggregatedNodeStats = new ContentNodeStats(-1);

    ClusterStatsAggregator(Set<Integer> distributors, Set<Integer> storageNodes) {
        this.distributors = distributors;
        this.nonUpdatedDistributors = new HashSet<Integer>(distributors);
        this.aggregatedStats = new ContentClusterStats(storageNodes);
    }

    public AggregatedClusterStats getAggregatedStats() {
        return new AggregatedClusterStats(){

            @Override
            public boolean hasUpdatesFromAllDistributors() {
                return ClusterStatsAggregator.this.nonUpdatedDistributors.isEmpty();
            }

            @Override
            public ContentClusterStats getStats() {
                return ClusterStatsAggregator.this.aggregatedStats;
            }

            @Override
            public ContentNodeStats getGlobalStats() {
                return ClusterStatsAggregator.this.globallyAggregatedNodeStats;
            }
        };
    }

    public ContentNodeStats getAggregatedStatsForDistributor(int distributorIndex) {
        ContentNodeStats result = new ContentNodeStats(distributorIndex);
        ContentClusterStats distributorStats = this.distributorToStats.get(distributorIndex);
        if (distributorStats != null) {
            for (ContentNodeStats distributorStat : distributorStats) {
                result.add(distributorStat);
            }
        }
        return result;
    }

    MergePendingChecker createMergePendingChecker(double minMergeCompletionRatio) {
        return new AggregatedStatsMergePendingChecker(this.getAggregatedStats(), minMergeCompletionRatio);
    }

    void updateForDistributor(int distributorIndex, ContentClusterStats clusterStats) {
        if (!this.distributors.contains(distributorIndex)) {
            return;
        }
        this.nonUpdatedDistributors.remove(distributorIndex);
        this.addStatsFromDistributor(distributorIndex, clusterStats);
    }

    private void addStatsFromDistributor(int distributorIndex, ContentClusterStats clusterStats) {
        ContentClusterStats prevClusterStats = this.distributorToStats.put(distributorIndex, clusterStats);
        for (ContentNodeStats contentNode : this.aggregatedStats) {
            ContentNodeStats statsToSubtract;
            Integer nodeIndex = contentNode.getNodeIndex();
            ContentNodeStats statsToAdd = clusterStats.getNodeStats(nodeIndex);
            if (statsToAdd != null) {
                contentNode.add(statsToAdd);
                this.globallyAggregatedNodeStats.add(statsToAdd);
            }
            if (prevClusterStats == null || (statsToSubtract = prevClusterStats.getNodeStats(nodeIndex)) == null) continue;
            contentNode.subtract(statsToSubtract);
            this.globallyAggregatedNodeStats.subtract(statsToSubtract);
        }
    }
}

