/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.vespa.clustercontroller.core.Timer;
import java.time.Instant;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;

public class RealTimer
implements Timer {
    @Override
    public Instant getCurrentWallClockTime() {
        return Instant.now();
    }

    public static String printDuration(long time) {
        StringBuilder sb = new StringBuilder();
        if (time > 172800000L) {
            double days = (double)time / 8.64E7;
            sb.append(String.format(Locale.ENGLISH, "%.2f", days)).append(" day").append(Math.abs(days - 1.0) < 1.0E-4 ? "" : "s");
        } else if (time > 0x6DDD00L) {
            double hours = (double)time / 3600000.0;
            sb.append(String.format(Locale.ENGLISH, "%.2f", hours)).append(" hour").append(Math.abs(hours - 1.0) < 1.0E-4 ? "" : "s");
        } else if (time > 120000L) {
            double minutes = (double)time / 60000.0;
            sb.append(String.format(Locale.ENGLISH, "%.2f", minutes)).append(" minute").append(Math.abs(minutes - 1.0) < 1.0E-4 ? "" : "s");
        } else if (time > 2000L) {
            double seconds = (double)time / 1000.0;
            sb.append(String.format(Locale.ENGLISH, "%.2f", seconds)).append(" s");
        } else {
            sb.append(time).append(" ms");
        }
        return sb.toString();
    }

    public static String printDateNoMilliSeconds(long time, TimeZone tz) {
        Calendar cal = Calendar.getInstance(tz);
        cal.setTimeInMillis(time);
        return String.format(Locale.ENGLISH, "%04d-%02d-%02d %02d:%02d:%02d", cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13));
    }

    public static String printDate(long time, TimeZone tz) {
        Calendar cal = Calendar.getInstance(tz);
        cal.setTimeInMillis(time);
        return String.format(Locale.ENGLISH, "%04d-%02d-%02d %02d:%02d:%02d.%03d", cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), cal.get(14));
    }
}

