/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core.restapiv2;

import com.yahoo.vdslib.state.NodeState;
import com.yahoo.vdslib.state.State;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.errors.InternalFailure;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.errors.StateRestApiException;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.response.CurrentUnitState;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.response.DistributionState;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.response.DistributionStates;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.response.SubUnitList;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.response.UnitAttributes;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.response.UnitMetrics;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.response.UnitResponse;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.response.UnitState;
import java.util.LinkedHashMap;
import java.util.Map;

public class Response {

    public static class PartitionResponse
    extends EmptyResponse<UnitResponse> {
    }

    public static class NodeResponse
    extends EmptyResponse<PartitionResponse> {
    }

    public static class ServiceResponse
    extends EmptyResponse<NodeResponse> {
    }

    public static class ClusterResponse
    extends EmptyResponse<ServiceResponse> {
    }

    public static class ClusterListResponse
    extends EmptyResponse<ClusterResponse> {
    }

    public static abstract class EmptyResponse<T extends UnitResponse>
    implements UnitResponse,
    UnitMetrics,
    UnitAttributes,
    CurrentUnitState,
    DistributionStates {
        protected final Map<String, String> attributes = new LinkedHashMap<String, String>();
        protected final Map<String, SubUnitList> subUnits = new LinkedHashMap<String, SubUnitList>();
        protected final Map<String, Long> metrics = new LinkedHashMap<String, Long>();
        protected final Map<String, UnitState> stateMap = new LinkedHashMap<String, UnitState>();
        protected DistributionState publishedState = null;

        public UnitAttributes getAttributes() {
            return this.attributes.isEmpty() ? null : this;
        }

        public CurrentUnitState getCurrentState() {
            return this.stateMap.isEmpty() ? null : this;
        }

        public Map<String, SubUnitList> getSubUnits() {
            return this.subUnits.isEmpty() ? null : this.subUnits;
        }

        public UnitMetrics getMetrics() {
            return this.metrics.isEmpty() ? null : this;
        }

        public DistributionStates getDistributionStates() {
            return this.publishedState == null ? null : this;
        }

        public Map<String, Long> getMetricMap() {
            return this.metrics;
        }

        public Map<String, UnitState> getStatePerType() {
            return this.stateMap;
        }

        public Map<String, String> getAttributeValues() {
            return this.attributes;
        }

        public DistributionState getPublishedState() {
            return this.publishedState;
        }

        public EmptyResponse<T> addLink(String type, String unit, String link) {
            Link list = (Link)this.subUnits.get(type);
            if (list == null) {
                list = new Link();
                this.subUnits.put(type, list);
            }
            list.addLink(unit, link);
            return this;
        }

        public EmptyResponse<T> addEntry(String type, String unit, T response) {
            Link list = (Link)this.subUnits.get(type);
            if (list == null) {
                list = new Link();
                this.subUnits.put(type, list);
            }
            list.addUnit(unit, (UnitResponse)response);
            return this;
        }

        public EmptyResponse<T> addMetric(String name, Long value) {
            this.metrics.put(name, value);
            return this;
        }

        public EmptyResponse<T> addState(String type, UnitStateImpl state) {
            this.stateMap.put(type, state);
            return this;
        }

        public EmptyResponse<T> addAttribute(String name, String value) {
            this.attributes.put(name, value);
            return this;
        }

        public EmptyResponse<T> setPublishedState(DistributionState publishedState) {
            this.publishedState = publishedState;
            return this;
        }
    }

    public static class Link
    implements SubUnitList {
        private final Map<String, String> links = new LinkedHashMap<String, String>();
        private final Map<String, UnitResponse> units = new LinkedHashMap<String, UnitResponse>();

        public Link addLink(String unit, String link) {
            this.links.put(unit, link);
            return this;
        }

        public Link addUnit(String unit, UnitResponse r) {
            this.units.put(unit, r);
            return this;
        }

        public Map<String, String> getSubUnitLinks() {
            return this.links;
        }

        public Map<String, UnitResponse> getSubUnits() {
            return this.units;
        }
    }

    public static class UnitStateImpl
    implements UnitState {
        private final String id;
        private final String reason;

        public UnitStateImpl(State s) throws StateRestApiException {
            this.id = this.parseId(s);
            this.reason = "";
        }

        public UnitStateImpl(NodeState ns) throws StateRestApiException {
            this.id = this.parseId(ns.getState());
            this.reason = ns.getDescription();
        }

        public String parseId(State id) throws StateRestApiException {
            switch (id) {
                case UP: {
                    return "up";
                }
                case DOWN: {
                    return "down";
                }
                case INITIALIZING: {
                    return "initializing";
                }
                case MAINTENANCE: {
                    return "maintenance";
                }
                case RETIRED: {
                    return "retired";
                }
                case STOPPING: {
                    return "stopping";
                }
            }
            throw new InternalFailure("Unknown state '" + id + "' found.");
        }

        public String id() {
            return this.id;
        }

        public String reason() {
            return this.reason;
        }

        public String toString() {
            return this.id() + ": " + this.reason();
        }
    }
}

