/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.vespa.clustercontroller.core.RemoteClusterControllerTask;
import java.util.Objects;

class VersionDependentTaskCompletion {
    private final long minimumVersion;
    private final RemoteClusterControllerTask task;
    private final long deadlineTimePointMs;

    VersionDependentTaskCompletion(long minimumVersion, RemoteClusterControllerTask task, long maxDeadlineTimePointMs) {
        this.minimumVersion = minimumVersion;
        this.task = task;
        this.deadlineTimePointMs = task.getDeadline().map(deadline -> Math.max(0L, Math.min(deadline.toEpochMilli(), maxDeadlineTimePointMs))).orElse(maxDeadlineTimePointMs);
    }

    long getMinimumVersion() {
        return this.minimumVersion;
    }

    RemoteClusterControllerTask getTask() {
        return this.task;
    }

    long getDeadlineTimePointMs() {
        return this.deadlineTimePointMs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionDependentTaskCompletion that = (VersionDependentTaskCompletion)o;
        return this.minimumVersion == that.minimumVersion && Objects.equals(this.task, that.task);
    }

    public int hashCode() {
        return Objects.hash(this.minimumVersion, this.task);
    }
}

