/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core.rpc;

import com.yahoo.jrt.Request;
import com.yahoo.jrt.RequestWaiter;
import com.yahoo.vespa.clustercontroller.core.ActivateClusterStateVersionRequest;
import com.yahoo.vespa.clustercontroller.core.ClusterStateVersionSpecificRequest;
import com.yahoo.vespa.clustercontroller.core.Communicator;
import com.yahoo.vespa.clustercontroller.core.NodeInfo;
import com.yahoo.vespa.clustercontroller.core.rpc.RPCActivateClusterStateVersionRequest;

public class RPCActivateClusterStateVersionWaiter
implements RequestWaiter {
    private final Communicator.Waiter<ActivateClusterStateVersionRequest> waiter;
    private ActivateClusterStateVersionRequest request;

    public RPCActivateClusterStateVersionWaiter(Communicator.Waiter<ActivateClusterStateVersionRequest> waiter) {
        this.waiter = waiter;
    }

    public void setRequest(RPCActivateClusterStateVersionRequest request) {
        this.request = request;
    }

    public ClusterStateVersionSpecificRequest.Reply getReply(Request req) {
        NodeInfo info = this.request.getNodeInfo();
        if (req.isError()) {
            return new ClusterStateVersionSpecificRequest.Reply(req.errorCode(), req.errorMessage());
        }
        if (!req.checkReturnTypes("i")) {
            return new ClusterStateVersionSpecificRequest.Reply(110, "Got RPC response with invalid return types from " + info);
        }
        int actualVersion = req.returnValues().get(0).asInt32();
        return ClusterStateVersionSpecificRequest.Reply.withActualVersion(actualVersion);
    }

    public void handleRequestDone(Request request) {
        ClusterStateVersionSpecificRequest.Reply reply = this.getReply(request);
        this.request.setReply(reply);
        this.waiter.done(this.request);
    }
}

