/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core.database;

import com.yahoo.vespa.clustercontroller.core.database.Database;
import com.yahoo.vespa.clustercontroller.core.database.ZooKeeperPaths;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class MasterDataGatherer {
    private static final Logger log = Logger.getLogger(MasterDataGatherer.class.getName());
    private final ZooKeeperPaths paths;
    private Map<Integer, Integer> masterData = new TreeMap<Integer, Integer>();
    private final Map<Integer, Integer> nextMasterData = new TreeMap<Integer, Integer>();
    private final AsyncCallback.ChildrenCallback childListener = new DirCallback();
    private final NodeDataCallback nodeListener = new NodeDataCallback();
    private final Database.DatabaseListener listener;
    private final ZooKeeper session;
    private final int nodeIndex;
    private final Watcher changeWatcher = new ChangeWatcher();

    private static int getIndex(String nodeName) {
        assert (nodeName != null);
        int lastSlash = nodeName.lastIndexOf(47);
        if (lastSlash <= 1) {
            throw new IllegalArgumentException("Unexpected path to nodename: '" + nodeName + "'.");
        }
        return Integer.parseInt(nodeName.substring(lastSlash + 1));
    }

    public MasterDataGatherer(ZooKeeper session, ZooKeeperPaths paths, Database.DatabaseListener listener, int nodeIndex) {
        this.paths = paths;
        this.session = session;
        this.listener = listener;
        this.nodeIndex = nodeIndex;
        if (session.getState().equals((Object)ZooKeeper.States.CONNECTED)) {
            this.restart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart() {
        Map<Integer, Integer> map = this.nextMasterData;
        synchronized (map) {
            this.masterData = new TreeMap<Integer, Integer>();
            this.nextMasterData.clear();
            this.session.getChildren(this.paths.indexesRoot(), this.changeWatcher, this.childListener, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cycleCompleted() {
        Map<Integer, Integer> copy;
        Map<Integer, Integer> map = this.nextMasterData;
        synchronized (map) {
            if (this.nextMasterData.equals(this.masterData)) {
                log.log(Level.FINE, () -> "Fleetcontroller " + this.nodeIndex + ": No change in master data detected, not sending it on");
                return;
            }
            copy = this.masterData = new TreeMap<Integer, Integer>(this.nextMasterData);
        }
        log.log(Level.FINE, () -> "Fleetcontroller " + this.nodeIndex + ": Got new master data, sending it on");
        this.listener.handleMasterData(copy);
    }

    private class DirCallback
    implements AsyncCallback.ChildrenCallback {
        private DirCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processResult(int version, String path, Object context, List<String> nodes) {
            if (nodes == null) {
                nodes = new LinkedList<String>();
            }
            log.log(Level.INFO, "Fleetcontroller " + MasterDataGatherer.this.nodeIndex + ": Got node list response from " + path + " version " + version + " with " + nodes.size() + " nodes");
            Map<Integer, Integer> map = MasterDataGatherer.this.nextMasterData;
            synchronized (map) {
                MasterDataGatherer.this.nextMasterData.clear();
                for (String node : nodes) {
                    int index = Integer.parseInt(node);
                    MasterDataGatherer.this.nextMasterData.put(index, null);
                    log.log(Level.FINE, () -> "Fleetcontroller " + MasterDataGatherer.this.nodeIndex + ": Attempting to fetch data in node '" + MasterDataGatherer.this.paths.indexOf(index) + "' to see vote");
                    MasterDataGatherer.this.session.getData(MasterDataGatherer.this.paths.indexOf(index), MasterDataGatherer.this.changeWatcher, (AsyncCallback.DataCallback)MasterDataGatherer.this.nodeListener, null);
                }
            }
        }
    }

    private class NodeDataCallback
    implements AsyncCallback.DataCallback {
        private NodeDataCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processResult(int code, String path, Object context, byte[] rawData, Stat stat) {
            String data = rawData == null ? null : new String(rawData, StandardCharsets.UTF_8);
            log.log(Level.INFO, "Fleetcontroller " + MasterDataGatherer.this.nodeIndex + ": Got vote data from path " + path + " with code " + code + " and data " + data);
            int index = MasterDataGatherer.getIndex(path);
            Map<Integer, Integer> map = MasterDataGatherer.this.nextMasterData;
            synchronized (map) {
                if (code != KeeperException.Code.OK.intValue()) {
                    if (code == KeeperException.Code.NONODE.intValue()) {
                        log.log(Level.INFO, "Fleetcontroller " + MasterDataGatherer.this.nodeIndex + ": Node at " + path + " removed, got no other option than counting it as down.");
                    } else {
                        log.log(Level.WARNING, "Fleetcontroller " + MasterDataGatherer.this.nodeIndex + ": Failure code " + code + " when listening to node at " + path + ", will assume it's down.");
                    }
                    if (MasterDataGatherer.this.nextMasterData.containsKey(index)) {
                        MasterDataGatherer.this.nextMasterData.remove(index);
                    } else {
                        log.log(Level.INFO, String.format("Fleetcontroller %d: ignoring removal of vote from node %d since it was not present in existing vote mapping", MasterDataGatherer.this.nodeIndex, index));
                    }
                } else {
                    Integer value = Integer.valueOf(data);
                    if (MasterDataGatherer.this.nextMasterData.containsKey(index)) {
                        if (value.equals(MasterDataGatherer.this.nextMasterData.get(index))) {
                            log.log(Level.FINE, () -> "Fleetcontroller " + MasterDataGatherer.this.nodeIndex + ": Got vote from fleetcontroller " + index + ", which already was " + value + ".");
                        } else {
                            log.log(Level.INFO, "Fleetcontroller " + MasterDataGatherer.this.nodeIndex + ": Got vote from fleetcontroller " + index + ". Altering vote from " + MasterDataGatherer.this.nextMasterData.get(index) + " to " + value + ".");
                            MasterDataGatherer.this.nextMasterData.put(index, value);
                        }
                    } else {
                        log.log(Level.WARNING, "Fleetcontroller " + MasterDataGatherer.this.nodeIndex + ": Got vote from fleetcontroller " + index + " which is not alive according to current state. Ignoring it");
                    }
                }
                for (Integer vote : MasterDataGatherer.this.nextMasterData.values()) {
                    if (vote != null) continue;
                    log.log(Level.FINEST, () -> "Fleetcontroller " + MasterDataGatherer.this.nodeIndex + ": Still not received votes from all fleet controllers. Awaiting more responses.");
                    return;
                }
            }
            log.log(Level.FINE, () -> "Fleetcontroller " + MasterDataGatherer.this.nodeIndex + ": Got votes for all fleetcontrollers. Sending event with new fleet data for update");
            MasterDataGatherer.this.cycleCompleted();
        }
    }

    private class ChangeWatcher
    implements Watcher {
        private ChangeWatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(WatchedEvent watchedEvent) {
            switch (watchedEvent.getType()) {
                case NodeChildrenChanged: {
                    log.log(Level.INFO, "Fleetcontroller " + MasterDataGatherer.this.nodeIndex + ": A change occurred in the list of registered fleetcontrollers. Requesting new information");
                    MasterDataGatherer.this.session.getChildren(MasterDataGatherer.this.paths.indexesRoot(), (Watcher)this, MasterDataGatherer.this.childListener, null);
                    break;
                }
                case NodeDataChanged: {
                    log.log(Level.INFO, "Fleetcontroller " + MasterDataGatherer.this.nodeIndex + ": Altered data in node " + watchedEvent.getPath() + ". Requesting new vote");
                    int index = MasterDataGatherer.getIndex(watchedEvent.getPath());
                    Map<Integer, Integer> map = MasterDataGatherer.this.nextMasterData;
                    synchronized (map) {
                        MasterDataGatherer.this.nextMasterData.put(index, null);
                    }
                    MasterDataGatherer.this.session.getData(MasterDataGatherer.this.paths.indexOf(index), (Watcher)this, (AsyncCallback.DataCallback)MasterDataGatherer.this.nodeListener, null);
                    break;
                }
                case NodeCreated: {
                    log.log(Level.WARNING, "Fleetcontroller " + MasterDataGatherer.this.nodeIndex + ": Got unexpected ZooKeeper event NodeCreated");
                    break;
                }
                case NodeDeleted: {
                    log.log(Level.FINE, () -> "Fleetcontroller " + MasterDataGatherer.this.nodeIndex + ": Node deleted event gotten. Ignoring it, expecting a NodeChildrenChanged event too.");
                    break;
                }
                case None: {
                    log.log(Level.FINE, () -> "Fleetcontroller " + MasterDataGatherer.this.nodeIndex + ": Got ZooKeeper event None.");
                }
            }
        }
    }
}

