/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.document.FixedBucketSpaces;
import com.yahoo.vespa.clustercontroller.core.AggregatedClusterStats;
import com.yahoo.vespa.clustercontroller.core.AggregatedStatsMergePendingChecker;
import com.yahoo.vespa.clustercontroller.core.ContentNodeStats;
import java.util.HashMap;
import java.util.Map;

public class ClusterStatsChangeTracker {
    private AggregatedClusterStats aggregatedStats;
    private AggregatedStatsMergePendingChecker checker;
    private Map<Integer, Boolean> prevMayHaveMergesPending = null;

    public ClusterStatsChangeTracker(AggregatedClusterStats aggregatedStats, double minMergeCompletionRatio) {
        this.setAggregatedStats(aggregatedStats, minMergeCompletionRatio);
    }

    private void setAggregatedStats(AggregatedClusterStats aggregatedStats, double minMergeCompletionRatio) {
        this.aggregatedStats = aggregatedStats;
        this.checker = new AggregatedStatsMergePendingChecker(this.aggregatedStats, minMergeCompletionRatio);
    }

    public void syncAggregatedStats() {
        this.prevMayHaveMergesPending = new HashMap<Integer, Boolean>();
        for (ContentNodeStats contentNodeStats : this.aggregatedStats.getStats()) {
            int nodeIndex = contentNodeStats.getNodeIndex();
            this.prevMayHaveMergesPending.put(nodeIndex, this.mayHaveMergesPendingInGlobalSpace(nodeIndex));
        }
    }

    public void updateAggregatedStats(AggregatedClusterStats newAggregatedStats, double minMergeCompletionRatio) {
        this.syncAggregatedStats();
        this.setAggregatedStats(newAggregatedStats, minMergeCompletionRatio);
    }

    public boolean statsHaveChanged() {
        if (!this.aggregatedStats.hasUpdatesFromAllDistributors()) {
            return false;
        }
        for (ContentNodeStats contentNodeStats : this.aggregatedStats.getStats()) {
            int nodeIndex = contentNodeStats.getNodeIndex();
            boolean currValue = this.mayHaveMergesPendingInGlobalSpace(nodeIndex);
            Boolean prevValue = this.prevMayHaveMergesPendingInGlobalSpace(nodeIndex);
            if (prevValue != null) {
                if (prevValue == currValue) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    private boolean mayHaveMergesPendingInGlobalSpace(int nodeIndex) {
        return this.checker.mayHaveMergesPending(FixedBucketSpaces.globalSpace(), nodeIndex);
    }

    private Boolean prevMayHaveMergesPendingInGlobalSpace(int nodeIndex) {
        if (this.prevMayHaveMergesPending != null) {
            return this.prevMayHaveMergesPending.get(nodeIndex);
        }
        return null;
    }
}

