/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.vespa.clustercontroller.core.hostinfo.StorageNode;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ContentNodeStats {
    private final int nodeIndex;
    private Map<String, BucketSpaceStats> bucketSpaces = new HashMap<String, BucketSpaceStats>();

    public ContentNodeStats(StorageNode storageNode) {
        this.nodeIndex = storageNode.getIndex();
        for (StorageNode.BucketSpaceStats stats : storageNode.getBucketSpacesStats()) {
            if (stats.valid()) {
                this.bucketSpaces.put(stats.getName(), BucketSpaceStats.of(stats.getBucketStats().getTotal(), stats.getBucketStats().getPending()));
                continue;
            }
            this.bucketSpaces.put(stats.getName(), BucketSpaceStats.invalid());
        }
    }

    public ContentNodeStats(int index) {
        this(index, new HashMap<String, BucketSpaceStats>());
    }

    public ContentNodeStats(int index, Map<String, BucketSpaceStats> bucketSpaces) {
        this.nodeIndex = index;
        this.bucketSpaces = bucketSpaces;
    }

    public int getNodeIndex() {
        return this.nodeIndex;
    }

    public void add(ContentNodeStats stats) {
        this.merge(stats, 1);
    }

    public void subtract(ContentNodeStats stats) {
        this.merge(stats, -1);
    }

    private void merge(ContentNodeStats stats, int factor) {
        for (Map.Entry<String, BucketSpaceStats> entry : stats.bucketSpaces.entrySet()) {
            BucketSpaceStats statsToUpdate = this.bucketSpaces.get(entry.getKey());
            if (statsToUpdate == null && factor == 1) {
                statsToUpdate = BucketSpaceStats.empty();
                this.bucketSpaces.put(entry.getKey(), statsToUpdate);
            }
            if (statsToUpdate == null) continue;
            statsToUpdate.merge(entry.getValue(), factor);
        }
    }

    public BucketSpaceStats getBucketSpace(String bucketSpace) {
        return this.bucketSpaces.get(bucketSpace);
    }

    public Map<String, BucketSpaceStats> getBucketSpaces() {
        return this.bucketSpaces;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContentNodeStats that = (ContentNodeStats)o;
        return this.nodeIndex == that.nodeIndex && Objects.equals(this.bucketSpaces, that.bucketSpaces);
    }

    public int hashCode() {
        return Objects.hash(this.nodeIndex, this.bucketSpaces);
    }

    public String toString() {
        return String.format("{index=%d, bucketSpaces=[%s]}", this.nodeIndex, Arrays.toString(this.bucketSpaces.entrySet().toArray()));
    }

    public static class BucketSpaceStats {
        private int invalidCount;
        private long bucketsTotal;
        private long bucketsPending;

        private BucketSpaceStats() {
            this.invalidCount = 1;
            this.bucketsTotal = 0L;
            this.bucketsPending = 0L;
        }

        private BucketSpaceStats(long bucketsTotal, long bucketsPending, boolean invalid) {
            this.invalidCount = invalid ? 1 : 0;
            this.bucketsTotal = bucketsTotal;
            this.bucketsPending = bucketsPending;
        }

        public static BucketSpaceStats invalid() {
            return new BucketSpaceStats();
        }

        public static BucketSpaceStats invalid(long bucketsTotal, long bucketsPending) {
            return new BucketSpaceStats(bucketsTotal, bucketsPending, true);
        }

        public static BucketSpaceStats of(long bucketsTotal, long bucketsPending) {
            return new BucketSpaceStats(bucketsTotal, bucketsPending, false);
        }

        public static BucketSpaceStats empty() {
            return new BucketSpaceStats(0L, 0L, false);
        }

        public long getBucketsTotal() {
            return this.bucketsTotal;
        }

        public long getBucketsPending() {
            return this.bucketsPending;
        }

        public boolean mayHaveBucketsPending(double minMergeCompletionRatio) {
            if (this.invalidCount > 0) {
                return true;
            }
            if (this.bucketsTotal == 0L) {
                return this.bucketsPending > 0L;
            }
            return this.calcMergeCompletionRatio() < minMergeCompletionRatio;
        }

        private double calcMergeCompletionRatio() {
            return (double)Math.max(0L, this.bucketsTotal - this.bucketsPending) / (double)this.bucketsTotal;
        }

        public boolean valid() {
            return this.invalidCount == 0;
        }

        public void merge(BucketSpaceStats rhs, int factor) {
            this.invalidCount += factor * rhs.invalidCount;
            this.bucketsTotal += (long)factor * rhs.bucketsTotal;
            this.bucketsPending += (long)factor * rhs.bucketsPending;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BucketSpaceStats that = (BucketSpaceStats)o;
            return this.invalidCount == that.invalidCount && this.bucketsTotal == that.bucketsTotal && this.bucketsPending == that.bucketsPending;
        }

        public int hashCode() {
            return Objects.hash(this.invalidCount, this.bucketsTotal, this.bucketsPending);
        }

        public String toString() {
            return "{bucketsTotal=" + this.bucketsTotal + ", bucketsPending=" + this.bucketsPending + ", invalidCount=" + this.invalidCount + "}";
        }
    }
}

