/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.document.FixedBucketSpaces;
import com.yahoo.vdslib.state.ClusterState;
import com.yahoo.vdslib.state.Node;
import com.yahoo.vdslib.state.NodeState;
import com.yahoo.vdslib.state.NodeType;
import com.yahoo.vdslib.state.State;
import com.yahoo.vespa.clustercontroller.core.AnnotatedClusterState;
import com.yahoo.vespa.clustercontroller.core.ClusterStateDeriver;
import com.yahoo.vespa.clustercontroller.core.MaintenanceTransitionConstraint;
import com.yahoo.vespa.clustercontroller.core.MergePendingChecker;
import com.yahoo.vespa.clustercontroller.core.NodeStateReason;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class MaintenanceWhenPendingGlobalMerges
implements ClusterStateDeriver {
    private static final String bucketSpaceToCheck = FixedBucketSpaces.globalSpace();
    private static final String bucketSpaceToDerive = FixedBucketSpaces.defaultSpace();
    private final MergePendingChecker mergePendingChecker;
    private final MaintenanceTransitionConstraint maintenanceTransitionConstraint;

    public MaintenanceWhenPendingGlobalMerges(MergePendingChecker mergePendingChecker, MaintenanceTransitionConstraint maintenanceTransitionConstraint) {
        this.mergePendingChecker = mergePendingChecker;
        this.maintenanceTransitionConstraint = maintenanceTransitionConstraint;
    }

    @Override
    public AnnotatedClusterState derivedFrom(AnnotatedClusterState baselineState, String bucketSpace) {
        if (!bucketSpace.equals(bucketSpaceToDerive)) {
            return baselineState.clone();
        }
        Set<Integer> incompleteNodeIndices = MaintenanceWhenPendingGlobalMerges.availableContentNodes(baselineState.getClusterState()).stream().filter(nodeIndex -> this.mayHaveMergesPending(bucketSpaceToCheck, (int)nodeIndex)).filter(this.maintenanceTransitionConstraint::maintenanceTransitionAllowed).collect(Collectors.toSet());
        if (incompleteNodeIndices.isEmpty()) {
            return baselineState.clone();
        }
        return this.setNodesInMaintenance(baselineState, incompleteNodeIndices);
    }

    private static Set<Integer> availableContentNodes(ClusterState baselineState) {
        HashSet<Integer> availableNodes = new HashSet<Integer>();
        int nodeCount = baselineState.getNodeCount(NodeType.STORAGE);
        for (int nodeIndex = 0; nodeIndex < nodeCount; ++nodeIndex) {
            if (!MaintenanceWhenPendingGlobalMerges.contentNodeIsAvailable(baselineState, nodeIndex)) continue;
            availableNodes.add(nodeIndex);
        }
        return availableNodes;
    }

    private AnnotatedClusterState setNodesInMaintenance(AnnotatedClusterState baselineState, Set<Integer> incompleteNodeIndices) {
        ClusterState derivedState = baselineState.getClusterState().clone();
        HashMap<Node, NodeStateReason> nodeStateReasons = new HashMap<Node, NodeStateReason>(baselineState.getNodeStateReasons());
        incompleteNodeIndices.forEach(nodeIndex -> {
            Node node = Node.ofStorage((int)nodeIndex);
            derivedState.setNodeState(node, new NodeState(NodeType.STORAGE, State.MAINTENANCE));
            nodeStateReasons.put(node, NodeStateReason.MAY_HAVE_MERGES_PENDING);
        });
        return new AnnotatedClusterState(derivedState, baselineState.getClusterStateReason(), nodeStateReasons);
    }

    private static boolean contentNodeIsAvailable(ClusterState state, int nodeIndex) {
        return state.getNodeState(Node.ofStorage((int)nodeIndex)).getState().oneOf("uir");
    }

    private boolean mayHaveMergesPending(String bucketSpace, int nodeIndex) {
        return this.mergePendingChecker.mayHaveMergesPending(bucketSpace, nodeIndex);
    }
}

