/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core.restapiv2;

import com.yahoo.vespa.clustercontroller.core.RemoteClusterControllerTask;
import com.yahoo.vespa.clustercontroller.core.restapiv2.OtherMasterIndexException;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.errors.DeadlineExceededException;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.errors.InternalFailure;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.errors.StateRestApiException;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.errors.UnknownMasterException;

public abstract class Request<Result>
extends RemoteClusterControllerTask {
    private Exception failure = null;
    protected boolean resultSet = false;
    protected Result result = null;
    private final MasterState masterState;

    public Request(MasterState state) {
        this.masterState = state;
    }

    public Result getResult() throws StateRestApiException, OtherMasterIndexException {
        if (this.failure != null) {
            if (this.failure instanceof OtherMasterIndexException) {
                throw (OtherMasterIndexException)this.failure;
            }
            throw (StateRestApiException)this.failure;
        }
        if (!this.isCompleted()) {
            throw new InternalFailure("Attempt to fetch result before it has been calculated");
        }
        if (!this.resultSet) {
            throw new InternalFailure("Expected result to be set at this point.");
        }
        return this.result;
    }

    @Override
    public final void doRemoteFleetControllerTask(RemoteClusterControllerTask.Context context) {
        try {
            if (this.masterState == MasterState.MUST_BE_MASTER && !context.masterInfo.isMaster()) {
                Integer masterIndex = context.masterInfo.getMaster();
                if (masterIndex == null) {
                    throw new UnknownMasterException();
                }
                throw new OtherMasterIndexException(masterIndex);
            }
            this.result = this.calculateResult(context);
            this.resultSet = true;
        }
        catch (OtherMasterIndexException | StateRestApiException e) {
            this.failure = e;
        }
        catch (Exception e) {
            this.failure = new InternalFailure("Caught unexpected exception");
            this.failure.initCause(e);
        }
    }

    private static String failureStringWithPossibleMessage(String prefix, String message) {
        if (message != null && !message.isEmpty()) {
            return String.format("%s: %s", prefix, message);
        }
        return prefix;
    }

    @Override
    public void handleFailure(RemoteClusterControllerTask.Failure failure) {
        if (failure.getCondition() == RemoteClusterControllerTask.FailureCondition.LEADERSHIP_LOST) {
            this.failure = new UnknownMasterException(Request.failureStringWithPossibleMessage("Leadership lost before request could complete", failure.getMessage()));
        } else if (failure.getCondition() == RemoteClusterControllerTask.FailureCondition.DEADLINE_EXCEEDED) {
            this.failure = new DeadlineExceededException(Request.failureStringWithPossibleMessage("Task exceeded its version wait deadline", failure.getMessage()));
        }
    }

    @Override
    public boolean isFailed() {
        return this.failure != null;
    }

    public abstract Result calculateResult(RemoteClusterControllerTask.Context var1) throws StateRestApiException, OtherMasterIndexException;

    public static enum MasterState {
        MUST_BE_MASTER,
        NEED_NOT_BE_MASTER;

    }
}

