/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core.status.statuspage;

import com.yahoo.vespa.clustercontroller.core.status.statuspage.StatusPageResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StatusPageServer {
    public static Logger log = Logger.getLogger(StatusPageServer.class.getName());

    public static class PatternRequestRouter
    implements RequestRouter {
        private List<PatternRouting> patterns = new ArrayList<PatternRouting>();

        public void addHandler(Pattern pattern, RequestHandler handler) {
            this.patterns.add(new PatternRouting(pattern, handler));
        }

        public void addHandler(String pattern, RequestHandler handler) {
            this.addHandler(Pattern.compile(pattern), handler);
        }

        @Override
        public RequestHandler resolveHandler(HttpRequest request) {
            for (PatternRouting routing : this.patterns) {
                Matcher m = routing.pattern.matcher(request.getPath());
                if (!m.matches()) continue;
                return routing.handler;
            }
            return null;
        }

        private static class PatternRouting {
            public Pattern pattern;
            public RequestHandler handler;

            private PatternRouting(Pattern pattern, RequestHandler handler) {
                this.pattern = pattern;
                this.handler = handler;
            }
        }
    }

    public static interface RequestRouter {
        public RequestHandler resolveHandler(HttpRequest var1);
    }

    public static interface RequestHandler {
        public StatusPageResponse handle(HttpRequest var1);
    }

    public static class HttpRequest {
        private final String request;
        private String pathPrefix = "";
        private final Map<String, String> params = new HashMap<String, String>();
        private String path;
        static Pattern pathPattern = Pattern.compile("^(/([\\w=\\./]+)?)(?:\\?((?:&?\\w+(?:=[\\w\\.]*)?)*))?$");

        public HttpRequest(String request) {
            this.request = request;
            Matcher m = pathPattern.matcher(request);
            if (!m.matches()) {
                throw new IllegalArgumentException("Illegal HTTP request path: " + request);
            }
            this.path = m.group(1);
            if (m.group(3) != null) {
                String[] rawParams;
                for (String param : rawParams = m.group(3).split("&")) {
                    String[] queryParts = param.split("=");
                    this.params.put(queryParts[0], queryParts.length > 1 ? queryParts[1] : null);
                }
            }
        }

        public String getPathPrefix() {
            return this.pathPrefix;
        }

        public String toString() {
            return "HttpRequest(" + this.request + ")";
        }

        public String getRequest() {
            return this.request;
        }

        public String getPath() {
            return this.path;
        }

        public boolean hasQueryParameters() {
            return !this.params.isEmpty();
        }

        public String getQueryParameter(String name) {
            return this.params.get(name);
        }

        public boolean hasQueryParameter(String name) {
            return this.params.containsKey(name);
        }

        public void setPathPrefix(String pathPrefix) {
            this.pathPrefix = pathPrefix;
        }
    }
}

