/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core.database;

import com.yahoo.vdslib.state.Node;
import com.yahoo.vdslib.state.NodeState;
import com.yahoo.vdslib.state.State;
import com.yahoo.vespa.clustercontroller.core.ClusterStateBundle;
import com.yahoo.vespa.clustercontroller.core.ContentCluster;
import com.yahoo.vespa.clustercontroller.core.FleetController;
import com.yahoo.vespa.clustercontroller.core.NodeInfo;
import com.yahoo.vespa.clustercontroller.core.Timer;
import com.yahoo.vespa.clustercontroller.core.database.CasWriteFailed;
import com.yahoo.vespa.clustercontroller.core.database.Database;
import com.yahoo.vespa.clustercontroller.core.database.DatabaseFactory;
import com.yahoo.vespa.clustercontroller.core.listeners.NodeAddedOrRemovedListener;
import com.yahoo.vespa.clustercontroller.core.listeners.NodeStateOrHostInfoChangeHandler;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.zookeeper.KeeperException;

public class DatabaseHandler {
    private static final Logger log = Logger.getLogger(DatabaseHandler.class.getName());
    private final DatabaseFactory databaseFactory;
    private final Timer timer;
    private final int nodeIndex;
    private final Object monitor;
    private String zooKeeperAddress;
    private int zooKeeperSessionTimeout = 5000;
    private final Object databaseMonitor = new Object();
    private Database database;
    private final DatabaseListener dbListener = new DatabaseListener();
    private final Data currentlyStored = new Data();
    private final Data pendingStore = new Data();
    private int lastKnownStateBundleVersionWrittenBySelf = -1;
    private long lastZooKeeperConnectionAttempt = 0L;
    private static final int minimumWaitBetweenFailedConnectionAttempts = 10000;
    private boolean lostZooKeeperConnectionEvent = false;
    private Map<Integer, Integer> masterDataEvent = null;

    public DatabaseHandler(DatabaseFactory databaseFactory, Timer timer, String zooKeeperAddress, int ourIndex, Object monitor) throws InterruptedException {
        this.databaseFactory = databaseFactory;
        this.timer = timer;
        this.nodeIndex = ourIndex;
        this.pendingStore.masterVote = ourIndex;
        this.monitor = monitor;
        this.zooKeeperAddress = zooKeeperAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDatabaseClosedSafe() {
        Object object = this.databaseMonitor;
        synchronized (object) {
            return this.isClosed();
        }
    }

    public void shutdown(Context context) {
        this.relinquishDatabaseConnectivity(context);
    }

    public boolean isClosed() {
        return this.database == null || this.database.isClosed();
    }

    public int getLastKnownStateBundleVersionWrittenBySelf() {
        return this.lastKnownStateBundleVersionWrittenBySelf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(Context context) {
        boolean wasRunning;
        Object object = this.databaseMonitor;
        synchronized (object) {
            boolean bl = wasRunning = this.database != null;
            if (wasRunning) {
                log.log(Level.INFO, "Fleetcontroller " + this.nodeIndex + ": Resetting database state");
                this.database.close();
                this.database = null;
            }
        }
        this.clearSessionMetaData(true);
        context.getFleetController().lostDatabaseConnection();
        if (wasRunning) {
            log.log(Level.INFO, "Fleetcontroller " + this.nodeIndex + ": Done resetting database state");
        }
    }

    private void clearSessionMetaData(boolean clearPendingStateWrites) {
        Integer currentVote = this.pendingStore.masterVote != null ? this.pendingStore.masterVote : this.currentlyStored.masterVote;
        this.currentlyStored.clear();
        if (clearPendingStateWrites) {
            this.pendingStore.clear();
        } else {
            this.pendingStore.clearNonClusterStateFields();
        }
        this.pendingStore.masterVote = currentVote;
        log.log(Level.FINE, "Cleared session metadata. Pending master vote is now " + this.pendingStore.masterVote);
    }

    public void setZooKeeperAddress(String address, Context context) {
        if (address == null && this.zooKeeperAddress == null) {
            return;
        }
        if (address != null && address.equals(this.zooKeeperAddress)) {
            return;
        }
        if (this.zooKeeperAddress != null) {
            log.log(Level.INFO, "Fleetcontroller " + this.nodeIndex + ": " + (String)(address == null ? "Stopped using ZooKeeper." : "Got new ZooKeeper address to use: " + address));
        }
        this.zooKeeperAddress = address;
        this.reset(context);
    }

    public void setZooKeeperSessionTimeout(int timeout, Context context) {
        if (timeout == this.zooKeeperSessionTimeout) {
            return;
        }
        log.log(Level.FINE, "Fleetcontroller " + this.nodeIndex + ": Got new ZooKeeper session timeout of " + timeout + " milliseconds.");
        this.zooKeeperSessionTimeout = timeout;
        this.reset(context);
    }

    private boolean usingZooKeeper() {
        return this.zooKeeperAddress != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect(ContentCluster cluster, long currentTime) throws InterruptedException {
        try {
            this.lastZooKeeperConnectionAttempt = currentTime;
            Object object = this.databaseMonitor;
            synchronized (object) {
                if (this.database != null) {
                    this.database.close();
                }
                this.clearSessionMetaData(false);
                log.log(Level.INFO, "Fleetcontroller " + this.nodeIndex + ": Setting up new ZooKeeper session at " + this.zooKeeperAddress);
                DatabaseFactory.Params params = new DatabaseFactory.Params().cluster(cluster).nodeIndex(this.nodeIndex).databaseAddress(this.zooKeeperAddress).databaseSessionTimeout(this.zooKeeperSessionTimeout).databaseListener(this.dbListener);
                this.database = this.databaseFactory.create(params);
            }
        }
        catch (KeeperException.NodeExistsException e) {
            log.log(Level.FINE, "Fleetcontroller " + this.nodeIndex + ": Cannot create ephemeral fleetcontroller node. ZooKeeper server not seen old fleetcontroller instance disappear? It already exists. Will retry later: " + e.getMessage());
        }
        catch (InterruptedException e) {
            throw (InterruptedException)new InterruptedException("Interrupted").initCause(e);
        }
        catch (KeeperException.ConnectionLossException e) {
            log.log(Level.WARNING, "Fleetcontroller " + this.nodeIndex + ": Failed to connect to ZooKeeper at " + this.zooKeeperAddress + " with session timeout " + this.zooKeeperSessionTimeout + ": " + e.getMessage());
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            log.log(Level.WARNING, "Fleetcontroller " + this.nodeIndex + ": Failed to connect to ZooKeeper at " + this.zooKeeperAddress + " with session timeout " + this.zooKeeperSessionTimeout + ": " + sw);
        }
        log.log(Level.INFO, "Fleetcontroller " + this.nodeIndex + ": Done setting up new ZooKeeper session at " + this.zooKeeperAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doNextZooKeeperTask(Context context) throws InterruptedException {
        boolean didWork = false;
        Object object = this.monitor;
        synchronized (object) {
            if (this.lostZooKeeperConnectionEvent) {
                log.log(Level.FINE, "Fleetcontroller " + this.nodeIndex + ": doNextZooKeeperTask(): lost connection");
                context.getFleetController().lostDatabaseConnection();
                this.lostZooKeeperConnectionEvent = false;
                didWork = true;
                if (this.masterDataEvent != null) {
                    log.log(Level.FINE, "Fleetcontroller " + this.nodeIndex + ": Had new master data queued on disconnect. Removing master data event");
                    this.masterDataEvent = null;
                }
            }
            if (this.masterDataEvent != null) {
                log.log(Level.FINE, "Fleetcontroller " + this.nodeIndex + ": doNextZooKeeperTask(): new master data");
                if (!this.masterDataEvent.containsKey(this.nodeIndex)) {
                    Integer currentVote;
                    Integer n = currentVote = this.pendingStore.masterVote != null ? this.pendingStore.masterVote : this.currentlyStored.masterVote;
                    assert (currentVote != null);
                    this.masterDataEvent.put(this.nodeIndex, currentVote);
                }
                context.getFleetController().handleFleetData(this.masterDataEvent);
                this.masterDataEvent = null;
                didWork = true;
            }
        }
        if (this.isDatabaseClosedSafe() && this.zooKeeperIsConfigured()) {
            long currentTime = this.timer.getCurrentTimeInMillis();
            if (currentTime - this.lastZooKeeperConnectionAttempt < 10000L) {
                return false;
            }
            didWork = true;
            this.connect(context.getCluster(), currentTime);
        }
        try {
            Object currentTime = this.databaseMonitor;
            synchronized (currentTime) {
                if (this.database == null || this.database.isClosed()) {
                    return didWork;
                }
                didWork |= this.performZooKeeperWrites();
            }
        }
        catch (CasWriteFailed e) {
            log.log(Level.WARNING, String.format("CaS write to ZooKeeper failed, another controller has likely taken over ownership: %s", e.getMessage()));
            this.relinquishDatabaseConnectivity(context);
        }
        return didWork;
    }

    private boolean zooKeeperIsConfigured() {
        return this.zooKeeperAddress != null;
    }

    private void relinquishDatabaseConnectivity(Context context) {
        this.reset(context);
    }

    private boolean performZooKeeperWrites() throws InterruptedException {
        boolean didWork = false;
        if (this.pendingStore.masterVote != null) {
            didWork = true;
            log.log(Level.FINE, "Fleetcontroller " + this.nodeIndex + ": Attempting to store master vote " + this.pendingStore.masterVote + " into zookeeper.");
            if (this.database.storeMasterVote(this.pendingStore.masterVote)) {
                log.log(Level.FINE, "Fleetcontroller " + this.nodeIndex + ": Managed to store master vote " + this.pendingStore.masterVote + " into zookeeper.");
                this.currentlyStored.masterVote = this.pendingStore.masterVote;
                this.pendingStore.masterVote = null;
            } else {
                log.log(Level.WARNING, "Fleetcontroller " + this.nodeIndex + ": Failed to store master vote");
                return true;
            }
        }
        if (this.pendingStore.lastSystemStateVersion != null) {
            didWork = true;
            log.log(Level.FINE, "Fleetcontroller " + this.nodeIndex + ": Attempting to store last system state version " + this.pendingStore.lastSystemStateVersion + " into zookeeper.");
            if (this.database.storeLatestSystemStateVersion(this.pendingStore.lastSystemStateVersion)) {
                this.currentlyStored.lastSystemStateVersion = this.pendingStore.lastSystemStateVersion;
                this.pendingStore.lastSystemStateVersion = null;
            } else {
                return true;
            }
        }
        if (this.pendingStore.startTimestamps != null) {
            didWork = true;
            log.log(Level.FINE, "Fleetcontroller " + this.nodeIndex + ": Attempting to store " + this.pendingStore.startTimestamps.size() + " start timestamps into zookeeper.");
            if (this.database.storeStartTimestamps(this.pendingStore.startTimestamps)) {
                this.currentlyStored.startTimestamps = this.pendingStore.startTimestamps;
                this.pendingStore.startTimestamps = null;
            } else {
                return true;
            }
        }
        if (this.pendingStore.wantedStates != null) {
            didWork = true;
            log.log(Level.FINE, "Fleetcontroller " + this.nodeIndex + ": Attempting to store " + this.pendingStore.wantedStates.size() + " wanted states into zookeeper.");
            if (this.database.storeWantedStates(this.pendingStore.wantedStates)) {
                this.currentlyStored.wantedStates = this.pendingStore.wantedStates;
                this.pendingStore.wantedStates = null;
            } else {
                return true;
            }
        }
        if (this.pendingStore.clusterStateBundle != null) {
            didWork = true;
            log.fine(() -> String.format("Fleetcontroller %d: Attempting to store last cluster state bundle with version %d into zookeeper.", this.nodeIndex, this.pendingStore.clusterStateBundle.getVersion()));
            if (this.database.storeLastPublishedStateBundle(this.pendingStore.clusterStateBundle)) {
                this.lastKnownStateBundleVersionWrittenBySelf = this.pendingStore.clusterStateBundle.getVersion();
                this.currentlyStored.clusterStateBundle = this.pendingStore.clusterStateBundle;
                this.pendingStore.clusterStateBundle = null;
            } else {
                return true;
            }
        }
        return didWork;
    }

    public void setMasterVote(Context context, int wantedMasterCandidate) throws InterruptedException {
        log.log(Level.FINE, "Fleetcontroller " + this.nodeIndex + ": Checking if master vote has been updated and need to be stored.");
        if (this.pendingStore.masterVote != null || this.currentlyStored.masterVote == null || this.currentlyStored.masterVote != wantedMasterCandidate) {
            log.log(Level.FINE, "Fleetcontroller " + this.nodeIndex + ": Scheduling master vote " + wantedMasterCandidate + " to be stored in zookeeper.");
            this.pendingStore.masterVote = wantedMasterCandidate;
            this.doNextZooKeeperTask(context);
        }
    }

    public void saveLatestSystemStateVersion(Context context, int version) throws InterruptedException {
        log.log(Level.FINE, "Fleetcontroller " + this.nodeIndex + ": Checking if latest system state version has been updated and need to be stored.");
        if (this.pendingStore.lastSystemStateVersion != null || this.currentlyStored.lastSystemStateVersion == null || this.currentlyStored.lastSystemStateVersion != version) {
            log.log(Level.FINE, "Fleetcontroller " + this.nodeIndex + ": Scheduling new last system state version " + version + " to be stored in zookeeper.");
            this.pendingStore.lastSystemStateVersion = version;
            this.doNextZooKeeperTask(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLatestSystemStateVersion() throws InterruptedException {
        log.log(Level.FINE, "Fleetcontroller " + this.nodeIndex + ": Retrieving latest system state version.");
        Object object = this.databaseMonitor;
        synchronized (object) {
            if (this.database != null && !this.database.isClosed()) {
                this.currentlyStored.lastSystemStateVersion = this.database.retrieveLatestSystemStateVersion();
            }
        }
        Integer version = this.currentlyStored.lastSystemStateVersion;
        if (version == null) {
            if (this.usingZooKeeper()) {
                log.log(Level.WARNING, "Fleetcontroller " + this.nodeIndex + ": Failed to retrieve latest system state version from ZooKeeper. Returning version 0.");
            }
            return 0;
        }
        return version;
    }

    public void saveLatestClusterStateBundle(Context context, ClusterStateBundle clusterStateBundle) throws InterruptedException {
        log.log(Level.FINE, () -> String.format("Fleetcontroller %d: Scheduling bundle %s to be saved to ZooKeeper", this.nodeIndex, clusterStateBundle));
        this.pendingStore.clusterStateBundle = clusterStateBundle;
        this.doNextZooKeeperTask(context);
        if (this.zooKeeperAddress == null) {
            log.warning(() -> String.format("Fleetcontroller %d: Simulating ZK write of version %d. This should not happen in production!", this.nodeIndex, clusterStateBundle.getVersion()));
            this.lastKnownStateBundleVersionWrittenBySelf = clusterStateBundle.getVersion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPendingClusterStateMetaDataStore() {
        Object object = this.databaseMonitor;
        synchronized (object) {
            return this.zooKeeperAddress != null && (this.pendingStore.clusterStateBundle != null || this.pendingStore.lastSystemStateVersion != null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterStateBundle getLatestClusterStateBundle() throws InterruptedException {
        log.log(Level.FINE, () -> String.format("Fleetcontroller %d: Retrieving latest cluster state bundle from ZooKeeper", this.nodeIndex));
        Object object = this.databaseMonitor;
        synchronized (object) {
            if (this.database != null && !this.database.isClosed()) {
                return this.database.retrieveLastPublishedStateBundle();
            }
            return ClusterStateBundle.empty();
        }
    }

    public void saveWantedStates(Context context) throws InterruptedException {
        log.log(Level.FINE, "Fleetcontroller " + this.nodeIndex + ": Checking whether wanted states have changed compared to zookeeper version.");
        TreeMap<Node, NodeState> wantedStates = new TreeMap<Node, NodeState>();
        for (NodeInfo info : context.getCluster().getNodeInfo()) {
            if (info.getUserWantedState().equals((Object)new NodeState(info.getNode().getType(), State.UP))) continue;
            wantedStates.put(info.getNode(), info.getUserWantedState());
        }
        if (this.pendingStore.wantedStates != null || this.currentlyStored.wantedStates == null || !this.currentlyStored.wantedStates.equals(wantedStates)) {
            log.log(Level.FINE, "Fleetcontroller " + this.nodeIndex + ": Scheduling new wanted states to be stored into zookeeper.");
            this.pendingStore.wantedStates = wantedStates;
            this.doNextZooKeeperTask(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadWantedStates(Context context) throws InterruptedException {
        log.log(Level.FINE, "Fleetcontroller " + this.nodeIndex + ": Retrieving node wanted states.");
        Object object = this.databaseMonitor;
        synchronized (object) {
            if (this.database != null && !this.database.isClosed()) {
                this.currentlyStored.wantedStates = this.database.retrieveWantedStates();
            }
        }
        Map<Node, NodeState> wantedStates = this.currentlyStored.wantedStates;
        if (wantedStates == null) {
            if (this.usingZooKeeper()) {
                log.log(Level.FINE, "Fleetcontroller " + this.nodeIndex + ": Failed to retrieve wanted states from ZooKeeper. Assuming UP for all nodes.");
            }
            wantedStates = new TreeMap<Node, NodeState>();
        }
        boolean altered = false;
        for (Node node : wantedStates.keySet()) {
            NodeInfo nodeInfo = context.getCluster().getNodeInfo(node);
            if (nodeInfo == null) continue;
            NodeState wantedState = wantedStates.get(node);
            if (!nodeInfo.getUserWantedState().equals((Object)wantedState)) {
                nodeInfo.setWantedState(wantedState);
                context.getNodeStateUpdateListener().handleNewWantedNodeState(nodeInfo, wantedState);
                altered = true;
            }
            log.log(Level.FINE, "Fleetcontroller " + this.nodeIndex + ": Node " + node + " has wanted state " + wantedState);
        }
        for (NodeInfo info : context.getCluster().getNodeInfo()) {
            NodeState wantedState = wantedStates.get(info.getNode());
            if (wantedState != null || info.getUserWantedState().equals((Object)new NodeState(info.getNode().getType(), State.UP))) continue;
            info.setWantedState(null);
            context.getNodeStateUpdateListener().handleNewWantedNodeState(info, info.getWantedState().clone());
            altered = true;
        }
        return altered;
    }

    public void saveStartTimestamps(Context context) throws InterruptedException {
        log.log(Level.FINE, "Fleetcontroller " + this.nodeIndex + ": Scheduling start timestamps to be stored into zookeeper.");
        this.pendingStore.startTimestamps = context.getCluster().getStartTimestamps();
        this.doNextZooKeeperTask(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadStartTimestamps(ContentCluster cluster) throws InterruptedException {
        log.log(Level.FINE, "Fleetcontroller " + this.nodeIndex + ": Retrieving start timestamps");
        Object object = this.databaseMonitor;
        synchronized (object) {
            if (this.database == null || this.database.isClosed()) {
                return false;
            }
            this.currentlyStored.startTimestamps = this.database.retrieveStartTimestamps();
        }
        Map<Node, Long> startTimestamps = this.currentlyStored.startTimestamps;
        if (startTimestamps == null) {
            if (this.usingZooKeeper()) {
                log.log(Level.WARNING, "Fleetcontroller " + this.nodeIndex + ": Failed to retrieve start timestamps from ZooKeeper. Cluster state will be bloated with timestamps until we get them set.");
            }
            startTimestamps = new TreeMap<Node, Long>();
        }
        for (Map.Entry<Node, Long> e : startTimestamps.entrySet()) {
            cluster.setStartTimestamp(e.getKey(), e.getValue());
            log.log(Level.FINE, "Fleetcontroller " + this.nodeIndex + ": Node " + e.getKey() + " has start timestamp " + e.getValue());
        }
        return true;
    }

    private class DatabaseListener
    implements Database.DatabaseListener {
        private DatabaseListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleZooKeeperSessionDown() {
            log.log(Level.FINE, "Fleetcontroller " + DatabaseHandler.this.nodeIndex + ": Lost contact with zookeeper server");
            Object object = DatabaseHandler.this.monitor;
            synchronized (object) {
                DatabaseHandler.this.lostZooKeeperConnectionEvent = true;
                DatabaseHandler.this.monitor.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMasterData(Map<Integer, Integer> data) {
            Object object = DatabaseHandler.this.monitor;
            synchronized (object) {
                if (DatabaseHandler.this.masterDataEvent != null && DatabaseHandler.this.masterDataEvent.equals(data)) {
                    log.log(Level.FINE, "Fleetcontroller " + DatabaseHandler.this.nodeIndex + ": New master data was the same as the last one. Not responding to it");
                } else {
                    DatabaseHandler.this.masterDataEvent = data;
                }
                DatabaseHandler.this.monitor.notifyAll();
            }
        }
    }

    private static class Data {
        Integer masterVote;
        Integer lastSystemStateVersion;
        Map<Node, NodeState> wantedStates;
        Map<Node, Long> startTimestamps;
        ClusterStateBundle clusterStateBundle;

        private Data() {
        }

        void clear() {
            this.clearNonClusterStateFields();
            this.lastSystemStateVersion = null;
            this.clusterStateBundle = null;
        }

        void clearNonClusterStateFields() {
            this.masterVote = null;
            this.wantedStates = null;
            this.startTimestamps = null;
        }
    }

    public static interface Context {
        public ContentCluster getCluster();

        public FleetController getFleetController();

        public NodeAddedOrRemovedListener getNodeAddedOrRemovedListener();

        public NodeStateOrHostInfoChangeHandler getNodeStateUpdateListener();
    }
}

