/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.jrt.Spec;
import com.yahoo.vdslib.state.Node;
import com.yahoo.vespa.clustercontroller.core.hostinfo.ResourceUsage;
import java.util.Objects;

public class NodeResourceExhaustion {
    public final Node node;
    public final String resourceType;
    public final ResourceUsage resourceUsage;
    public final double limit;
    public final String rpcAddress;

    public NodeResourceExhaustion(Node node, String resourceType, ResourceUsage resourceUsage, double limit, String rpcAddress) {
        this.node = node;
        this.resourceType = resourceType;
        this.resourceUsage = resourceUsage;
        this.limit = limit;
        this.rpcAddress = rpcAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeResourceExhaustion that = (NodeResourceExhaustion)o;
        return Double.compare(that.limit, this.limit) == 0 && Objects.equals(this.node, that.node) && Objects.equals(this.resourceType, that.resourceType) && Objects.equals(this.resourceUsage, that.resourceUsage) && Objects.equals(this.rpcAddress, that.rpcAddress);
    }

    public int hashCode() {
        return Objects.hash(this.node, this.resourceType, this.resourceUsage, this.limit, this.rpcAddress);
    }

    public String toExhaustionAddedDescription() {
        return String.format("%s (%.3g > %.3g)", this.makeDescriptionPrefix(), this.resourceUsage.getUsage(), this.limit);
    }

    public String toExhaustionRemovedDescription() {
        return String.format("%s (<= %.3g)", this.makeDescriptionPrefix(), this.limit);
    }

    public String toShorthandDescription() {
        return String.format("%s%s %.3g > %.3g", this.resourceType, this.resourceUsage.getName() != null ? ":" + this.resourceUsage.getName() : "", this.resourceUsage.getUsage(), this.limit);
    }

    private String makeDescriptionPrefix() {
        return String.format("%s%s on node %d [%s]", this.resourceType, this.resourceUsage.getName() != null ? ":" + this.resourceUsage.getName() : "", this.node.getIndex(), NodeResourceExhaustion.inferHostnameFromRpcAddress(this.rpcAddress));
    }

    private static String inferHostnameFromRpcAddress(String rpcAddress) {
        if (rpcAddress == null) {
            return "unknown hostname";
        }
        Spec spec = new Spec(rpcAddress);
        if (spec.malformed()) {
            return "unknown hostname";
        }
        return spec.host();
    }
}

