/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core.status.statuspage;

import com.yahoo.document.FixedBucketSpaces;
import com.yahoo.vdslib.state.ClusterState;
import com.yahoo.vdslib.state.NodeState;
import com.yahoo.vdslib.state.NodeType;
import com.yahoo.vdslib.state.State;
import com.yahoo.vespa.clustercontroller.core.ClusterStateBundle;
import com.yahoo.vespa.clustercontroller.core.ClusterStatsAggregator;
import com.yahoo.vespa.clustercontroller.core.ContentNodeStats;
import com.yahoo.vespa.clustercontroller.core.EventLog;
import com.yahoo.vespa.clustercontroller.core.NodeInfo;
import com.yahoo.vespa.clustercontroller.core.RealTimer;
import com.yahoo.vespa.clustercontroller.core.Timer;
import com.yahoo.vespa.clustercontroller.core.hostinfo.HostInfo;
import com.yahoo.vespa.clustercontroller.core.hostinfo.ResourceUsage;
import com.yahoo.vespa.clustercontroller.core.status.statuspage.HtmlTable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;

public class VdsClusterHtmlRenderer {
    private static final TimeZone utcTimeZone = TimeZone.getTimeZone("UTC");

    public Table createNewClusterHtmlTable(String clusterName, int slobrokGenerationCount) {
        return new Table(clusterName, slobrokGenerationCount);
    }

    public static class Table {
        private final HtmlTable table = new HtmlTable();
        private final HtmlTable.CellProperties headerProperties;
        private final StringBuilder contentBuilder = new StringBuilder();
        private static final String TAG_NOT_SET = "not set";
        private static final HtmlTable.CellProperties WARNING_PROPERTY = new HtmlTable.CellProperties().setBackgroundColor(0xFFFFC0);
        private static final HtmlTable.CellProperties ERROR_PROPERTY = new HtmlTable.CellProperties().setBackgroundColor(0xFFC0C0);
        private static final HtmlTable.CellProperties CENTERED_PROPERTY = new HtmlTable.CellProperties().align(HtmlTable.Orientation.CENTER);

        Table(String clusterName, int slobrokGenerationCount) {
            this.table.getTableProperties().align(HtmlTable.Orientation.RIGHT).setBackgroundColor(0xC0FFC0);
            this.table.getColProperties(0).align(HtmlTable.Orientation.CENTER).setBackgroundColor(0xFFFFFF);
            this.table.getColProperties(1).align(HtmlTable.Orientation.LEFT);
            this.table.getColProperties(2).align(HtmlTable.Orientation.LEFT);
            this.table.getColProperties(3).align(HtmlTable.Orientation.LEFT);
            this.table.getColProperties(7).align(HtmlTable.Orientation.LEFT);
            this.table.getColProperties(14).align(HtmlTable.Orientation.LEFT);
            for (int i = 4; i < 15; ++i) {
                this.table.getColProperties(i).allowLineBreaks(false);
            }
            this.headerProperties = new HtmlTable.CellProperties().setBackgroundColor(0xFFFFFF).align(HtmlTable.Orientation.CENTER);
            this.contentBuilder.append("<h2>State of content cluster '").append(clusterName).append("'.</h2>\n").append("<p>Based on information retrieved from slobrok at generation ").append(slobrokGenerationCount).append(".</p>\n");
        }

        public void appendRaw(String rawHtml) {
            this.contentBuilder.append(rawHtml);
        }

        public void addTable(StringBuilder destination, long stableStateTimePeriode) {
            destination.append((CharSequence)this.contentBuilder);
            destination.append(this.table.toString()).append("<p>").append("<p>");
            this.addFooter(destination, stableStateTimePeriode);
        }

        public void renderNodes(TreeMap<Integer, NodeInfo> storageNodeInfos, TreeMap<Integer, NodeInfo> distributorNodeInfos, Timer timer, ClusterStateBundle state, ClusterStatsAggregator statsAggregator, double minMergeCompletionRatio, int maxPrematureCrashes, Map<String, Double> feedBlockLimits, EventLog eventLog, String pathPrefix, String name) {
            String dominantVtag = this.findDominantVtag(storageNodeInfos, distributorNodeInfos);
            this.renderNodesOneType(storageNodeInfos, NodeType.STORAGE, timer, state, statsAggregator, minMergeCompletionRatio, maxPrematureCrashes, feedBlockLimits, eventLog, pathPrefix, dominantVtag, name);
            this.renderNodesOneType(distributorNodeInfos, NodeType.DISTRIBUTOR, timer, state, statsAggregator, minMergeCompletionRatio, maxPrematureCrashes, feedBlockLimits, eventLog, pathPrefix, dominantVtag, name);
        }

        private String findDominantVtag(Map<Integer, NodeInfo> storageNodeInfos, Map<Integer, NodeInfo> distributorNodeInfos) {
            ArrayList<NodeInfo> nodeInfos = new ArrayList<NodeInfo>();
            nodeInfos.addAll(storageNodeInfos.values());
            nodeInfos.addAll(distributorNodeInfos.values());
            HashMap<String, Integer> versionTagToCount = new HashMap<String, Integer>();
            int maxCount = -1;
            String dominantVtag = null;
            for (NodeInfo nodeInfo : nodeInfos) {
                String buildTag = nodeInfo.getVtag();
                Integer count = (Integer)versionTagToCount.get(buildTag);
                count = count == null ? 1 : count + 1;
                versionTagToCount.put(buildTag, count);
                if (count <= maxCount) continue;
                maxCount = count;
                dominantVtag = buildTag;
            }
            return dominantVtag == null ? TAG_NOT_SET : dominantVtag;
        }

        private void addTableHeader(String name, NodeType nodeType) {
            this.table.addRow(new HtmlTable.Row().addCell(new HtmlTable.Cell("Group " + name).addProperties(new HtmlTable.CellProperties().setColSpan(0).setBackgroundColor(0xCCCCFF).align(HtmlTable.Orientation.LEFT))));
            this.table.addRow(new HtmlTable.Row().setHeaderRow().addProperties(this.headerProperties).addProperties(new HtmlTable.CellProperties().setRowSpan(2)).addCell(new HtmlTable.Cell(nodeType == NodeType.DISTRIBUTOR ? "Distributor" : "Storage")).addCell(new HtmlTable.Cell("Node states").addProperties(new HtmlTable.CellProperties().setColSpan(3).setRowSpan(1))).addCell(new HtmlTable.Cell("Build")).addCell(new HtmlTable.Cell("FC<sup>1)</sup>")).addCell(new HtmlTable.Cell("OCT<sup>2)</sup>")).addCell(new HtmlTable.Cell("SPT<sup>3)</sup>")).addCell(new HtmlTable.Cell("SSV<sup>4)</sup>")).addCell(new HtmlTable.Cell("PC<sup>5)</sup>")).addCell(new HtmlTable.Cell("ELW<sup>6)</sup>")).addCell(new HtmlTable.Cell(FixedBucketSpaces.defaultSpace() + " buckets").addProperties(new HtmlTable.CellProperties().setColSpan(2).setRowSpan(1))).addCell(new HtmlTable.Cell(FixedBucketSpaces.globalSpace() + " buckets").addProperties(new HtmlTable.CellProperties().setColSpan(2).setRowSpan(1))).addCell(new HtmlTable.Cell("Resource usage (%)").addProperties(new HtmlTable.CellProperties().setColSpan(2).setRowSpan(1))).addCell(new HtmlTable.Cell("Start Time")).addCell(new HtmlTable.Cell("RPC Address")));
            this.table.addRow(new HtmlTable.Row().setHeaderRow().addProperties(this.headerProperties).addCell(new HtmlTable.Cell("Reported")).addCell(new HtmlTable.Cell("Wanted")).addCell(new HtmlTable.Cell("System")).addCell(new HtmlTable.Cell("Pending")).addCell(new HtmlTable.Cell("Total")).addCell(new HtmlTable.Cell("Pending")).addCell(new HtmlTable.Cell("Total")).addCell(new HtmlTable.Cell("Disk")).addCell(new HtmlTable.Cell("Memory")));
        }

        private void renderNodesOneType(TreeMap<Integer, NodeInfo> nodeInfos, NodeType nodeType, Timer timer, ClusterStateBundle stateBundle, ClusterStatsAggregator statsAggregator, double minMergeCompletionRatio, int maxPrematureCrashes, Map<String, Double> feedBlockLimits, EventLog eventLog, String pathPrefix, String dominantVtag, String name) {
            ClusterState state = stateBundle.getBaselineClusterState();
            long currentTime = timer.getCurrentTimeInMillis();
            this.addTableHeader(name, nodeType);
            for (NodeInfo nodeInfo : nodeInfos.values()) {
                HtmlTable.Row row = new HtmlTable.Row();
                long timeSinceContact = nodeInfo.getTimeOfFirstFailingConnectionAttempt() == 0L ? 0L : currentTime - nodeInfo.getTimeOfFirstFailingConnectionAttempt();
                this.addNodeIndex(pathPrefix, nodeInfo, row);
                this.addReportedState(nodeInfo, row);
                this.addWantedState(nodeInfo, row);
                this.addCurrentState(state, nodeInfo, row);
                this.addBuildTagVersion(dominantVtag, nodeInfo, row);
                this.addFailedConnectionAttemptCount(nodeInfo, row, timeSinceContact);
                this.addTimeSinceFirstFailing(nodeInfo, row, timeSinceContact);
                this.addStatePendingTime(currentTime, nodeInfo, row);
                this.addClusterStateVersion(stateBundle, nodeInfo, row);
                this.addPrematureCrashes(maxPrematureCrashes, nodeInfo, row);
                this.addEventsLastWeek(eventLog, currentTime, nodeInfo, row);
                this.addBucketSpacesStats(nodeType, statsAggregator, minMergeCompletionRatio, nodeInfo, row);
                this.addResourceUsage(nodeInfo, feedBlockLimits, row);
                this.addStartTime(nodeInfo, row);
                this.addRpcAddress(nodeInfo, row);
                this.table.addRow(row);
            }
        }

        private void addRpcAddress(NodeInfo nodeInfo, HtmlTable.Row row) {
            if (nodeInfo.getRpcAddress() == null) {
                row.addCell(new HtmlTable.Cell("-").addProperties(ERROR_PROPERTY));
            } else {
                row.addCell(new HtmlTable.Cell(HtmlTable.escape(nodeInfo.getRpcAddress())));
                if (nodeInfo.isRpcAddressOutdated()) {
                    row.getLastCell().addProperties(WARNING_PROPERTY);
                }
            }
        }

        private void addStartTime(NodeInfo nodeInfo, HtmlTable.Row row) {
            if (nodeInfo.getStartTimestamp() == 0L) {
                row.addCell(new HtmlTable.Cell("-").addProperties(ERROR_PROPERTY).addProperties(CENTERED_PROPERTY));
            } else {
                String startTime = RealTimer.printDateNoMilliSeconds(1000L * nodeInfo.getStartTimestamp(), utcTimeZone);
                row.addCell(new HtmlTable.Cell(HtmlTable.escape(startTime)));
            }
        }

        private void addBucketSpacesStats(NodeType nodeType, ClusterStatsAggregator statsAggregator, double minMergeCompletionRatio, NodeInfo nodeInfo, HtmlTable.Row row) {
            if (nodeType.equals((Object)NodeType.STORAGE)) {
                Table.addBucketStats(row, Table.getStatsForContentNode(statsAggregator, nodeInfo, FixedBucketSpaces.defaultSpace()), minMergeCompletionRatio);
                Table.addBucketStats(row, Table.getStatsForContentNode(statsAggregator, nodeInfo, FixedBucketSpaces.globalSpace()), minMergeCompletionRatio);
            } else {
                Table.addBucketStats(row, Table.getStatsForDistributorNode(statsAggregator, nodeInfo, FixedBucketSpaces.defaultSpace()), minMergeCompletionRatio);
                Table.addBucketStats(row, Table.getStatsForDistributorNode(statsAggregator, nodeInfo, FixedBucketSpaces.globalSpace()), minMergeCompletionRatio);
            }
        }

        private void addResourceUsage(NodeInfo nodeInfo, Map<String, Double> feedBlockLimits, HtmlTable.Row row) {
            if (nodeInfo.isDistributor()) {
                row.addCell(new HtmlTable.Cell("-").addProperties(CENTERED_PROPERTY));
                row.addCell(new HtmlTable.Cell("-").addProperties(CENTERED_PROPERTY));
                return;
            }
            this.addSingleResourceUsageCell(nodeInfo, "disk", feedBlockLimits, row);
            this.addSingleResourceUsageCell(nodeInfo, "memory", feedBlockLimits, row);
        }

        private void addSingleResourceUsageCell(NodeInfo nodeInfo, String resourceType, Map<String, Double> feedBlockLimits, HtmlTable.Row row) {
            HostInfo hostInfo = nodeInfo.getHostInfo();
            Map<String, ResourceUsage> usages = hostInfo.getContentNode().getResourceUsage();
            ResourceUsage usage = usages.get(resourceType);
            if (usage != null && usage.getUsage() != null) {
                row.addCell(new HtmlTable.Cell(String.format("%.2f", usage.getUsage() * 100.0)));
                double limit = feedBlockLimits.getOrDefault(resourceType, 1.0);
                if (usage.getUsage() > limit) {
                    row.getLastCell().addProperties(ERROR_PROPERTY);
                } else if (usage.getUsage() > limit - 0.05) {
                    row.getLastCell().addProperties(WARNING_PROPERTY);
                }
            } else {
                row.addCell(new HtmlTable.Cell("-").addProperties(CENTERED_PROPERTY));
            }
        }

        private void addEventsLastWeek(EventLog eventLog, long currentTime, NodeInfo nodeInfo, HtmlTable.Row row) {
            int nodeEvents = eventLog.getNodeEventsSince(nodeInfo.getNode(), currentTime - eventLog.getRecentTimePeriod());
            row.addCell(new HtmlTable.Cell("" + nodeEvents));
            if (nodeEvents > 20) {
                row.getLastCell().addProperties(ERROR_PROPERTY);
            } else if (nodeEvents > 3) {
                row.getLastCell().addProperties(WARNING_PROPERTY);
            }
        }

        private void addPrematureCrashes(int maxPrematureCrashes, NodeInfo nodeInfo, HtmlTable.Row row) {
            row.addCell(new HtmlTable.Cell("" + nodeInfo.getPrematureCrashCount()));
            if (nodeInfo.getPrematureCrashCount() >= maxPrematureCrashes) {
                row.getLastCell().addProperties(ERROR_PROPERTY);
            } else if (nodeInfo.getPrematureCrashCount() > 0) {
                row.getLastCell().addProperties(WARNING_PROPERTY);
            }
        }

        private void addClusterStateVersion(ClusterStateBundle state, NodeInfo nodeInfo, HtmlTable.Row row) {
            String cellContent = nodeInfo.getClusterStateVersionActivationAcked() == state.getVersion() || !state.deferredActivation() ? String.format("%d", nodeInfo.getClusterStateVersionBundleAcknowledged()) : String.format("%d (%d)", nodeInfo.getClusterStateVersionBundleAcknowledged(), nodeInfo.getClusterStateVersionActivationAcked());
            row.addCell(new HtmlTable.Cell(cellContent));
            if (nodeInfo.getClusterStateVersionBundleAcknowledged() < state.getVersion() - 2) {
                row.getLastCell().addProperties(ERROR_PROPERTY);
            } else if (nodeInfo.getClusterStateVersionBundleAcknowledged() < state.getVersion()) {
                row.getLastCell().addProperties(WARNING_PROPERTY);
            }
        }

        private void addStatePendingTime(long currentTime, NodeInfo nodeInfo, HtmlTable.Row row) {
            if (nodeInfo.getLatestNodeStateRequestTime() == null) {
                row.addCell(new HtmlTable.Cell("-").addProperties(CENTERED_PROPERTY));
            } else {
                row.addCell(new HtmlTable.Cell(HtmlTable.escape(RealTimer.printDuration(currentTime - nodeInfo.getLatestNodeStateRequestTime()))));
            }
        }

        private void addTimeSinceFirstFailing(NodeInfo nodeInfo, HtmlTable.Row row, long timeSinceContact) {
            row.addCell(new HtmlTable.Cell(timeSinceContact / 1000L + " s"));
            if (timeSinceContact > 60000L) {
                row.getLastCell().addProperties(ERROR_PROPERTY);
            } else if (nodeInfo.getConnectionAttemptCount() > 0) {
                row.getLastCell().addProperties(WARNING_PROPERTY);
            }
        }

        private void addFailedConnectionAttemptCount(NodeInfo nodeInfo, HtmlTable.Row row, long timeSinceContact) {
            row.addCell(new HtmlTable.Cell("" + nodeInfo.getConnectionAttemptCount()));
            if (timeSinceContact > 60000L) {
                row.getLastCell().addProperties(ERROR_PROPERTY);
            } else if (nodeInfo.getConnectionAttemptCount() > 0) {
                row.getLastCell().addProperties(WARNING_PROPERTY);
            }
        }

        private void addBuildTagVersion(String dominantVtag, NodeInfo nodeInfo, HtmlTable.Row row) {
            String buildTagText = nodeInfo.getVtag() != null ? nodeInfo.getVtag() : TAG_NOT_SET;
            row.addCell(new HtmlTable.Cell(buildTagText));
            if (!dominantVtag.equals(nodeInfo.getVtag())) {
                row.getLastCell().addProperties(WARNING_PROPERTY);
            }
        }

        private void addCurrentState(ClusterState state, NodeInfo nodeInfo, HtmlTable.Row row) {
            NodeState ns = state.getNodeState(nodeInfo.getNode()).clone().setDescription("").setMinUsedBits(16);
            if (state.getClusterState().oneOf("uir")) {
                row.addCell(new HtmlTable.Cell(HtmlTable.escape(ns.toString(true))));
                if (ns.getState().equals((Object)State.DOWN)) {
                    row.getLastCell().addProperties(ERROR_PROPERTY);
                } else if (ns.getState().oneOf("mi")) {
                    row.getLastCell().addProperties(WARNING_PROPERTY);
                }
            } else {
                row.addCell(new HtmlTable.Cell("Cluster " + state.getClusterState().name().toLowerCase()).addProperties(ERROR_PROPERTY));
            }
        }

        private void addWantedState(NodeInfo nodeInfo, HtmlTable.Row row) {
            if (nodeInfo.getWantedState() == null || nodeInfo.getWantedState().getState().equals((Object)State.UP)) {
                row.addCell(new HtmlTable.Cell("-").addProperties(CENTERED_PROPERTY));
            } else {
                row.addCell(new HtmlTable.Cell(HtmlTable.escape(nodeInfo.getWantedState().toString(true))));
                if (nodeInfo.getWantedState().toString(true).indexOf("Disabled by fleet controller") != -1) {
                    row.getLastCell().addProperties(ERROR_PROPERTY);
                } else {
                    row.getLastCell().addProperties(WARNING_PROPERTY);
                }
            }
        }

        private void addReportedState(NodeInfo nodeInfo, HtmlTable.Row row) {
            NodeState reportedState = nodeInfo.getReportedState().clone().setStartTimestamp(0L);
            row.addCell(new HtmlTable.Cell(HtmlTable.escape(reportedState.toString(true))));
            if (!nodeInfo.getReportedState().getState().equals((Object)State.UP)) {
                row.getLastCell().addProperties(WARNING_PROPERTY);
            }
        }

        private void addNodeIndex(String pathPrefix, NodeInfo nodeInfo, HtmlTable.Row row) {
            row.addCell(new HtmlTable.Cell("<a href=\"" + pathPrefix + "/node=" + nodeInfo.getNode() + "\">" + nodeInfo.getNodeIndex() + "</a>"));
        }

        private static ContentNodeStats.BucketSpaceStats getStatsForContentNode(ClusterStatsAggregator statsAggregator, NodeInfo nodeInfo, String bucketSpace) {
            ContentNodeStats nodeStats = statsAggregator.getAggregatedStats().getStats().getContentNode(nodeInfo.getNodeIndex());
            if (nodeStats != null) {
                return nodeStats.getBucketSpace(bucketSpace);
            }
            return null;
        }

        private static ContentNodeStats.BucketSpaceStats getStatsForDistributorNode(ClusterStatsAggregator statsAggregator, NodeInfo nodeInfo, String bucketSpace) {
            ContentNodeStats nodeStats = statsAggregator.getAggregatedStatsForDistributor(nodeInfo.getNodeIndex());
            return nodeStats.getBucketSpace(bucketSpace);
        }

        private static void addBucketStats(HtmlTable.Row row, ContentNodeStats.BucketSpaceStats bucketSpaceStats, double minMergeCompletionRatio) {
            if (bucketSpaceStats != null) {
                long bucketsPending = bucketSpaceStats.getBucketsPending();
                long bucketsTotal = bucketSpaceStats.getBucketsTotal();
                Object cellValuePending = String.valueOf(bucketsPending);
                Object cellValueTotal = String.valueOf(bucketsTotal);
                if (!bucketSpaceStats.valid()) {
                    cellValuePending = (String)cellValuePending + "?";
                    cellValueTotal = (String)cellValueTotal + "?";
                }
                row.addCell(new HtmlTable.Cell((String)cellValuePending));
                if (bucketSpaceStats.mayHaveBucketsPending(minMergeCompletionRatio)) {
                    row.getLastCell().addProperties(WARNING_PROPERTY);
                }
                row.addCell(new HtmlTable.Cell((String)cellValueTotal));
            } else {
                row.addCell(new HtmlTable.Cell("-").addProperties(CENTERED_PROPERTY));
                row.addCell(new HtmlTable.Cell("-").addProperties(CENTERED_PROPERTY));
            }
        }

        private void addFooter(StringBuilder contentBuilder, long stableStateTimePeriode) {
            contentBuilder.append("<font size=\"-1\">\n").append("1) FC - Failed connections - We have tried to connect to the nodes this many times without being able to contact it.<br>\n").append("2) OCT - Out of contact time - Time in seconds we have failed to contact the node.<br>\n").append("3) SPT - State pending time - Time the current getNodeState request has been pending.<br>\n").append("4) SSV - System state version - The latest system state version the node has acknowledged (last <em>activated</em> state version in parentheses if this is not equal to SSV).<br>\n").append("5) PC - Premature crashes - Number of times node has crashed since last time it had been stable in up or down state for more than " + RealTimer.printDuration(stableStateTimePeriode) + ".<br>\n").append("6) ELW - Events last week - The number of events that has occured on this node the last week. (Or shorter period if a week haven't passed since restart or more than max events to keep in node event log have happened during last week.)<br>\n").append("</font>\n");
        }
    }
}

