/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core.rpc;

import com.google.common.base.Preconditions;
import com.yahoo.jrt.DataValue;
import com.yahoo.jrt.Int32Value;
import com.yahoo.jrt.Int8Value;
import com.yahoo.jrt.Request;
import com.yahoo.jrt.RequestWaiter;
import com.yahoo.jrt.Spec;
import com.yahoo.jrt.StringValue;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Target;
import com.yahoo.jrt.Transport;
import com.yahoo.jrt.Value;
import com.yahoo.jrt.Values;
import com.yahoo.vdslib.state.ClusterState;
import com.yahoo.vdslib.state.NodeState;
import com.yahoo.vdslib.state.State;
import com.yahoo.vespa.clustercontroller.core.ActivateClusterStateVersionRequest;
import com.yahoo.vespa.clustercontroller.core.ClusterStateBundle;
import com.yahoo.vespa.clustercontroller.core.Communicator;
import com.yahoo.vespa.clustercontroller.core.FleetControllerOptions;
import com.yahoo.vespa.clustercontroller.core.GetNodeStateRequest;
import com.yahoo.vespa.clustercontroller.core.NodeInfo;
import com.yahoo.vespa.clustercontroller.core.SetClusterStateRequest;
import com.yahoo.vespa.clustercontroller.core.Timer;
import com.yahoo.vespa.clustercontroller.core.rpc.EncodedClusterStateBundle;
import com.yahoo.vespa.clustercontroller.core.rpc.RPCActivateClusterStateVersionRequest;
import com.yahoo.vespa.clustercontroller.core.rpc.RPCActivateClusterStateVersionWaiter;
import com.yahoo.vespa.clustercontroller.core.rpc.RPCGetNodeStateRequest;
import com.yahoo.vespa.clustercontroller.core.rpc.RPCGetNodeStateWaiter;
import com.yahoo.vespa.clustercontroller.core.rpc.RPCSetClusterStateRequest;
import com.yahoo.vespa.clustercontroller.core.rpc.RPCSetClusterStateWaiter;
import com.yahoo.vespa.clustercontroller.core.rpc.SlimeClusterStateBundleCodec;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RPCCommunicator
implements Communicator {
    public static final Logger log = Logger.getLogger(RPCCommunicator.class.getName());
    public static final int ACTIVATE_CLUSTER_STATE_VERSION_RPC_VERSION = 4;
    public static final String ACTIVATE_CLUSTER_STATE_VERSION_RPC_METHOD_NAME = "activate_cluster_state_version";
    public static final int SET_DISTRIBUTION_STATES_RPC_VERSION = 3;
    public static final String SET_DISTRIBUTION_STATES_RPC_METHOD_NAME = "setdistributionstates";
    public static final int LEGACY_SET_SYSTEM_STATE2_RPC_VERSION = 2;
    public static final String LEGACY_SET_SYSTEM_STATE2_RPC_METHOD_NAME = "setsystemstate2";
    private final Timer timer;
    private final Supervisor supervisor;
    private double nodeStateRequestTimeoutIntervalMaxSeconds;
    private int nodeStateRequestTimeoutIntervalStartPercentage;
    private int nodeStateRequestTimeoutIntervalStopPercentage;
    private int nodeStateRequestRoundTripTimeMaxSeconds;
    private final int fleetControllerIndex;

    public static Supervisor createRealSupervisor() {
        return new Supervisor(new Transport("rpc-communicator"));
    }

    public RPCCommunicator(Supervisor supervisor, Timer t, int index, int nodeStateRequestTimeoutIntervalMaxMs, int nodeStateRequestTimeoutIntervalStartPercentage, int nodeStateRequestTimeoutIntervalStopPercentage, int nodeStateRequestRoundTripTimeMaxSeconds) {
        this.timer = t;
        this.fleetControllerIndex = index;
        Preconditions.checkArgument((nodeStateRequestTimeoutIntervalMaxMs > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((nodeStateRequestTimeoutIntervalStartPercentage >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((nodeStateRequestTimeoutIntervalStartPercentage <= 100 ? 1 : 0) != 0);
        Preconditions.checkArgument((nodeStateRequestTimeoutIntervalStopPercentage >= nodeStateRequestTimeoutIntervalStartPercentage ? 1 : 0) != 0);
        Preconditions.checkArgument((nodeStateRequestTimeoutIntervalStartPercentage <= 100 ? 1 : 0) != 0);
        Preconditions.checkArgument((nodeStateRequestRoundTripTimeMaxSeconds >= 0 ? 1 : 0) != 0);
        this.nodeStateRequestTimeoutIntervalMaxSeconds = (double)nodeStateRequestTimeoutIntervalMaxMs / 1000.0;
        this.nodeStateRequestTimeoutIntervalStartPercentage = nodeStateRequestTimeoutIntervalStartPercentage;
        this.nodeStateRequestTimeoutIntervalStopPercentage = nodeStateRequestTimeoutIntervalStopPercentage;
        this.nodeStateRequestRoundTripTimeMaxSeconds = nodeStateRequestRoundTripTimeMaxSeconds;
        this.supervisor = supervisor;
    }

    @Override
    public void shutdown() {
        this.supervisor.transport().shutdown().join();
    }

    public Target getConnection(NodeInfo node) {
        Target t = node.getConnection();
        if (t == null || !t.isValid()) {
            t = node.setConnection(this.supervisor.connect(new Spec(node.getRpcAddress())));
        }
        return t;
    }

    @Override
    public void propagateOptions(FleetControllerOptions options) {
        Preconditions.checkArgument((options.nodeStateRequestTimeoutMS > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((options.nodeStateRequestTimeoutEarliestPercentage >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((options.nodeStateRequestTimeoutEarliestPercentage <= 100 ? 1 : 0) != 0);
        Preconditions.checkArgument((options.nodeStateRequestTimeoutLatestPercentage >= options.nodeStateRequestTimeoutEarliestPercentage ? 1 : 0) != 0);
        Preconditions.checkArgument((options.nodeStateRequestTimeoutLatestPercentage <= 100 ? 1 : 0) != 0);
        Preconditions.checkArgument((options.nodeStateRequestRoundTripTimeMaxSeconds >= 0 ? 1 : 0) != 0);
        this.nodeStateRequestTimeoutIntervalMaxSeconds = (double)options.nodeStateRequestTimeoutMS / 1000.0;
        this.nodeStateRequestTimeoutIntervalStartPercentage = options.nodeStateRequestTimeoutEarliestPercentage;
        this.nodeStateRequestTimeoutIntervalStopPercentage = options.nodeStateRequestTimeoutLatestPercentage;
        this.nodeStateRequestRoundTripTimeMaxSeconds = options.nodeStateRequestRoundTripTimeMaxSeconds;
    }

    @Override
    public void getNodeState(NodeInfo node, Communicator.Waiter<GetNodeStateRequest> externalWaiter) {
        Target connection = this.getConnection(node);
        if (!connection.isValid()) {
            log.log(Level.FINE, () -> String.format("Connection to '%s' could not be created.", node.getRpcAddress()));
        }
        NodeState currentState = node.getReportedState();
        Request req = new Request("getnodestate3");
        req.parameters().add((Value)new StringValue(currentState.getState().equals((Object)State.DOWN) || node.getConnectionAttemptCount() > 0 ? "unknown" : currentState.serialize()));
        req.parameters().add((Value)new Int32Value(this.generateNodeStateRequestTimeoutMs()));
        req.parameters().add((Value)new Int32Value(this.fleetControllerIndex));
        RPCGetNodeStateRequest stateRequest = new RPCGetNodeStateRequest(node, req);
        RPCGetNodeStateWaiter waiter = new RPCGetNodeStateWaiter(stateRequest, externalWaiter, this.timer);
        double requestTimeoutSeconds = this.nodeStateRequestTimeoutIntervalMaxSeconds + (double)this.nodeStateRequestRoundTripTimeMaxSeconds;
        connection.invokeAsync(req, requestTimeoutSeconds, (RequestWaiter)waiter);
        node.setCurrentNodeStateRequest(stateRequest, this.timer.getCurrentTimeInMillis());
        node.lastRequestInfoConnection = connection;
    }

    @Override
    public void setSystemState(ClusterStateBundle stateBundle, NodeInfo node, Communicator.Waiter<SetClusterStateRequest> externalWaiter) {
        Request req;
        RPCSetClusterStateWaiter waiter = new RPCSetClusterStateWaiter(externalWaiter, this.timer);
        ClusterState baselineState = stateBundle.getBaselineClusterState();
        Target connection = this.getConnection(node);
        if (!connection.isValid()) {
            log.log(Level.FINE, () -> String.format("Connection to '%s' could not be created.", node.getRpcAddress()));
            return;
        }
        int nodeVersion = node.getVersion();
        if (nodeVersion <= 2) {
            req = new Request(LEGACY_SET_SYSTEM_STATE2_RPC_METHOD_NAME);
            req.parameters().add((Value)new StringValue(baselineState.toString(false)));
        } else {
            req = new Request(SET_DISTRIBUTION_STATES_RPC_METHOD_NAME);
            SlimeClusterStateBundleCodec codec = new SlimeClusterStateBundleCodec();
            EncodedClusterStateBundle encodedBundle = codec.encode(stateBundle);
            Values v = req.parameters();
            v.add((Value)new Int8Value(encodedBundle.getCompression().type().getCode()));
            v.add((Value)new Int32Value(encodedBundle.getCompression().uncompressedSize()));
            v.add((Value)new DataValue(encodedBundle.getCompression().data()));
        }
        log.log(Level.FINE, () -> String.format("Sending '%s' RPC to %s for state version %d", req.methodName(), node.getRpcAddress(), stateBundle.getVersion()));
        RPCSetClusterStateRequest stateRequest = new RPCSetClusterStateRequest(node, req, baselineState.getVersion());
        waiter.setRequest(stateRequest);
        connection.invokeAsync(req, 60.0, (RequestWaiter)waiter);
        node.setClusterStateVersionBundleSent(stateBundle);
    }

    @Override
    public void activateClusterStateVersion(int clusterStateVersion, NodeInfo node, Communicator.Waiter<ActivateClusterStateVersionRequest> externalWaiter) {
        RPCActivateClusterStateVersionWaiter waiter = new RPCActivateClusterStateVersionWaiter(externalWaiter);
        Target connection = this.getConnection(node);
        if (!connection.isValid()) {
            log.log(Level.FINE, () -> String.format("Connection to '%s' could not be created.", node.getRpcAddress()));
            return;
        }
        Request req = new Request(ACTIVATE_CLUSTER_STATE_VERSION_RPC_METHOD_NAME);
        req.parameters().add((Value)new Int32Value(clusterStateVersion));
        log.log(Level.FINE, () -> String.format("Sending '%s' RPC to %s for state version %d", req.methodName(), node.getRpcAddress(), clusterStateVersion));
        RPCActivateClusterStateVersionRequest activationRequest = new RPCActivateClusterStateVersionRequest(node, req, clusterStateVersion);
        waiter.setRequest(activationRequest);
        connection.invokeAsync(req, 60.0, (RequestWaiter)waiter);
        node.setClusterStateVersionActivationSent(clusterStateVersion);
    }

    protected int generateNodeStateRequestTimeoutMs() {
        double intervalFraction = Math.random();
        double earliestTimeoutSeconds = this.nodeStateRequestTimeoutIntervalMaxSeconds * (double)this.nodeStateRequestTimeoutIntervalStartPercentage / 100.0;
        double latestTimeoutSeconds = this.nodeStateRequestTimeoutIntervalMaxSeconds * (double)this.nodeStateRequestTimeoutIntervalStopPercentage / 100.0;
        double interval = latestTimeoutSeconds - earliestTimeoutSeconds;
        double timeoutSeconds = earliestTimeoutSeconds + intervalFraction * interval;
        return (int)(timeoutSeconds * 1000.0);
    }
}

