/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.vdslib.distribution.ConfiguredNode;
import com.yahoo.vdslib.distribution.Distribution;
import com.yahoo.vdslib.distribution.Group;
import com.yahoo.vdslib.state.ClusterState;
import com.yahoo.vdslib.state.Node;
import com.yahoo.vdslib.state.NodeState;
import com.yahoo.vdslib.state.NodeType;
import com.yahoo.vdslib.state.State;
import com.yahoo.vespa.clustercontroller.core.ClusterInfo;
import com.yahoo.vespa.clustercontroller.core.ClusterStateBundle;
import com.yahoo.vespa.clustercontroller.core.ClusterStatsAggregator;
import com.yahoo.vespa.clustercontroller.core.EventLog;
import com.yahoo.vespa.clustercontroller.core.FleetControllerOptions;
import com.yahoo.vespa.clustercontroller.core.HierarchicalGroupVisitingAdapter;
import com.yahoo.vespa.clustercontroller.core.LeafGroups;
import com.yahoo.vespa.clustercontroller.core.NodeInfo;
import com.yahoo.vespa.clustercontroller.core.NodeStateChangeChecker;
import com.yahoo.vespa.clustercontroller.core.Timer;
import com.yahoo.vespa.clustercontroller.core.status.statuspage.HtmlTable;
import com.yahoo.vespa.clustercontroller.core.status.statuspage.VdsClusterHtmlRenderer;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.requests.SetUnitStateRequest;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class ContentCluster {
    private final String clusterName;
    private final ClusterInfo clusterInfo = new ClusterInfo();
    private final Map<Node, Long> nodeStartTimestamps = new TreeMap<Node, Long>();
    private int slobrokGenerationCount = 0;
    private int pollingFrequency = 5000;
    private Distribution distribution;
    private int minStorageNodesUp;
    private double minRatioOfStorageNodesUp;

    public ContentCluster(String clusterName, Collection<ConfiguredNode> configuredNodes, Distribution distribution, int minStorageNodesUp, double minRatioOfStorageNodesUp) {
        if (configuredNodes == null) {
            throw new IllegalArgumentException("Nodes must be set");
        }
        this.clusterName = clusterName;
        this.distribution = distribution;
        this.minStorageNodesUp = minStorageNodesUp;
        this.minRatioOfStorageNodesUp = minRatioOfStorageNodesUp;
        this.setNodes(configuredNodes);
    }

    public void writeHtmlState(VdsClusterHtmlRenderer vdsClusterHtmlRenderer, StringBuilder sb, Timer timer, ClusterStateBundle state, ClusterStatsAggregator statsAggregator, Distribution distribution, FleetControllerOptions options, EventLog eventLog) {
        VdsClusterHtmlRenderer.Table table = vdsClusterHtmlRenderer.createNewClusterHtmlTable(this.clusterName, this.slobrokGenerationCount);
        if (state.clusterFeedIsBlocked()) {
            table.appendRaw("<h3 style=\"color: red\">Cluster feeding is blocked!</h3>\n");
            table.appendRaw(String.format("<p>Summary: <strong>%s</strong></p>\n", HtmlTable.escape(state.getFeedBlockOrNull().getDescription())));
        }
        List<Group> groups = LeafGroups.enumerateFrom(distribution.getRootGroup());
        for (int j = 0; j < groups.size(); ++j) {
            Group group = groups.get(j);
            assert (group != null);
            String localName = group.getUnixStylePath();
            assert (localName != null);
            TreeMap<Integer, NodeInfo> storageNodeInfoByIndex = new TreeMap<Integer, NodeInfo>();
            TreeMap<Integer, NodeInfo> distributorNodeInfoByIndex = new TreeMap<Integer, NodeInfo>();
            for (ConfiguredNode configuredNode : group.getNodes()) {
                this.storeNodeInfo(configuredNode.index(), NodeType.STORAGE, storageNodeInfoByIndex);
                this.storeNodeInfo(configuredNode.index(), NodeType.DISTRIBUTOR, distributorNodeInfoByIndex);
            }
            table.renderNodes(storageNodeInfoByIndex, distributorNodeInfoByIndex, timer, state, statsAggregator, options.minMergeCompletionRatio, options.maxPrematureCrashes, options.clusterFeedBlockLimit, eventLog, this.clusterName, localName);
        }
        table.addTable(sb, options.stableStateTimePeriod);
    }

    private void storeNodeInfo(int nodeIndex, NodeType nodeType, Map<Integer, NodeInfo> nodeInfoByIndex) {
        NodeInfo nodeInfo = this.getNodeInfo(new Node(nodeType, nodeIndex));
        if (nodeInfo == null) {
            return;
        }
        nodeInfoByIndex.put(nodeIndex, nodeInfo);
    }

    public Distribution getDistribution() {
        return this.distribution;
    }

    public void setDistribution(Distribution distribution) {
        this.distribution = distribution;
        for (NodeInfo info : this.clusterInfo.getAllNodeInfo()) {
            info.setGroup(distribution);
        }
    }

    public final void setNodes(Collection<ConfiguredNode> configuredNodes) {
        this.clusterInfo.setNodes(configuredNodes, this, this.distribution);
    }

    public void setStartTimestamp(Node n, long startTimestamp) {
        this.nodeStartTimestamps.put(n, startTimestamp);
    }

    public long getStartTimestamp(Node n) {
        Long value = this.nodeStartTimestamps.get(n);
        return value == null ? 0L : value;
    }

    public Map<Node, Long> getStartTimestamps() {
        return this.nodeStartTimestamps;
    }

    public void clearStates() {
        for (NodeInfo info : this.clusterInfo.getAllNodeInfo()) {
            info.setReportedState(null, 0L);
        }
    }

    public boolean allStatesReported() {
        return this.clusterInfo.allStatesReported();
    }

    public int getPollingFrequency() {
        return this.pollingFrequency;
    }

    public void setPollingFrequency(int millisecs) {
        this.pollingFrequency = millisecs;
    }

    public Map<Integer, ConfiguredNode> getConfiguredNodes() {
        return this.clusterInfo.getConfiguredNodes();
    }

    public Collection<NodeInfo> getNodeInfo() {
        return Collections.unmodifiableCollection(this.clusterInfo.getAllNodeInfo());
    }

    public ClusterInfo clusterInfo() {
        return this.clusterInfo;
    }

    public String getName() {
        return this.clusterName;
    }

    public NodeInfo getNodeInfo(Node node) {
        return this.clusterInfo.getNodeInfo(node);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ContentCluster(").append(this.clusterName).append(") {");
        for (NodeInfo node : this.clusterInfo.getAllNodeInfo()) {
            sb.append("\n  ").append(node);
        }
        sb.append("\n}");
        return sb.toString();
    }

    public int getSlobrokGenerationCount() {
        return this.slobrokGenerationCount;
    }

    public void setSlobrokGenerationCount(int count) {
        this.slobrokGenerationCount = count;
    }

    private void getLeaves(Group node, List<Group> leaves, List<String> names, String name) {
        if (node.isLeafGroup()) {
            leaves.add(node);
            names.add(name + "/" + node.getName());
            return;
        }
        for (Group g : node.getSubgroups().values()) {
            this.getLeaves(g, leaves, names, name + (String)(node.getName() != null ? "/" + node.getName() : ""));
        }
    }

    public NodeStateChangeChecker.Result calculateEffectOfNewState(Node node, ClusterState clusterState, SetUnitStateRequest.Condition condition, NodeState oldState, NodeState newState) {
        NodeStateChangeChecker nodeStateChangeChecker = new NodeStateChangeChecker(this.minStorageNodesUp, this.minRatioOfStorageNodesUp, this.distribution.getRedundancy(), new HierarchicalGroupVisitingAdapter(this.distribution), this.clusterInfo);
        return nodeStateChangeChecker.evaluateTransition(node, clusterState, condition, oldState, newState);
    }

    public List<Integer> nodesSafelySetTo(State state) {
        switch (state) {
            case MAINTENANCE: 
            case DOWN: {
                return this.clusterInfo.getStorageNodeInfo().stream().filter(storageNodeInfo -> {
                    NodeState userWantedState = storageNodeInfo.getUserWantedState();
                    return userWantedState.getState() == state && Objects.equals(userWantedState.getDescription(), "Orchestrator");
                }).map(NodeInfo::getNodeIndex).collect(Collectors.toList());
            }
        }
        return List.of();
    }

    public void setMinStorageNodesUp(int minStorageNodesUp) {
        this.minStorageNodesUp = minStorageNodesUp;
    }

    public void setMinRatioOfStorageNodesUp(double minRatioOfStorageNodesUp) {
        this.minRatioOfStorageNodesUp = minRatioOfStorageNodesUp;
    }

    public boolean hasConfiguredNode(int index) {
        return this.clusterInfo.hasConfiguredNode(index);
    }
}

