/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.vdslib.state.ClusterState;
import com.yahoo.vespa.clustercontroller.core.AnnotatedClusterState;
import com.yahoo.vespa.clustercontroller.core.ClusterStateBundle;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class ClusterStateHistoryEntry {
    private final ClusterStateBundle state;
    private final long time;

    ClusterStateHistoryEntry(ClusterStateBundle state, long time) {
        this.state = state;
        this.time = time;
    }

    public ClusterState getBaselineState() {
        return this.state.getBaselineClusterState();
    }

    public Map<String, ClusterState> getDerivedBucketSpaceStates() {
        return this.state.getDerivedBucketSpaceStates().entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> ((AnnotatedClusterState)entry.getValue()).getClusterState()));
    }

    public long time() {
        return this.time;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterStateHistoryEntry that = (ClusterStateHistoryEntry)o;
        return this.time == that.time && Objects.equals(this.state, that.state);
    }

    public int hashCode() {
        return Objects.hash(this.state, this.time);
    }

    public String toString() {
        return String.format("state '%s' at time %d", this.state, this.time);
    }
}

