/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.vdslib.state.ClusterState;
import com.yahoo.vespa.clustercontroller.core.AnnotatedClusterState;
import com.yahoo.vespa.clustercontroller.core.ClusterStateDeriver;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ClusterStateBundle {
    private final AnnotatedClusterState baselineState;
    private final Map<String, AnnotatedClusterState> derivedBucketSpaceStates;
    private final boolean deferredActivation;

    private ClusterStateBundle(AnnotatedClusterState baselineState, Map<String, AnnotatedClusterState> derivedBucketSpaceStates) {
        this(baselineState, derivedBucketSpaceStates, false);
    }

    private ClusterStateBundle(AnnotatedClusterState baselineState, Map<String, AnnotatedClusterState> derivedBucketSpaceStates, boolean deferredActivation) {
        this.baselineState = baselineState;
        this.derivedBucketSpaceStates = Collections.unmodifiableMap(derivedBucketSpaceStates);
        this.deferredActivation = deferredActivation;
    }

    public static Builder builder(AnnotatedClusterState baselineState) {
        return new Builder(baselineState);
    }

    public static ClusterStateBundle of(AnnotatedClusterState baselineState, Map<String, AnnotatedClusterState> derivedBucketSpaceStates) {
        return new ClusterStateBundle(baselineState, derivedBucketSpaceStates);
    }

    public static ClusterStateBundle of(AnnotatedClusterState baselineState, Map<String, AnnotatedClusterState> derivedBucketSpaceStates, boolean deferredActivation) {
        return new ClusterStateBundle(baselineState, derivedBucketSpaceStates, deferredActivation);
    }

    public static ClusterStateBundle ofBaselineOnly(AnnotatedClusterState baselineState, boolean deferredActivation) {
        return new ClusterStateBundle(baselineState, Collections.emptyMap(), deferredActivation);
    }

    public static ClusterStateBundle ofBaselineOnly(AnnotatedClusterState baselineState) {
        return new ClusterStateBundle(baselineState, Collections.emptyMap());
    }

    public static ClusterStateBundle empty() {
        return ClusterStateBundle.ofBaselineOnly(AnnotatedClusterState.emptyState());
    }

    public AnnotatedClusterState getBaselineAnnotatedState() {
        return this.baselineState;
    }

    public ClusterState getBaselineClusterState() {
        return this.baselineState.getClusterState();
    }

    public Map<String, AnnotatedClusterState> getDerivedBucketSpaceStates() {
        return this.derivedBucketSpaceStates;
    }

    public boolean deferredActivation() {
        return this.deferredActivation;
    }

    public ClusterStateBundle cloneWithMapper(Function<ClusterState, ClusterState> mapper) {
        AnnotatedClusterState clonedBaseline = this.baselineState.cloneWithClusterState(mapper.apply(this.baselineState.getClusterState().clone()));
        Map<String, AnnotatedClusterState> clonedDerived = this.derivedBucketSpaceStates.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((AnnotatedClusterState)e.getValue()).cloneWithClusterState((ClusterState)mapper.apply(((AnnotatedClusterState)e.getValue()).getClusterState().clone()))));
        return new ClusterStateBundle(clonedBaseline, clonedDerived, this.deferredActivation);
    }

    public ClusterStateBundle clonedWithVersionSet(int version) {
        return this.cloneWithMapper(state -> {
            state.setVersion(version);
            return state;
        });
    }

    public boolean similarTo(ClusterStateBundle other) {
        if (!this.baselineState.getClusterState().similarToIgnoringInitProgress(other.baselineState.getClusterState())) {
            return false;
        }
        return this.derivedBucketSpaceStates.entrySet().stream().allMatch(entry -> other.derivedBucketSpaceStates.getOrDefault(entry.getKey(), (AnnotatedClusterState)entry.getValue()).getClusterState().similarToIgnoringInitProgress(((AnnotatedClusterState)entry.getValue()).getClusterState()));
    }

    public int getVersion() {
        return this.baselineState.getClusterState().getVersion();
    }

    public String toString() {
        if (this.derivedBucketSpaceStates.isEmpty()) {
            return String.format("ClusterStateBundle('%s'%s)", this.baselineState, this.deferredActivation ? " (deferred activation)" : "");
        }
        TreeMap<String, AnnotatedClusterState> orderedStates = new TreeMap<String, AnnotatedClusterState>(this.derivedBucketSpaceStates);
        return String.format("ClusterStateBundle('%s', %s%s)", this.baselineState, orderedStates.entrySet().stream().map(e -> String.format("%s '%s'", e.getKey(), e.getValue())).collect(Collectors.joining(", ")), this.deferredActivation ? " (deferred activation)" : "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterStateBundle that = (ClusterStateBundle)o;
        return this.deferredActivation == that.deferredActivation && Objects.equals(this.baselineState, that.baselineState) && Objects.equals(this.derivedBucketSpaceStates, that.derivedBucketSpaceStates);
    }

    public int hashCode() {
        return Objects.hash(this.baselineState, this.derivedBucketSpaceStates, this.deferredActivation);
    }

    public static class Builder {
        private final AnnotatedClusterState baselineState;
        private Map<String, AnnotatedClusterState> explicitDerivedStates;
        private ClusterStateDeriver stateDeriver;
        private Set<String> bucketSpaces;
        private boolean deferredActivation = false;

        public Builder(AnnotatedClusterState baselineState) {
            this.baselineState = baselineState;
        }

        public Builder stateDeriver(ClusterStateDeriver stateDeriver) {
            this.stateDeriver = stateDeriver;
            return this;
        }

        public Builder bucketSpaces(Set<String> bucketSpaces) {
            if (this.explicitDerivedStates != null) {
                throw new IllegalStateException("Cannot set bucket spaces on Builder that already has explicit derived states set");
            }
            this.bucketSpaces = bucketSpaces;
            return this;
        }

        public Builder bucketSpaces(String ... bucketSpaces) {
            return this.bucketSpaces(new TreeSet<String>(Arrays.asList(bucketSpaces)));
        }

        public Builder explicitDerivedStates(Map<String, AnnotatedClusterState> derivedStates) {
            if (this.bucketSpaces != null || this.stateDeriver != null) {
                throw new IllegalStateException("Cannot set explicitly derived states on Builder that already has bucket spaces or deriver set");
            }
            this.explicitDerivedStates = derivedStates;
            return this;
        }

        public Builder deferredActivation(boolean deferred) {
            this.deferredActivation = deferred;
            return this;
        }

        public ClusterStateBundle deriveAndBuild() {
            if ((this.stateDeriver == null || this.bucketSpaces == null || this.bucketSpaces.isEmpty()) && this.explicitDerivedStates == null) {
                return ClusterStateBundle.ofBaselineOnly(this.baselineState, this.deferredActivation);
            }
            Map<String, AnnotatedClusterState> derived = this.explicitDerivedStates != null ? this.explicitDerivedStates : this.bucketSpaces.stream().collect(Collectors.toMap(Function.identity(), s -> this.stateDeriver.derivedFrom(this.baselineState, (String)s)));
            return new ClusterStateBundle(this.baselineState, derived, this.deferredActivation);
        }
    }
}

