/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.document.FixedBucketSpaces;
import com.yahoo.jrt.ListenFailedException;
import com.yahoo.log.LogLevel;
import com.yahoo.vdslib.distribution.ConfiguredNode;
import com.yahoo.vdslib.state.ClusterState;
import com.yahoo.vdslib.state.Node;
import com.yahoo.vdslib.state.NodeState;
import com.yahoo.vdslib.state.State;
import com.yahoo.vespa.clustercontroller.core.AnnotatedClusterState;
import com.yahoo.vespa.clustercontroller.core.ClusterEvent;
import com.yahoo.vespa.clustercontroller.core.ClusterStateBundle;
import com.yahoo.vespa.clustercontroller.core.ClusterStateDeriver;
import com.yahoo.vespa.clustercontroller.core.ClusterStateGenerator;
import com.yahoo.vespa.clustercontroller.core.Communicator;
import com.yahoo.vespa.clustercontroller.core.ContentCluster;
import com.yahoo.vespa.clustercontroller.core.Event;
import com.yahoo.vespa.clustercontroller.core.EventDiffCalculator;
import com.yahoo.vespa.clustercontroller.core.EventLog;
import com.yahoo.vespa.clustercontroller.core.FleetControllerOptions;
import com.yahoo.vespa.clustercontroller.core.MaintenanceTransitionConstraint;
import com.yahoo.vespa.clustercontroller.core.MaintenanceWhenPendingGlobalMerges;
import com.yahoo.vespa.clustercontroller.core.MasterElectionHandler;
import com.yahoo.vespa.clustercontroller.core.MetricUpdater;
import com.yahoo.vespa.clustercontroller.core.NodeEvent;
import com.yahoo.vespa.clustercontroller.core.NodeInfo;
import com.yahoo.vespa.clustercontroller.core.NodeLookup;
import com.yahoo.vespa.clustercontroller.core.NodeStateGatherer;
import com.yahoo.vespa.clustercontroller.core.RealTimer;
import com.yahoo.vespa.clustercontroller.core.RemoteClusterControllerTask;
import com.yahoo.vespa.clustercontroller.core.RemoteClusterControllerTaskScheduler;
import com.yahoo.vespa.clustercontroller.core.StateChangeHandler;
import com.yahoo.vespa.clustercontroller.core.StateVersionTracker;
import com.yahoo.vespa.clustercontroller.core.SystemStateBroadcaster;
import com.yahoo.vespa.clustercontroller.core.Timer;
import com.yahoo.vespa.clustercontroller.core.UpEdgeMaintenanceTransitionConstraint;
import com.yahoo.vespa.clustercontroller.core.VersionDependentTaskCompletion;
import com.yahoo.vespa.clustercontroller.core.database.DatabaseHandler;
import com.yahoo.vespa.clustercontroller.core.database.ZooKeeperDatabaseFactory;
import com.yahoo.vespa.clustercontroller.core.hostinfo.HostInfo;
import com.yahoo.vespa.clustercontroller.core.listeners.NodeAddedOrRemovedListener;
import com.yahoo.vespa.clustercontroller.core.listeners.NodeStateOrHostInfoChangeHandler;
import com.yahoo.vespa.clustercontroller.core.listeners.SystemStateListener;
import com.yahoo.vespa.clustercontroller.core.rpc.RPCCommunicator;
import com.yahoo.vespa.clustercontroller.core.rpc.RpcServer;
import com.yahoo.vespa.clustercontroller.core.rpc.SlobrokClient;
import com.yahoo.vespa.clustercontroller.core.status.ClusterStateRequestHandler;
import com.yahoo.vespa.clustercontroller.core.status.LegacyIndexPageRequestHandler;
import com.yahoo.vespa.clustercontroller.core.status.LegacyNodePageRequestHandler;
import com.yahoo.vespa.clustercontroller.core.status.NodeHealthRequestHandler;
import com.yahoo.vespa.clustercontroller.core.status.RunDataExtractor;
import com.yahoo.vespa.clustercontroller.core.status.statuspage.StatusPageResponse;
import com.yahoo.vespa.clustercontroller.core.status.statuspage.StatusPageServer;
import com.yahoo.vespa.clustercontroller.core.status.statuspage.StatusPageServerInterface;
import com.yahoo.vespa.clustercontroller.utils.util.MetricReporter;
import com.yahoo.vespa.clustercontroller.utils.util.NoMetricReporter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.exception.ExceptionUtils;

public class FleetController
implements NodeStateOrHostInfoChangeHandler,
NodeAddedOrRemovedListener,
SystemStateListener,
Runnable,
RemoteClusterControllerTaskScheduler {
    private static Logger log = Logger.getLogger(FleetController.class.getName());
    private final Timer timer;
    private final Object monitor;
    private final EventLog eventLog;
    private final NodeLookup nodeLookup;
    private final ContentCluster cluster;
    private final Communicator communicator;
    private final NodeStateGatherer stateGatherer;
    private final StateChangeHandler stateChangeHandler;
    private final SystemStateBroadcaster systemStateBroadcaster;
    private final StateVersionTracker stateVersionTracker;
    private final StatusPageServerInterface statusPageServer;
    private final RpcServer rpcServer;
    private final DatabaseHandler database;
    private final MasterElectionHandler masterElectionHandler;
    private Thread runner = null;
    private AtomicBoolean running = new AtomicBoolean(true);
    private FleetControllerOptions options;
    private FleetControllerOptions nextOptions;
    private final List<SystemStateListener> systemStateListeners = new CopyOnWriteArrayList<SystemStateListener>();
    private boolean processingCycle = false;
    private boolean wantedStateChanged = false;
    private long cycleCount = 0L;
    private long nextStateSendTime = 0L;
    private Long controllerThreadId = null;
    private boolean waitingForCycle = false;
    private StatusPageServer.PatternRequestRouter statusRequestRouter = new StatusPageServer.PatternRequestRouter();
    private final List<ClusterStateBundle> newStates = new ArrayList<ClusterStateBundle>();
    private final List<ClusterStateBundle> convergedStates = new ArrayList<ClusterStateBundle>();
    private long configGeneration = -1L;
    private long nextConfigGeneration = -1L;
    private Queue<RemoteClusterControllerTask> remoteTasks = new LinkedList<RemoteClusterControllerTask>();
    private final MetricUpdater metricUpdater;
    private boolean isMaster = false;
    private boolean isStateGatherer = false;
    private long firstAllowedStateBroadcast = Long.MAX_VALUE;
    private long tickStartTime = Long.MAX_VALUE;
    private List<RemoteClusterControllerTask> tasksPendingStateRecompute = new ArrayList<RemoteClusterControllerTask>();
    private Queue<VersionDependentTaskCompletion> taskCompletionQueue = new ArrayDeque<VersionDependentTaskCompletion>();
    private Set<String> configuredBucketSpaces = Collections.emptySet();
    private final RunDataExtractor dataExtractor = new RunDataExtractor(){

        @Override
        public ClusterState getLatestClusterState() {
            return FleetController.this.stateVersionTracker.getVersionedClusterState();
        }

        @Override
        public FleetControllerOptions getOptions() {
            return FleetController.this.options;
        }

        @Override
        public long getConfigGeneration() {
            return FleetController.this.configGeneration;
        }

        @Override
        public ContentCluster getCluster() {
            return FleetController.this.cluster;
        }
    };
    public DatabaseHandler.Context databaseContext = new DatabaseHandler.Context(){

        @Override
        public ContentCluster getCluster() {
            return FleetController.this.cluster;
        }

        @Override
        public FleetController getFleetController() {
            return FleetController.this;
        }

        @Override
        public NodeAddedOrRemovedListener getNodeAddedOrRemovedListener() {
            return FleetController.this;
        }

        @Override
        public NodeStateOrHostInfoChangeHandler getNodeStateUpdateListener() {
            return FleetController.this;
        }
    };

    public FleetController(Timer timer, EventLog eventLog, ContentCluster cluster, NodeStateGatherer nodeStateGatherer, Communicator communicator, StatusPageServerInterface statusPage, RpcServer server, NodeLookup nodeLookup, DatabaseHandler database, StateChangeHandler stateChangeHandler, SystemStateBroadcaster systemStateBroadcaster, MasterElectionHandler masterElectionHandler, MetricUpdater metricUpdater, FleetControllerOptions options) throws Exception {
        log.info("Starting up cluster controller " + options.fleetControllerIndex + " for cluster " + cluster.getName());
        this.timer = timer;
        this.monitor = timer;
        this.eventLog = eventLog;
        this.options = options;
        this.nodeLookup = nodeLookup;
        this.cluster = cluster;
        this.communicator = communicator;
        this.database = database;
        this.stateGatherer = nodeStateGatherer;
        this.stateChangeHandler = stateChangeHandler;
        this.systemStateBroadcaster = systemStateBroadcaster;
        this.stateVersionTracker = new StateVersionTracker(options.minMergeCompletionRatio);
        this.metricUpdater = metricUpdater;
        this.statusPageServer = statusPage;
        this.rpcServer = server;
        this.masterElectionHandler = masterElectionHandler;
        this.statusRequestRouter.addHandler("^/node=([a-z]+)\\.(\\d+)$", (StatusPageServer.RequestHandler)new LegacyNodePageRequestHandler(timer, eventLog, cluster));
        this.statusRequestRouter.addHandler("^/state.*", (StatusPageServer.RequestHandler)new NodeHealthRequestHandler(this.dataExtractor));
        this.statusRequestRouter.addHandler("^/clusterstate", (StatusPageServer.RequestHandler)new ClusterStateRequestHandler(this.stateVersionTracker));
        this.statusRequestRouter.addHandler("^/$", (StatusPageServer.RequestHandler)new LegacyIndexPageRequestHandler(timer, options.showLocalSystemStatesInEventLog, cluster, masterElectionHandler, this.stateVersionTracker, eventLog, timer.getCurrentTimeInMillis(), this.dataExtractor));
        this.propagateOptions();
    }

    public static FleetController createForContainer(FleetControllerOptions options, StatusPageServerInterface statusPageServer, MetricReporter metricReporter) throws Exception {
        RealTimer timer = new RealTimer();
        return FleetController.create(options, timer, statusPageServer, null, metricReporter);
    }

    public static FleetController createForStandAlone(FleetControllerOptions options) throws Exception {
        RealTimer timer = new RealTimer();
        RpcServer rpcServer = new RpcServer(timer, timer, options.clusterName, options.fleetControllerIndex, options.slobrokBackOffPolicy);
        StatusPageServer statusPageServer = new StatusPageServer(timer, timer, options.httpPort);
        return FleetController.create(options, timer, statusPageServer, rpcServer, (MetricReporter)new NoMetricReporter());
    }

    private static FleetController create(FleetControllerOptions options, Timer timer, StatusPageServerInterface statusPageServer, RpcServer rpcServer, MetricReporter metricReporter) throws Exception {
        MetricUpdater metricUpdater = new MetricUpdater(metricReporter, options.fleetControllerIndex);
        EventLog log = new EventLog(timer, metricUpdater);
        ContentCluster cluster = new ContentCluster(options.clusterName, options.nodes, options.storageDistribution, options.minStorageNodesUp, options.minRatioOfStorageNodesUp);
        NodeStateGatherer stateGatherer = new NodeStateGatherer(timer, timer, log);
        RPCCommunicator communicator = new RPCCommunicator(RPCCommunicator.createRealSupervisor(), timer, options.fleetControllerIndex, options.nodeStateRequestTimeoutMS, options.nodeStateRequestTimeoutEarliestPercentage, options.nodeStateRequestTimeoutLatestPercentage, options.nodeStateRequestRoundTripTimeMaxSeconds);
        DatabaseHandler database = new DatabaseHandler(new ZooKeeperDatabaseFactory(), timer, options.zooKeeperServerAddress, options.fleetControllerIndex, timer);
        SlobrokClient lookUp = new SlobrokClient(timer);
        StateChangeHandler stateGenerator = new StateChangeHandler(timer, log, metricUpdater);
        SystemStateBroadcaster stateBroadcaster = new SystemStateBroadcaster(timer, timer);
        MasterElectionHandler masterElectionHandler = new MasterElectionHandler(options.fleetControllerIndex, options.fleetControllerCount, timer, timer);
        FleetController controller = new FleetController(timer, log, cluster, stateGatherer, communicator, statusPageServer, rpcServer, lookUp, database, stateGenerator, stateBroadcaster, masterElectionHandler, metricUpdater, options);
        controller.start();
        return controller;
    }

    public void start() {
        this.runner = new Thread(this);
        this.runner.start();
    }

    public Object getMonitor() {
        return this.monitor;
    }

    public boolean isRunning() {
        return this.running.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMaster() {
        Object object = this.monitor;
        synchronized (object) {
            return this.masterElectionHandler.isMaster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterState getClusterState() {
        Object object = this.monitor;
        synchronized (object) {
            return this.systemStateBroadcaster.getClusterState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterStateBundle getClusterStateBundle() {
        Object object = this.monitor;
        synchronized (object) {
            return this.systemStateBroadcaster.getClusterStateBundle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void schedule(RemoteClusterControllerTask task) {
        Object object = this.monitor;
        synchronized (object) {
            log.fine("Scheduled remote task " + task.getClass().getName() + " for execution");
            this.remoteTasks.add(task);
        }
    }

    public void addSystemStateListener(SystemStateListener listener) {
        this.systemStateListeners.add(listener);
        ClusterState state = this.getSystemState();
        if (state == null) {
            throw new NullPointerException("Cluster state should never be null at this point");
        }
        listener.handleNewPublishedState(ClusterStateBundle.ofBaselineOnly(AnnotatedClusterState.withoutAnnotations(state)));
        ClusterStateBundle convergedState = this.systemStateBroadcaster.getLastClusterStateBundleConverged();
        if (convergedState != null) {
            listener.handleStateConvergedInCluster(convergedState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FleetControllerOptions getOptions() {
        Object object = this.monitor;
        synchronized (object) {
            return this.options.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeState getReportedNodeState(Node n) {
        Object object = this.monitor;
        synchronized (object) {
            NodeInfo node = this.cluster.getNodeInfo(n);
            if (node == null) {
                throw new IllegalStateException("Did not find node " + n + " in cluster " + this.cluster);
            }
            return node.getReportedState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeState getWantedNodeState(Node n) {
        Object object = this.monitor;
        synchronized (object) {
            return this.cluster.getNodeInfo(n).getWantedState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterState getSystemState() {
        Object object = this.monitor;
        synchronized (object) {
            return this.stateVersionTracker.getVersionedClusterState();
        }
    }

    public int getHttpPort() {
        return this.statusPageServer.getPort();
    }

    public int getRpcPort() {
        return this.rpcServer.getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws InterruptedException, IOException {
        if (this.runner != null && this.isRunning()) {
            log.log(LogLevel.INFO, "Joining event thread.");
            this.running.set(false);
            Object object = this.monitor;
            synchronized (object) {
                this.monitor.notifyAll();
            }
            this.runner.join();
        }
        log.log(LogLevel.INFO, "Fleetcontroller done shutting down event thread.");
        this.controllerThreadId = Thread.currentThread().getId();
        this.database.shutdown(this);
        if (this.statusPageServer != null) {
            this.statusPageServer.shutdown();
        }
        if (this.rpcServer != null) {
            this.rpcServer.shutdown();
        }
        this.communicator.shutdown();
        this.nodeLookup.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOptions(FleetControllerOptions options, long configGeneration) {
        Object object = this.monitor;
        synchronized (object) {
            assert (this.options.fleetControllerIndex == options.fleetControllerIndex);
            log.log(LogLevel.INFO, "Fleetcontroller " + options.fleetControllerIndex + " has new options");
            this.nextOptions = options.clone();
            this.nextConfigGeneration = configGeneration;
            this.monitor.notifyAll();
        }
    }

    private void verifyInControllerThread() {
        if (this.controllerThreadId != null && this.controllerThreadId.longValue() != Thread.currentThread().getId()) {
            throw new IllegalStateException("Function called from non-controller thread. Shouldn't happen.");
        }
    }

    private ClusterState latestCandidateClusterState() {
        return this.stateVersionTracker.getLatestCandidateState().getClusterState();
    }

    @Override
    public void handleNewNodeState(NodeInfo node, NodeState newState) {
        this.verifyInControllerThread();
        this.stateChangeHandler.handleNewReportedNodeState(this.latestCandidateClusterState(), node, newState, this);
    }

    @Override
    public void handleNewWantedNodeState(NodeInfo node, NodeState newState) {
        this.verifyInControllerThread();
        this.wantedStateChanged = true;
        this.stateChangeHandler.proposeNewNodeState(this.stateVersionTracker.getVersionedClusterState(), node, newState);
    }

    @Override
    public void handleUpdatedHostInfo(NodeInfo nodeInfo, HostInfo newHostInfo) {
        this.verifyInControllerThread();
        this.stateVersionTracker.handleUpdatedHostInfo(nodeInfo, newHostInfo);
    }

    @Override
    public void handleNewNode(NodeInfo node) {
        this.verifyInControllerThread();
        this.stateChangeHandler.handleNewNode(node);
    }

    @Override
    public void handleMissingNode(NodeInfo node) {
        this.verifyInControllerThread();
        this.stateChangeHandler.handleMissingNode(this.stateVersionTracker.getVersionedClusterState(), node, this);
    }

    @Override
    public void handleNewRpcAddress(NodeInfo node) {
        this.verifyInControllerThread();
        this.stateChangeHandler.handleNewRpcAddress(node);
    }

    @Override
    public void handleReturnedRpcAddress(NodeInfo node) {
        this.verifyInControllerThread();
        this.stateChangeHandler.handleReturnedRpcAddress(node);
    }

    @Override
    public void handleNewPublishedState(ClusterStateBundle stateBundle) {
        this.verifyInControllerThread();
        ClusterState baselineState = stateBundle.getBaselineClusterState();
        this.newStates.add(stateBundle);
        this.metricUpdater.updateClusterStateMetrics(this.cluster, baselineState);
        this.systemStateBroadcaster.handleNewClusterStates(stateBundle);
        if (this.masterElectionHandler.isMaster()) {
            this.storeClusterStateMetaDataToZooKeeper(stateBundle);
        }
    }

    private void storeClusterStateMetaDataToZooKeeper(ClusterStateBundle stateBundle) {
        try {
            this.database.saveLatestSystemStateVersion(this.databaseContext, stateBundle.getVersion());
            this.database.saveLatestClusterStateBundle(this.databaseContext, stateBundle);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("ZooKeeper write interrupted", e);
        }
    }

    public void handleFleetData(Map<Integer, Integer> data) {
        this.verifyInControllerThread();
        log.log((Level)LogLevel.SPAM, "Sending fleet data event on to master election handler");
        this.metricUpdater.updateMasterElectionMetrics(data);
        this.masterElectionHandler.handleFleetData(data);
    }

    public void lostDatabaseConnection() {
        this.verifyInControllerThread();
        this.masterElectionHandler.lostDatabaseConnection();
    }

    private void failAllVersionDependentTasks() {
        this.tasksPendingStateRecompute.forEach(task -> {
            task.handleFailure(RemoteClusterControllerTask.FailureCondition.LEADERSHIP_LOST);
            task.notifyCompleted();
        });
        this.tasksPendingStateRecompute.clear();
        this.taskCompletionQueue.forEach(task -> {
            task.getTask().handleFailure(RemoteClusterControllerTask.FailureCondition.LEADERSHIP_LOST);
            task.getTask().notifyCompleted();
        });
        this.taskCompletionQueue.clear();
    }

    public void handleAllDistributorsInSync(DatabaseHandler database, DatabaseHandler.Context context) throws InterruptedException {
        HashSet<ConfiguredNode> nodes = new HashSet<ConfiguredNode>(this.cluster.clusterInfo().getConfiguredNodes().values());
        ClusterStateBundle currentBundle = this.stateVersionTracker.getVersionedClusterStateBundle();
        log.fine(() -> String.format("All distributors have ACKed cluster state version %d", currentBundle.getVersion()));
        this.stateChangeHandler.handleAllDistributorsInSync(currentBundle.getBaselineClusterState(), nodes, database, context);
        this.convergedStates.add(currentBundle);
    }

    private boolean changesConfiguredNodeSet(Collection<ConfiguredNode> newNodes) {
        if (newNodes.size() != this.cluster.getConfiguredNodes().size()) {
            return true;
        }
        if (!this.cluster.getConfiguredNodes().values().containsAll(newNodes)) {
            return true;
        }
        for (ConfiguredNode node : newNodes) {
            if (node.retired() == this.cluster.getConfiguredNodes().get(node.index()).retired()) continue;
            return true;
        }
        return false;
    }

    private void propagateOptions() throws IOException, ListenFailedException {
        this.verifyInControllerThread();
        if (this.changesConfiguredNodeSet(this.options.nodes)) {
            this.cluster.setSlobrokGenerationCount(0);
        }
        this.configuredBucketSpaces = Collections.unmodifiableSet(Stream.of(FixedBucketSpaces.defaultSpace(), FixedBucketSpaces.globalSpace()).collect(Collectors.toSet()));
        this.stateVersionTracker.setMinMergeCompletionRatio(this.options.minMergeCompletionRatio);
        this.communicator.propagateOptions(this.options);
        if (this.nodeLookup instanceof SlobrokClient) {
            ((SlobrokClient)this.nodeLookup).setSlobrokConnectionSpecs(this.options.slobrokConnectionSpecs);
        }
        this.eventLog.setMaxSize(this.options.eventLogMaxSize, this.options.eventNodeLogMaxSize);
        this.cluster.setPollingFrequency(this.options.statePollingFrequency);
        this.cluster.setDistribution(this.options.storageDistribution);
        this.cluster.setNodes(this.options.nodes);
        this.cluster.setMinRatioOfStorageNodesUp(this.options.minRatioOfStorageNodesUp);
        this.cluster.setMinStorageNodesUp(this.options.minStorageNodesUp);
        this.database.setZooKeeperAddress(this.options.zooKeeperServerAddress);
        this.database.setZooKeeperSessionTimeout(this.options.zooKeeperSessionTimeout);
        this.stateGatherer.setMaxSlobrokDisconnectGracePeriod(this.options.maxSlobrokDisconnectGracePeriod);
        this.stateGatherer.setNodeStateRequestTimeout(this.options.nodeStateRequestTimeoutMS);
        this.stateChangeHandler.reconfigureFromOptions(this.options);
        this.stateChangeHandler.setStateChangedFlag();
        this.masterElectionHandler.setFleetControllerCount(this.options.fleetControllerCount);
        this.masterElectionHandler.setMasterZooKeeperCooldownPeriod(this.options.masterZooKeeperCooldownPeriod);
        if (this.rpcServer != null) {
            this.rpcServer.setMasterElectionHandler(this.masterElectionHandler);
            try {
                this.rpcServer.setSlobrokConnectionSpecs(this.options.slobrokConnectionSpecs, this.options.rpcPort);
            }
            catch (ListenFailedException e) {
                log.log(LogLevel.WARNING, "Failed to bind RPC server to port " + this.options.rpcPort + ". This may be natural if cluster has altered the services running on this node: " + e.getMessage());
            }
            catch (Exception e) {
                log.log(LogLevel.WARNING, "Failed to initialize RPC server socket: " + e.getMessage());
            }
        }
        if (this.statusPageServer != null) {
            try {
                this.statusPageServer.setPort(this.options.httpPort);
            }
            catch (Exception e) {
                log.log(LogLevel.WARNING, "Failed to initialize status server socket. This may be natural if cluster has altered the services running on this node: " + e.getMessage());
            }
        }
        long currentTime = this.timer.getCurrentTimeInMillis();
        this.nextStateSendTime = Math.min(currentTime + (long)this.options.minTimeBetweenNewSystemStates, this.nextStateSendTime);
        this.configGeneration = this.nextConfigGeneration;
        this.nextConfigGeneration = -1L;
    }

    public StatusPageResponse fetchStatusPage(StatusPageServer.HttpRequest httpRequest) {
        String message;
        StatusPageResponse.ResponseCode responseCode;
        this.verifyInControllerThread();
        String hiddenMessage = "";
        try {
            StatusPageServer.RequestHandler handler = this.statusRequestRouter.resolveHandler(httpRequest);
            if (handler == null) {
                throw new FileNotFoundException("No handler found for request: " + httpRequest.getPath());
            }
            return handler.handle(httpRequest);
        }
        catch (FileNotFoundException e) {
            responseCode = StatusPageResponse.ResponseCode.NOT_FOUND;
            message = e.getMessage();
        }
        catch (Exception e) {
            responseCode = StatusPageResponse.ResponseCode.INTERNAL_SERVER_ERROR;
            message = "Internal Server Error";
            hiddenMessage = ExceptionUtils.getStackTrace((Throwable)e);
            log.log((Level)LogLevel.DEBUG, "Unknown exception thrown for request " + httpRequest.getRequest() + ": " + hiddenMessage);
        }
        TimeZone tz = TimeZone.getTimeZone("UTC");
        long currentTime = this.timer.getCurrentTimeInMillis();
        StatusPageResponse response = new StatusPageResponse();
        StringBuilder content = new StringBuilder();
        response.setContentType("text/html");
        response.setResponseCode(responseCode);
        content.append("<!-- Answer to request " + httpRequest.getRequest() + " -->\n");
        content.append("<p>UTC time when creating this page: ").append(RealTimer.printDateNoMilliSeconds(currentTime, tz)).append("</p>");
        response.writeHtmlHeader(content, message);
        response.writeHtmlFooter(content, hiddenMessage);
        response.writeContent(content.toString());
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() throws Exception {
        Object object = this.monitor;
        synchronized (object) {
            boolean didWork = this.database.doNextZooKeeperTask(this.databaseContext);
            didWork |= this.updateMasterElectionState();
            didWork |= this.handleLeadershipEdgeTransitions();
            this.stateChangeHandler.setMaster(this.isMaster);
            if (!this.isRunning()) {
                return;
            }
            didWork |= this.stateGatherer.processResponses(this);
            if (!this.isRunning()) {
                return;
            }
            if (this.masterElectionHandler.isAmongNthFirst(this.options.stateGatherCount)) {
                didWork |= this.resyncLocallyCachedState();
            } else {
                this.stepDownAsStateGatherer();
            }
            if (!this.isRunning()) {
                return;
            }
            didWork |= this.systemStateBroadcaster.processResponses();
            if (!this.isRunning()) {
                return;
            }
            if (this.masterElectionHandler.isMaster()) {
                didWork |= this.broadcastClusterStateToEligibleNodes();
                this.systemStateBroadcaster.checkIfClusterStateIsAckedByAllDistributors(this.database, this.databaseContext, this);
            }
            if (!this.isRunning()) {
                return;
            }
            didWork |= this.processAnyPendingStatusPageRequest();
            if (!this.isRunning()) {
                return;
            }
            if (this.rpcServer != null) {
                didWork |= this.rpcServer.handleRpcRequests(this.cluster, this.consolidatedClusterState(), this, this);
            }
            if (!this.isRunning()) {
                return;
            }
            didWork |= this.processNextQueuedRemoteTask();
            didWork |= this.completeSatisfiedVersionDependentTasks();
            this.processingCycle = false;
            ++this.cycleCount;
            long tickStopTime = this.timer.getCurrentTimeInMillis();
            if (tickStopTime >= this.tickStartTime) {
                this.metricUpdater.addTickTime(tickStopTime - this.tickStartTime, didWork);
            }
            if (!didWork && !this.waitingForCycle) {
                this.monitor.wait(this.options.cycleWaitTime);
            }
            if (!this.isRunning()) {
                return;
            }
            this.tickStartTime = this.timer.getCurrentTimeInMillis();
            this.processingCycle = true;
            if (this.nextOptions != null) {
                this.switchToNewConfig();
            }
        }
        if (this.isRunning()) {
            this.propagateNewStatesToListeners();
        }
    }

    private boolean updateMasterElectionState() throws InterruptedException {
        try {
            return this.masterElectionHandler.watchMasterElection(this.database, this.databaseContext);
        }
        catch (InterruptedException e) {
            throw (InterruptedException)new InterruptedException("Interrupted").initCause(e);
        }
        catch (Exception e) {
            log.log(LogLevel.WARNING, "Failed to watch master election: " + e.toString());
            return false;
        }
    }

    private void stepDownAsStateGatherer() {
        if (this.isStateGatherer) {
            this.cluster.clearStates();
            this.eventLog.add(new ClusterEvent(ClusterEvent.Type.MASTER_ELECTION, "This node is no longer a node state gatherer.", this.timer.getCurrentTimeInMillis()));
        }
        this.isStateGatherer = false;
    }

    private void switchToNewConfig() {
        this.options = this.nextOptions;
        this.nextOptions = null;
        try {
            this.propagateOptions();
        }
        catch (Exception e) {
            log.log((Level)LogLevel.ERROR, "Failed to handle new fleet controller config", e);
        }
    }

    private boolean processAnyPendingStatusPageRequest() {
        StatusPageServer.HttpRequest statusRequest;
        if (this.statusPageServer != null && (statusRequest = this.statusPageServer.getCurrentHttpRequest()) != null) {
            this.statusPageServer.answerCurrentStatusRequest(this.fetchStatusPage(statusRequest));
            return true;
        }
        return false;
    }

    private boolean broadcastClusterStateToEligibleNodes() {
        if (this.database.hasPendingClusterStateMetaDataStore()) {
            log.log((Level)LogLevel.DEBUG, "Can't publish current cluster state as it has one or more pending ZooKeeper stores");
            return false;
        }
        boolean sentAny = false;
        long currentTime = this.timer.getCurrentTimeInMillis();
        if ((currentTime >= this.firstAllowedStateBroadcast || this.cluster.allStatesReported()) && currentTime >= this.nextStateSendTime) {
            if (currentTime < this.firstAllowedStateBroadcast) {
                log.log((Level)LogLevel.DEBUG, "Not set to broadcast states just yet, but as we have gotten info from all nodes we can do so safely.");
                this.firstAllowedStateBroadcast = currentTime;
            }
            if (sentAny = this.systemStateBroadcaster.broadcastNewStateBundleIfRequired(this.databaseContext, this.communicator)) {
                this.nextStateSendTime = currentTime + (long)this.options.minTimeBetweenNewSystemStates;
            }
        }
        return sentAny |= this.systemStateBroadcaster.broadcastStateActivationsIfRequired(this.databaseContext, this.communicator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void propagateNewStatesToListeners() {
        List<SystemStateListener> list;
        if (!this.newStates.isEmpty()) {
            list = this.systemStateListeners;
            synchronized (list) {
                for (ClusterStateBundle stateBundle : this.newStates) {
                    for (SystemStateListener listener : this.systemStateListeners) {
                        listener.handleNewPublishedState(stateBundle);
                    }
                }
                this.newStates.clear();
            }
        }
        if (!this.convergedStates.isEmpty()) {
            list = this.systemStateListeners;
            synchronized (list) {
                for (ClusterStateBundle stateBundle : this.convergedStates) {
                    for (SystemStateListener listener : this.systemStateListeners) {
                        listener.handleStateConvergedInCluster(stateBundle);
                    }
                }
                this.convergedStates.clear();
            }
        }
    }

    private boolean processNextQueuedRemoteTask() {
        if (!this.remoteTasks.isEmpty()) {
            RemoteClusterControllerTask.Context context = this.createRemoteTaskProcessingContext();
            RemoteClusterControllerTask task = this.remoteTasks.poll();
            log.finest(() -> String.format("Processing remote task of type '%s'", task.getClass().getName()));
            task.doRemoteFleetControllerTask(context);
            if (this.taskMayBeCompletedImmediately(task)) {
                log.finest(() -> String.format("Done processing remote task of type '%s'", task.getClass().getName()));
                task.notifyCompleted();
            } else {
                log.finest(() -> String.format("Remote task of type '%s' queued until state recomputation", task.getClass().getName()));
                this.tasksPendingStateRecompute.add(task);
            }
            return true;
        }
        return false;
    }

    private boolean taskMayBeCompletedImmediately(RemoteClusterControllerTask task) {
        return !task.hasVersionAckDependency() || task.isFailed() || !this.masterElectionHandler.isMaster();
    }

    private RemoteClusterControllerTask.Context createRemoteTaskProcessingContext() {
        RemoteClusterControllerTask.Context context = new RemoteClusterControllerTask.Context();
        context.cluster = this.cluster;
        context.currentConsolidatedState = this.consolidatedClusterState();
        context.publishedClusterStateBundle = this.stateVersionTracker.getVersionedClusterStateBundle();
        context.masterInfo = this.masterElectionHandler;
        context.nodeStateOrHostInfoChangeHandler = this;
        context.nodeAddedOrRemovedListener = this;
        return context;
    }

    private boolean completeSatisfiedVersionDependentTasks() {
        int publishedVersion = this.systemStateBroadcaster.lastClusterStateVersionInSync();
        long queueSizeBefore = this.taskCompletionQueue.size();
        long now = this.timer.getCurrentTimeInMillis();
        while (!this.taskCompletionQueue.isEmpty()) {
            VersionDependentTaskCompletion taskCompletion = this.taskCompletionQueue.peek();
            if ((long)publishedVersion >= taskCompletion.getMinimumVersion()) {
                log.fine(() -> String.format("Deferred task of type '%s' has minimum version %d, published is %d; completing", taskCompletion.getTask().getClass().getName(), taskCompletion.getMinimumVersion(), publishedVersion));
                taskCompletion.getTask().notifyCompleted();
                this.taskCompletionQueue.remove();
                continue;
            }
            if (taskCompletion.getDeadlineTimePointMs() > now) break;
            log.log(LogLevel.WARNING, () -> String.format("Deferred task of type '%s' has exceeded wait deadline; completing with failure", taskCompletion.getTask().getClass().getName()));
            taskCompletion.getTask().handleFailure(RemoteClusterControllerTask.FailureCondition.DEADLINE_EXCEEDED);
            taskCompletion.getTask().notifyCompleted();
            this.taskCompletionQueue.remove();
        }
        return (long)this.taskCompletionQueue.size() != queueSizeBefore;
    }

    ClusterState consolidatedClusterState() {
        ClusterState publishedState = this.stateVersionTracker.getVersionedClusterState();
        if (publishedState.getClusterState() == State.UP) {
            return publishedState;
        }
        ClusterState current = this.stateVersionTracker.getLatestCandidateState().getClusterState().clone();
        current.setVersion(publishedState.getVersion());
        return current;
    }

    private boolean resyncLocallyCachedState() throws InterruptedException {
        boolean didWork = false;
        if (!this.isMaster && this.cycleCount % 100L == 0L) {
            didWork = this.database.loadWantedStates(this.databaseContext);
            didWork |= this.database.loadStartTimestamps(this.cluster);
        }
        didWork |= this.nodeLookup.updateCluster(this.cluster, this);
        didWork |= this.stateGatherer.sendMessages(this.cluster, this.communicator, this);
        didWork |= this.stateChangeHandler.watchTimers(this.cluster, this.stateVersionTracker.getLatestCandidateState().getClusterState(), this);
        didWork |= this.recomputeClusterStateIfRequired();
        if (!this.isStateGatherer && !this.isMaster) {
            this.eventLog.add(new ClusterEvent(ClusterEvent.Type.MASTER_ELECTION, "This node just became node state gatherer as we are fleetcontroller master candidate.", this.timer.getCurrentTimeInMillis()));
            this.stateVersionTracker.setVersionRetrievedFromZooKeeper(this.database.getLatestSystemStateVersion());
            this.stateChangeHandler.setStateChangedFlag();
        }
        this.isStateGatherer = true;
        return didWork;
    }

    private void invokeCandidateStateListeners(ClusterStateBundle candidateBundle) {
        this.systemStateListeners.forEach(listener -> listener.handleNewCandidateState(candidateBundle));
    }

    private boolean hasPassedFirstStateBroadcastTimePoint(long timeNowMs) {
        return timeNowMs >= this.firstAllowedStateBroadcast || this.cluster.allStatesReported();
    }

    private boolean recomputeClusterStateIfRequired() {
        boolean stateWasChanged = false;
        if (this.mustRecomputeCandidateClusterState()) {
            this.stateChangeHandler.unsetStateChangedFlag();
            AnnotatedClusterState candidate = this.computeCurrentAnnotatedState();
            ClusterStateBundle candidateBundle = ClusterStateBundle.builder(candidate).bucketSpaces(this.configuredBucketSpaces).stateDeriver(this.createBucketSpaceStateDeriver()).deferredActivation(this.options.enableTwoPhaseClusterStateActivation).deriveAndBuild();
            this.stateVersionTracker.updateLatestCandidateStateBundle(candidateBundle);
            this.invokeCandidateStateListeners(candidateBundle);
            long timeNowMs = this.timer.getCurrentTimeInMillis();
            if (this.hasPassedFirstStateBroadcastTimePoint(timeNowMs) && (this.stateVersionTracker.candidateChangedEnoughFromCurrentToWarrantPublish() || this.stateVersionTracker.hasReceivedNewVersionFromZooKeeper())) {
                ClusterStateBundle before = this.stateVersionTracker.getVersionedClusterStateBundle();
                this.stateVersionTracker.promoteCandidateToVersionedState(timeNowMs);
                this.emitEventsForAlteredStateEdges(before, this.stateVersionTracker.getVersionedClusterStateBundle(), timeNowMs);
                this.handleNewPublishedState(this.stateVersionTracker.getVersionedClusterStateBundle());
                stateWasChanged = true;
            }
        }
        this.scheduleVersionDependentTasksForFutureCompletion(this.stateVersionTracker.getCurrentVersion());
        return stateWasChanged;
    }

    private ClusterStateDeriver createBucketSpaceStateDeriver() {
        if (this.options.clusterHasGlobalDocumentTypes) {
            return new MaintenanceWhenPendingGlobalMerges(this.stateVersionTracker.createMergePendingChecker(), this.createDefaultSpaceMaintenanceTransitionConstraint());
        }
        return FleetController.createIdentityClonedBucketSpaceStateDeriver();
    }

    private static ClusterStateDeriver createIdentityClonedBucketSpaceStateDeriver() {
        return (state, space) -> state.clone();
    }

    private MaintenanceTransitionConstraint createDefaultSpaceMaintenanceTransitionConstraint() {
        AnnotatedClusterState currentDefaultSpaceState = this.stateVersionTracker.getVersionedClusterStateBundle().getDerivedBucketSpaceStates().getOrDefault(FixedBucketSpaces.defaultSpace(), AnnotatedClusterState.emptyState());
        return UpEdgeMaintenanceTransitionConstraint.forPreviouslyPublishedState(currentDefaultSpaceState.getClusterState());
    }

    private void scheduleVersionDependentTasksForFutureCompletion(int completeAtVersion) {
        long maxDeadlineTimePointMs = this.timer.getCurrentTimeInMillis() + this.options.getMaxDeferredTaskVersionWaitTime().toMillis();
        for (RemoteClusterControllerTask task : this.tasksPendingStateRecompute) {
            log.finest(() -> String.format("Adding task of type '%s' to be completed at version %d", task.getClass().getName(), completeAtVersion));
            this.taskCompletionQueue.add(new VersionDependentTaskCompletion(completeAtVersion, task, maxDeadlineTimePointMs));
        }
        this.tasksPendingStateRecompute.clear();
    }

    private AnnotatedClusterState computeCurrentAnnotatedState() {
        ClusterStateGenerator.Params params = ClusterStateGenerator.Params.fromOptions(this.options);
        params.currentTimeInMilllis(this.timer.getCurrentTimeInMillis()).cluster(this.cluster).lowestObservedDistributionBitCount(this.stateVersionTracker.getLowestObservedDistributionBits());
        return ClusterStateGenerator.generatedStateFrom(params);
    }

    private void emitEventsForAlteredStateEdges(ClusterStateBundle fromState, ClusterStateBundle toState, long timeNowMs) {
        List<Event> deltaEvents = EventDiffCalculator.computeEventDiff(EventDiffCalculator.params().cluster(this.cluster).fromState(fromState).toState(toState).currentTimeMs(timeNowMs).maxMaintenanceGracePeriodTimeMs(this.options.storageNodeMaxTransitionTimeMs()));
        for (Event event : deltaEvents) {
            this.eventLog.add(event, this.isMaster);
        }
        this.emitStateAppliedEvents(timeNowMs, fromState.getBaselineClusterState(), toState.getBaselineClusterState());
    }

    private void emitStateAppliedEvents(long timeNowMs, ClusterState fromClusterState, ClusterState toClusterState) {
        this.eventLog.add(new ClusterEvent(ClusterEvent.Type.SYSTEMSTATE, "New cluster state version " + toClusterState.getVersion() + ". Change from last: " + fromClusterState.getTextualDifference(toClusterState), timeNowMs), this.isMaster);
        if (toClusterState.getDistributionBitCount() != fromClusterState.getDistributionBitCount()) {
            this.eventLog.add(new ClusterEvent(ClusterEvent.Type.SYSTEMSTATE, "Altering distribution bits in system from " + fromClusterState.getDistributionBitCount() + " to " + toClusterState.getDistributionBitCount(), timeNowMs), this.isMaster);
        }
    }

    private boolean atFirstClusterStateSendTimeEdge() {
        if (!this.isMaster || this.systemStateBroadcaster.hasBroadcastedClusterStateBundle()) {
            return false;
        }
        return this.hasPassedFirstStateBroadcastTimePoint(this.timer.getCurrentTimeInMillis());
    }

    private boolean mustRecomputeCandidateClusterState() {
        return this.stateChangeHandler.stateMayHaveChanged() || this.stateVersionTracker.bucketSpaceMergeCompletionStateHasChanged() || this.atFirstClusterStateSendTimeEdge();
    }

    private boolean handleLeadershipEdgeTransitions() throws InterruptedException {
        boolean didWork = false;
        if (this.masterElectionHandler.isMaster()) {
            if (!this.isMaster) {
                this.metricUpdater.becameMaster();
                this.stateChangeHandler.setStateChangedFlag();
                this.systemStateBroadcaster.resetBroadcastedClusterStateBundle();
                this.stateVersionTracker.setVersionRetrievedFromZooKeeper(this.database.getLatestSystemStateVersion());
                ClusterStateBundle previousBundle = this.database.getLatestClusterStateBundle();
                this.database.loadStartTimestamps(this.cluster);
                this.database.loadWantedStates(this.databaseContext);
                log.info(() -> String.format("Loaded previous cluster state bundle from ZooKeeper: %s", previousBundle));
                this.stateVersionTracker.setClusterStateBundleRetrievedFromZooKeeper(previousBundle);
                this.eventLog.add(new ClusterEvent(ClusterEvent.Type.MASTER_ELECTION, "This node just became fleetcontroller master. Bumped version to " + this.stateVersionTracker.getCurrentVersion() + " to be in line.", this.timer.getCurrentTimeInMillis()));
                long currentTime = this.timer.getCurrentTimeInMillis();
                this.firstAllowedStateBroadcast = currentTime + this.options.minTimeBeforeFirstSystemStateBroadcast;
                log.log((Level)LogLevel.DEBUG, "At time " + currentTime + " we set first system state broadcast time to be " + this.options.minTimeBeforeFirstSystemStateBroadcast + " ms after at time " + this.firstAllowedStateBroadcast + ".");
                didWork = true;
            }
            this.isMaster = true;
            if (this.wantedStateChanged) {
                this.database.saveWantedStates(this.databaseContext);
                this.wantedStateChanged = false;
            }
        } else {
            if (this.isMaster) {
                this.eventLog.add(new ClusterEvent(ClusterEvent.Type.MASTER_ELECTION, "This node is no longer fleetcontroller master.", this.timer.getCurrentTimeInMillis()));
                this.firstAllowedStateBroadcast = Long.MAX_VALUE;
                this.metricUpdater.noLongerMaster();
                this.failAllVersionDependentTasks();
            }
            this.wantedStateChanged = false;
            this.isMaster = false;
        }
        return didWork;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.controllerThreadId = Thread.currentThread().getId();
        try {
            this.processingCycle = true;
            while (this.isRunning()) {
                this.tick();
            }
        }
        catch (InterruptedException e) {
            log.log((Level)LogLevel.DEBUG, "Event thread stopped by interrupt exception: " + e);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.log((Level)LogLevel.ERROR, "Fatal error killed fleet controller", t);
            Object object = this.monitor;
            synchronized (object) {
                this.running.set(false);
            }
            System.exit(1);
        }
        finally {
            this.running.set(false);
            this.failAllVersionDependentTasks();
            Object e = this.monitor;
            synchronized (e) {
                this.monitor.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForCompleteCycle(long timeoutMS) {
        long endTime = System.currentTimeMillis() + timeoutMS;
        Object object = this.monitor;
        synchronized (object) {
            long wantedCycle = this.cycleCount + (long)(this.processingCycle ? 2 : 1);
            this.waitingForCycle = true;
            try {
                while (this.cycleCount < wantedCycle) {
                    if (System.currentTimeMillis() > endTime) {
                        throw new IllegalStateException("Timed out waiting for cycle to complete. Not completed after " + timeoutMS + " ms.");
                    }
                    if (!this.isRunning()) {
                        throw new IllegalStateException("Fleetcontroller not running. Will never complete cycles");
                    }
                    try {
                        this.monitor.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            finally {
                this.waitingForCycle = false;
            }
        }
    }

    public void waitForNodesHavingSystemStateVersionEqualToOrAbove(int version, int nodeCount, int timeout) throws InterruptedException {
        long maxTime = System.currentTimeMillis() + (long)timeout;
        Object object = this.monitor;
        synchronized (object) {
            while (true) {
                int ackedNodes = 0;
                for (NodeInfo node : this.cluster.getNodeInfo()) {
                    if (node.getClusterStateVersionBundleAcknowledged() < version) continue;
                    ++ackedNodes;
                }
                if (ackedNodes >= nodeCount) {
                    log.log(LogLevel.INFO, ackedNodes + " nodes now have acked system state " + version + " or higher.");
                    return;
                }
                long remainingTime = maxTime - System.currentTimeMillis();
                if (remainingTime <= 0L) {
                    throw new IllegalStateException("Did not get " + nodeCount + " nodes to system state " + version + " within timeout of " + timeout + " milliseconds.");
                }
                this.monitor.wait(10L);
            }
        }
    }

    public void waitForNodesInSlobrok(int distNodeCount, int storNodeCount, int timeoutMillis) throws InterruptedException {
        long maxTime = System.currentTimeMillis() + (long)timeoutMillis;
        Object object = this.monitor;
        synchronized (object) {
            while (true) {
                int distCount = 0;
                int storCount = 0;
                for (NodeInfo info : this.cluster.getNodeInfo()) {
                    if (info.isRpcAddressOutdated()) continue;
                    if (info.isDistributor()) {
                        ++distCount;
                        continue;
                    }
                    ++storCount;
                }
                if (distCount == distNodeCount && storCount == storNodeCount) {
                    return;
                }
                long remainingTime = maxTime - System.currentTimeMillis();
                if (remainingTime <= 0L) {
                    throw new IllegalStateException("Did not get all " + distNodeCount + " distributors and " + storNodeCount + " storage nodes registered in slobrok within timeout of " + timeoutMillis + " ms. (Got " + distCount + " distributors and " + storCount + " storage nodes)");
                }
                this.monitor.wait(10L);
            }
        }
    }

    public boolean hasZookeeperConnection() {
        return !this.database.isClosed();
    }

    public int getSlobrokMirrorUpdates() {
        return ((SlobrokClient)this.nodeLookup).getMirror().updates();
    }

    public ContentCluster getCluster() {
        return this.cluster;
    }

    public List<NodeEvent> getNodeEvents(Node n) {
        return this.eventLog.getNodeEvents(n);
    }

    public EventLog getEventLog() {
        return this.eventLog;
    }
}

