/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core.database;

import com.yahoo.log.LogLevel;
import com.yahoo.vdslib.state.Node;
import com.yahoo.vdslib.state.NodeState;
import com.yahoo.vdslib.state.NodeType;
import com.yahoo.vdslib.state.State;
import com.yahoo.vespa.clustercontroller.core.AnnotatedClusterState;
import com.yahoo.vespa.clustercontroller.core.ClusterStateBundle;
import com.yahoo.vespa.clustercontroller.core.ContentCluster;
import com.yahoo.vespa.clustercontroller.core.database.Database;
import com.yahoo.vespa.clustercontroller.core.database.MasterDataGatherer;
import com.yahoo.vespa.clustercontroller.core.rpc.SlimeClusterStateBundleCodec;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;

public class ZooKeeperDatabase
extends Database {
    private static Logger log = Logger.getLogger(ZooKeeperDatabase.class.getName());
    private static Charset utf8 = Charset.forName("UTF8");
    private static final List<ACL> acl = ZooDefs.Ids.OPEN_ACL_UNSAFE;
    private final String zooKeeperRoot;
    private final Database.DatabaseListener listener;
    private final ZooKeeperWatcher watcher = new ZooKeeperWatcher();
    private final ZooKeeper session;
    private boolean sessionOpen = true;
    private final int nodeIndex;
    private final MasterDataGatherer masterDataGatherer;
    private boolean reportErrors = true;

    @Override
    public void stopErrorReporting() {
        this.reportErrors = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZooKeeperDatabase(ContentCluster cluster, int nodeIndex, String address, int timeout, Database.DatabaseListener zksl) throws IOException, KeeperException, InterruptedException {
        this.nodeIndex = nodeIndex;
        this.zooKeeperRoot = "/vespa/fleetcontroller/" + cluster.getName() + "/";
        this.session = new ZooKeeper(address, timeout, (Watcher)this.watcher);
        boolean completedOk = false;
        try {
            this.listener = zksl;
            this.setupRoot();
            log.log((Level)LogLevel.SPAM, "Fleetcontroller " + nodeIndex + ": Asking for initial data on master election");
            this.masterDataGatherer = new MasterDataGatherer(this.session, this.zooKeeperRoot, this.listener, nodeIndex);
            completedOk = true;
        }
        finally {
            if (!completedOk) {
                this.session.close();
            }
        }
    }

    private void createNode(String prefix, String nodename, byte[] value) throws KeeperException, InterruptedException {
        try {
            if (this.session.exists(prefix + nodename, false) != null) {
                log.log((Level)LogLevel.DEBUG, "Fleetcontroller " + this.nodeIndex + ": Zookeeper node '" + prefix + nodename + "' already exists. Not creating it");
                return;
            }
            this.session.create(prefix + nodename, value, acl, CreateMode.PERSISTENT);
            log.log((Level)LogLevel.DEBUG, "Fleetcontroller " + this.nodeIndex + ": Created zookeeper node '" + prefix + nodename + "'");
        }
        catch (KeeperException.NodeExistsException e) {
            log.log((Level)LogLevel.DEBUG, "Fleetcontroller " + this.nodeIndex + ": Node to create existed, but this is normal as other nodes may create them at the same time.");
        }
    }

    private void setupRoot() throws KeeperException, InterruptedException {
        String[] pathElements = this.zooKeeperRoot.substring(1).split("/");
        String path = "";
        for (String elem : pathElements) {
            path = path + "/" + elem;
            this.createNode("", path, new byte[0]);
        }
        this.createNode(this.zooKeeperRoot, "indexes", new byte[0]);
        this.createNode(this.zooKeeperRoot, "wantedstates", new byte[0]);
        this.createNode(this.zooKeeperRoot, "starttimestamps", new byte[0]);
        this.createNode(this.zooKeeperRoot, "latestversion", Integer.valueOf(0).toString().getBytes(utf8));
        this.createNode(this.zooKeeperRoot, "published_state_bundle", new byte[0]);
        byte[] val = String.valueOf(this.nodeIndex).getBytes(utf8);
        this.deleteNodeIfExists(this.getMyIndexPath());
        log.log(LogLevel.INFO, "Fleetcontroller " + this.nodeIndex + ": Creating ephemeral master vote node with vote to self.");
        this.session.create(this.getMyIndexPath(), val, acl, CreateMode.EPHEMERAL);
    }

    private void deleteNodeIfExists(String path) throws KeeperException, InterruptedException {
        if (this.session.exists(path, false) != null) {
            log.log(LogLevel.INFO, "Fleetcontroller " + this.nodeIndex + ": Removing master vote node.");
            this.session.delete(path, -1);
        }
    }

    private String getMyIndexPath() {
        return this.zooKeeperRoot + "indexes/" + this.nodeIndex;
    }

    @Override
    public void close() {
        this.sessionOpen = false;
        try {
            log.log((Level)LogLevel.DEBUG, "Fleetcontroller " + this.nodeIndex + ": Trying to close ZooKeeper session 0x" + Long.toHexString(this.session.getSessionId()));
            this.session.close();
        }
        catch (InterruptedException e) {
            log.log(LogLevel.WARNING, "Fleetcontroller " + this.nodeIndex + ": Got interrupt exception while closing session: " + e);
        }
    }

    @Override
    public boolean isClosed() {
        return !this.sessionOpen || this.watcher.getState().equals((Object)Watcher.Event.KeeperState.Expired);
    }

    private void maybeLogExceptionWarning(Exception e, String message) {
        if (this.sessionOpen && this.reportErrors) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            log.log(LogLevel.WARNING, String.format("Fleetcontroller %s: %s. Exception: %s\n%s", this.nodeIndex, message, e.getMessage(), sw.toString()));
        }
    }

    @Override
    public boolean storeMasterVote(int wantedMasterIndex) throws InterruptedException {
        byte[] val = String.valueOf(wantedMasterIndex).getBytes(utf8);
        try {
            this.session.setData(this.getMyIndexPath(), val, -1);
            log.log(LogLevel.INFO, "Fleetcontroller " + this.nodeIndex + ": Stored new vote in ephemeral node. " + this.nodeIndex + " -> " + wantedMasterIndex);
            return true;
        }
        catch (InterruptedException e) {
            throw (InterruptedException)new InterruptedException("Interrupted").initCause(e);
        }
        catch (Exception e) {
            this.maybeLogExceptionWarning(e, "Failed to create our ephemeral node and store master vote");
            return false;
        }
    }

    @Override
    public boolean storeLatestSystemStateVersion(int version) throws InterruptedException {
        byte[] data = Integer.toString(version).getBytes(utf8);
        try {
            log.log(LogLevel.INFO, String.format("Fleetcontroller %d: Storing new cluster state version in ZooKeeper: %d", this.nodeIndex, version));
            this.session.setData(this.zooKeeperRoot + "latestversion", data, -1);
            return true;
        }
        catch (InterruptedException e) {
            throw (InterruptedException)new InterruptedException("Interrupted").initCause(e);
        }
        catch (Exception e) {
            this.maybeLogExceptionWarning(e, "Failed to store latest system state version used " + version);
            return false;
        }
    }

    @Override
    public Integer retrieveLatestSystemStateVersion() throws InterruptedException {
        Stat stat = new Stat();
        try {
            log.log((Level)LogLevel.DEBUG, "Fleetcontroller " + this.nodeIndex + ": Fetching latest cluster state at '" + this.zooKeeperRoot + "latestversion'");
            byte[] data = this.session.getData(this.zooKeeperRoot + "latestversion", false, stat);
            Integer versionNumber = Integer.valueOf(new String(data, utf8));
            log.log(LogLevel.INFO, String.format("Fleetcontroller %d: Read cluster state version %d from ZooKeeper", this.nodeIndex, versionNumber));
            return versionNumber;
        }
        catch (InterruptedException e) {
            throw (InterruptedException)new InterruptedException("Interrupted").initCause(e);
        }
        catch (Exception e) {
            this.maybeLogExceptionWarning(e, "Failed to retrieve latest system state version used. Returning null");
            return null;
        }
    }

    @Override
    public boolean storeWantedStates(Map<Node, NodeState> states) throws InterruptedException {
        if (states == null) {
            states = new TreeMap<Node, NodeState>();
        }
        StringBuilder sb = new StringBuilder();
        for (Node node : states.keySet()) {
            NodeState nodeState = states.get(node);
            if (nodeState.equals((Object)new NodeState(node.getType(), State.UP))) continue;
            NodeState toStore = new NodeState(node.getType(), nodeState.getState());
            toStore.setDescription(nodeState.getDescription());
            if (!toStore.equals((Object)nodeState)) {
                log.warning("Attempted to store wanted state with more than just a main state. Extra data stripped. Original data '" + nodeState.serialize(true));
            }
            sb.append(node.toString()).append(':').append(toStore.serialize(true)).append('\n');
        }
        byte[] val = sb.toString().getBytes(utf8);
        try {
            log.log((Level)LogLevel.DEBUG, "Fleetcontroller " + this.nodeIndex + ": Storing wanted states at '" + this.zooKeeperRoot + "wantedstates'");
            this.session.setData(this.zooKeeperRoot + "wantedstates", val, -1);
            return true;
        }
        catch (InterruptedException e) {
            throw (InterruptedException)new InterruptedException("Interrupted").initCause(e);
        }
        catch (Exception e) {
            this.maybeLogExceptionWarning(e, "Failed to store wanted states in ZooKeeper");
            return false;
        }
    }

    @Override
    public Map<Node, NodeState> retrieveWantedStates() throws InterruptedException {
        try {
            log.log((Level)LogLevel.DEBUG, "Fleetcontroller " + this.nodeIndex + ": Fetching wanted states at '" + this.zooKeeperRoot + "wantedstates'");
            Stat stat = new Stat();
            byte[] data = this.session.getData(this.zooKeeperRoot + "wantedstates", false, stat);
            TreeMap<Node, NodeState> wanted = new TreeMap<Node, NodeState>();
            if (data != null && data.length > 0) {
                StringTokenizer st = new StringTokenizer(new String(data, utf8), "\n", false);
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    int colon = token.indexOf(58);
                    try {
                        if (colon < 0) {
                            throw new Exception();
                        }
                        Node node = new Node(token.substring(0, colon));
                        NodeState nodeState = NodeState.deserialize((NodeType)node.getType(), (String)token.substring(colon + 1));
                        wanted.put(node, nodeState);
                    }
                    catch (Exception e) {
                        log.log(LogLevel.WARNING, "Fleetcontroller " + this.nodeIndex + ": Ignoring invalid wantedstate line in zookeeper '" + token + "'.");
                    }
                }
            }
            return wanted;
        }
        catch (InterruptedException e) {
            throw (InterruptedException)new InterruptedException("Interrupted").initCause(e);
        }
        catch (Exception e) {
            this.maybeLogExceptionWarning(e, "Failed to retrieve wanted states from ZooKeeper");
            return null;
        }
    }

    @Override
    public boolean storeStartTimestamps(Map<Node, Long> timestamps) throws InterruptedException {
        if (timestamps == null) {
            timestamps = new TreeMap<Node, Long>();
        }
        StringBuilder sb = new StringBuilder();
        for (Node n : timestamps.keySet()) {
            Long timestamp = timestamps.get(n);
            sb.append(n.toString()).append(':').append(timestamp).append('\n');
        }
        byte[] val = sb.toString().getBytes(utf8);
        try {
            log.log((Level)LogLevel.DEBUG, "Fleetcontroller " + this.nodeIndex + ": Storing start timestamps at '" + this.zooKeeperRoot + "starttimestamps");
            this.session.setData(this.zooKeeperRoot + "starttimestamps", val, -1);
            return true;
        }
        catch (InterruptedException e) {
            throw (InterruptedException)new InterruptedException("Interrupted").initCause(e);
        }
        catch (Exception e) {
            this.maybeLogExceptionWarning(e, "Failed to store start timestamps in ZooKeeper");
            return false;
        }
    }

    @Override
    public Map<Node, Long> retrieveStartTimestamps() throws InterruptedException {
        try {
            log.log((Level)LogLevel.DEBUG, "Fleetcontroller " + this.nodeIndex + ": Fetching start timestamps at '" + this.zooKeeperRoot + "starttimestamps'");
            Stat stat = new Stat();
            byte[] data = this.session.getData(this.zooKeeperRoot + "starttimestamps", false, stat);
            TreeMap<Node, Long> wanted = new TreeMap<Node, Long>();
            if (data != null && data.length > 0) {
                StringTokenizer st = new StringTokenizer(new String(data, utf8), "\n", false);
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    int colon = token.indexOf(58);
                    try {
                        if (colon < 0) {
                            throw new Exception();
                        }
                        Node n = new Node(token.substring(0, colon));
                        Long timestamp = Long.valueOf(token.substring(colon + 1));
                        wanted.put(n, timestamp);
                    }
                    catch (Exception e) {
                        log.log(LogLevel.WARNING, "Fleetcontroller " + this.nodeIndex + ": Ignoring invalid starttimestamp line in zookeeper '" + token + "'.");
                    }
                }
            }
            return wanted;
        }
        catch (InterruptedException e) {
            throw (InterruptedException)new InterruptedException("Interrupted").initCause(e);
        }
        catch (Exception e) {
            this.maybeLogExceptionWarning(e, "Failed to retrieve start timestamps from ZooKeeper");
            return null;
        }
    }

    @Override
    public boolean storeLastPublishedStateBundle(ClusterStateBundle stateBundle) throws InterruptedException {
        SlimeClusterStateBundleCodec envelopedBundleCodec = new SlimeClusterStateBundleCodec();
        byte[] encodedBundle = envelopedBundleCodec.encodeWithEnvelope(stateBundle);
        try {
            log.log((Level)LogLevel.DEBUG, () -> String.format("Fleetcontroller %d: Storing published state bundle %s at '%spublished_state_bundle'", this.nodeIndex, stateBundle, this.zooKeeperRoot));
            this.session.setData(this.zooKeeperRoot + "published_state_bundle", encodedBundle, -1);
        }
        catch (InterruptedException e) {
            throw (InterruptedException)new InterruptedException("Interrupted").initCause(e);
        }
        catch (Exception e) {
            this.maybeLogExceptionWarning(e, "Failed to store last published cluster state bundle in ZooKeeper");
            return false;
        }
        return true;
    }

    @Override
    public ClusterStateBundle retrieveLastPublishedStateBundle() throws InterruptedException {
        Stat stat = new Stat();
        try {
            byte[] data = this.session.getData(this.zooKeeperRoot + "published_state_bundle", false, stat);
            if (data != null && data.length != 0) {
                SlimeClusterStateBundleCodec envelopedBundleCodec = new SlimeClusterStateBundleCodec();
                return envelopedBundleCodec.decodeWithEnvelope(data);
            }
        }
        catch (InterruptedException e) {
            throw (InterruptedException)new InterruptedException("Interrupted").initCause(e);
        }
        catch (Exception e) {
            this.maybeLogExceptionWarning(e, "Failed to retrieve last published cluster state bundle from ZooKeeper, will use an empty state as baseline");
        }
        return ClusterStateBundle.ofBaselineOnly(AnnotatedClusterState.emptyState());
    }

    private class ZooKeeperWatcher
    implements Watcher {
        private Watcher.Event.KeeperState state = null;

        private ZooKeeperWatcher() {
        }

        public Watcher.Event.KeeperState getState() {
            return this.state == null ? Watcher.Event.KeeperState.SyncConnected : this.state;
        }

        public void process(WatchedEvent watchedEvent) {
            if (this.state != null && this.state.equals((Object)Watcher.Event.KeeperState.Expired)) {
                log.log(LogLevel.WARNING, "Fleetcontroller " + ZooKeeperDatabase.this.nodeIndex + ": Got event from ZooKeeper session after it expired");
                return;
            }
            Watcher.Event.KeeperState newState = watchedEvent.getState();
            if (this.state == null || !this.state.equals((Object)newState)) {
                switch (newState) {
                    case Expired: {
                        log.log(LogLevel.INFO, "Fleetcontroller " + ZooKeeperDatabase.this.nodeIndex + ": Zookeeper session expired");
                        ZooKeeperDatabase.this.sessionOpen = false;
                        ZooKeeperDatabase.this.listener.handleZooKeeperSessionDown();
                        break;
                    }
                    case Disconnected: {
                        log.log(LogLevel.INFO, "Fleetcontroller " + ZooKeeperDatabase.this.nodeIndex + ": Lost connection to zookeeper server");
                        ZooKeeperDatabase.this.sessionOpen = false;
                        ZooKeeperDatabase.this.listener.handleZooKeeperSessionDown();
                        break;
                    }
                    case SyncConnected: {
                        log.log(LogLevel.INFO, "Fleetcontroller " + ZooKeeperDatabase.this.nodeIndex + ": Connection to zookeeper server established. Refetching master data");
                        if (ZooKeeperDatabase.this.masterDataGatherer == null) break;
                        ZooKeeperDatabase.this.masterDataGatherer.restart();
                    }
                }
            }
            switch (watchedEvent.getType()) {
                case NodeChildrenChanged: {
                    log.log(LogLevel.WARNING, "Fleetcontroller " + ZooKeeperDatabase.this.nodeIndex + ": Got unexpected ZooKeeper event NodeChildrenChanged");
                    break;
                }
                case NodeDataChanged: {
                    log.log(LogLevel.WARNING, "Fleetcontroller " + ZooKeeperDatabase.this.nodeIndex + ": Got unexpected ZooKeeper event NodeDataChanged");
                    break;
                }
                case NodeCreated: {
                    log.log(LogLevel.WARNING, "Fleetcontroller " + ZooKeeperDatabase.this.nodeIndex + ": Got unexpected ZooKeeper event NodeCreated");
                    break;
                }
                case NodeDeleted: {
                    log.log(LogLevel.WARNING, "Fleetcontroller " + ZooKeeperDatabase.this.nodeIndex + ": Got unexpected ZooKeeper event NodeDeleted");
                    break;
                }
                case None: {
                    if (this.state == null || !this.state.equals((Object)watchedEvent.getState())) break;
                    log.log(LogLevel.WARNING, "Fleetcontroller " + ZooKeeperDatabase.this.nodeIndex + ": Got None type event that didn't even alter session state. What does that indicate?");
                }
            }
            this.state = watchedEvent.getState();
        }
    }
}

