/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.collections.Pair;
import com.yahoo.jrt.Target;
import com.yahoo.log.LogLevel;
import com.yahoo.vdslib.distribution.Distribution;
import com.yahoo.vdslib.distribution.Group;
import com.yahoo.vdslib.state.ClusterState;
import com.yahoo.vdslib.state.Node;
import com.yahoo.vdslib.state.NodeState;
import com.yahoo.vdslib.state.NodeType;
import com.yahoo.vdslib.state.State;
import com.yahoo.vespa.clustercontroller.core.ContentCluster;
import com.yahoo.vespa.clustercontroller.core.GetNodeStateRequest;
import com.yahoo.vespa.clustercontroller.core.Timer;
import com.yahoo.vespa.clustercontroller.core.hostinfo.HostInfo;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class NodeInfo
implements Comparable<NodeInfo> {
    public static Logger log = Logger.getLogger(NodeInfo.class.getName());
    private final ContentCluster cluster;
    private Node node;
    private String rpcAddress;
    private Long lastSeenInSlobrok;
    private List<Pair<GetNodeStateRequest, Long>> pendingNodeStateRequests = new LinkedList<Pair<GetNodeStateRequest, Long>>();
    private NodeState reportedState;
    private NodeState wantedState;
    private boolean configuredRetired;
    private boolean recentlyObservedUnstableDuringInit;
    private long nextAttemptTime;
    private Target connection;
    public Target lastRequestInfoConnection;
    private int connectionVersion;
    private int connectionAttemptCount;
    private long timeOfFirstFailingConnectionAttempt;
    private int version;
    private Map<Integer, ClusterState> systemStateVersionSent = new TreeMap<Integer, ClusterState>();
    private ClusterState systemStateVersionAcknowledged;
    private long wentDownWithStartTime = 0L;
    private ClusterState wentDownAtClusterState;
    private long transitionTime = -1L;
    private long initProgressTime = -1L;
    private long upStableStateTime = -1L;
    private long downStableStateTime = -1L;
    private int prematureCrashCount = 0;
    private long adjustedVersionTime = 0L;
    private HostInfo hostInfo = HostInfo.createHostInfo("{}");
    private Group group;

    NodeInfo(ContentCluster cluster, Node n, boolean configuredRetired, String rpcAddress, Distribution distribution) {
        if (cluster == null) {
            throw new IllegalArgumentException("Cluster not set");
        }
        this.reportedState = new NodeState(n.getType(), State.DOWN);
        this.wantedState = new NodeState(n.getType(), State.UP);
        this.cluster = cluster;
        this.node = n;
        this.connectionAttemptCount = 0;
        this.timeOfFirstFailingConnectionAttempt = 0L;
        this.version = this.getLatestVersion();
        this.connectionVersion = this.getLatestVersion();
        this.configuredRetired = configuredRetired;
        this.recentlyObservedUnstableDuringInit = false;
        this.rpcAddress = rpcAddress;
        this.lastSeenInSlobrok = null;
        this.nextAttemptTime = 0L;
        this.setGroup(distribution);
    }

    public void setRpcAddress(String rpcAddress) {
        this.rpcAddress = rpcAddress;
        this.resetConnectionInformation();
    }

    private void resetConnectionInformation() {
        this.lastSeenInSlobrok = null;
        this.nextAttemptTime = 0L;
        this.version = this.getLatestVersion();
        this.connectionVersion = this.getLatestVersion();
    }

    public long getWentDownWithStartTime() {
        return this.wentDownWithStartTime;
    }

    public long getStartTimestamp() {
        return this.cluster.getStartTimestamp(this.node);
    }

    public void setStartTimestamp(long ts) {
        this.cluster.setStartTimestamp(this.node, ts);
    }

    public void setTransitionTime(long time) {
        this.transitionTime = time;
    }

    public long getTransitionTime() {
        return this.transitionTime;
    }

    public void setInitProgressTime(long time) {
        this.initProgressTime = time;
    }

    public long getInitProgressTime() {
        return this.initProgressTime;
    }

    public long getUpStableStateTime() {
        return this.upStableStateTime;
    }

    public long getDownStableStateTime() {
        return this.downStableStateTime;
    }

    public int getConnectionAttemptCount() {
        return this.connectionAttemptCount;
    }

    public boolean recentlyObservedUnstableDuringInit() {
        return this.recentlyObservedUnstableDuringInit;
    }

    public void setRecentlyObservedUnstableDuringInit(boolean unstable) {
        this.recentlyObservedUnstableDuringInit = unstable;
    }

    public void setPrematureCrashCount(int count) {
        if (count == 0) {
            this.recentlyObservedUnstableDuringInit = false;
        }
        if (this.prematureCrashCount != count) {
            this.prematureCrashCount = count;
            log.log((Level)LogLevel.DEBUG, "Premature crash count on " + this.toString() + " set to " + count);
        }
    }

    public int getPrematureCrashCount() {
        return this.prematureCrashCount;
    }

    public boolean isPendingGetNodeStateRequest(GetNodeStateRequest r) {
        for (Pair<GetNodeStateRequest, Long> it : this.pendingNodeStateRequests) {
            if (it.getFirst() != r) continue;
            return true;
        }
        return false;
    }

    public void setConfiguredRetired(boolean retired) {
        this.configuredRetired = retired;
    }

    public void setNextGetStateAttemptTime(long timeInMillis) {
        this.nextAttemptTime = timeInMillis;
    }

    @Override
    public int compareTo(NodeInfo info) {
        return this.node.compareTo(info.node);
    }

    public int hashCode() {
        return this.node.hashCode();
    }

    public String toString() {
        return this.node.toString();
    }

    public void setGroup(Distribution distribution) {
        this.group = null;
        if (distribution != null) {
            this.group = distribution.getRootGroup().getGroupForNode(this.node.getIndex());
        }
    }

    public Group getGroup() {
        return this.group;
    }

    public int getLatestVersion() {
        return 3;
    }

    public String getSlobrokAddress() {
        return "storage/cluster." + this.cluster.getName() + "/" + this.node.getType() + "/" + this.node.getIndex();
    }

    public void markRpcAddressOutdated(Timer timer) {
        this.lastSeenInSlobrok = timer.getCurrentTimeInMillis();
    }

    public void markRpcAddressLive() {
        this.lastSeenInSlobrok = null;
    }

    public Node getNode() {
        return this.node;
    }

    public boolean isDistributor() {
        return this.node.getType().equals((Object)NodeType.DISTRIBUTOR);
    }

    public boolean isStorage() {
        return this.node.getType().equals((Object)NodeType.STORAGE);
    }

    public int getNodeIndex() {
        return this.node.getIndex();
    }

    public ContentCluster getCluster() {
        return this.cluster;
    }

    public boolean isRpcAddressOutdated() {
        return this.lastSeenInSlobrok != null;
    }

    public Long getRpcAddressOutdatedTimestamp() {
        return this.lastSeenInSlobrok;
    }

    public void abortCurrentNodeStateRequests() {
        for (Pair<GetNodeStateRequest, Long> it : this.pendingNodeStateRequests) {
            ((GetNodeStateRequest)it.getFirst()).abort();
        }
        this.pendingNodeStateRequests.clear();
    }

    public void setCurrentNodeStateRequest(GetNodeStateRequest r, long timeInMS) {
        this.pendingNodeStateRequests.add((Pair<GetNodeStateRequest, Long>)new Pair((Object)r, (Object)timeInMS));
    }

    public String getRpcAddress() {
        return this.rpcAddress;
    }

    public NodeState getReportedState() {
        return this.reportedState;
    }

    public NodeState getWantedState() {
        NodeState retiredState = new NodeState(this.node.getType(), State.RETIRED);
        if (this.configuredRetired && this.wantedState.above(retiredState)) {
            return retiredState;
        }
        return this.wantedState;
    }

    public NodeState getUserWantedState() {
        return this.wantedState;
    }

    public long getTimeOfFirstFailingConnectionAttempt() {
        return this.timeOfFirstFailingConnectionAttempt;
    }

    public Long getLatestNodeStateRequestTime() {
        if (this.pendingNodeStateRequests.isEmpty()) {
            return null;
        }
        return (Long)this.pendingNodeStateRequests.get(this.pendingNodeStateRequests.size() - 1).getSecond();
    }

    public void setTimeOfFirstFailingConnectionAttempt(long timeInMS) {
        if (this.timeOfFirstFailingConnectionAttempt == 0L) {
            this.timeOfFirstFailingConnectionAttempt = timeInMS;
        }
    }

    public void removePendingGetNodeStateRequest(GetNodeStateRequest request) {
        int n = this.pendingNodeStateRequests.size();
        for (int i = 0; i < n; ++i) {
            if (this.pendingNodeStateRequests.get(i).getFirst() != request) continue;
            this.pendingNodeStateRequests.remove(i);
            break;
        }
    }

    public void setReportedState(NodeState state, long time) {
        if (state == null) {
            state = new NodeState(this.node.getType(), State.DOWN);
        }
        if (state.getState().oneOf("dsm") && !this.reportedState.getState().oneOf("dsm")) {
            this.wentDownWithStartTime = this.reportedState.getStartTimestamp();
            this.wentDownAtClusterState = this.getNewestSystemStateSent();
            log.log((Level)LogLevel.DEBUG, "Setting going down timestamp of node " + this.node + " to " + this.wentDownWithStartTime);
        }
        if (state.getState().equals((Object)State.DOWN) && !this.reportedState.getState().oneOf("d")) {
            this.downStableStateTime = time;
            log.log((Level)LogLevel.DEBUG, "Down stable state on " + this.toString() + " altered to " + time);
            if (this.reportedState.getState() == State.INITIALIZING) {
                this.recentlyObservedUnstableDuringInit = true;
            }
        } else if (state.getState().equals((Object)State.UP) && !this.reportedState.getState().oneOf("u")) {
            this.upStableStateTime = time;
            log.log((Level)LogLevel.DEBUG, "Up stable state on " + this.toString() + " altered to " + time);
        }
        if (!state.getState().validReportedNodeState(this.node.getType())) {
            throw new IllegalStateException("Trying to set illegal reported node state: " + state);
        }
        if (state.getState().oneOf("sd")) {
            if (!this.reportedState.getState().oneOf("ui") && this.reportedState.hasDescription()) {
                state.setDescription(this.reportedState.getDescription());
            }
            this.reportedState = state;
            if (this.connectionAttemptCount < Integer.MAX_VALUE) {
                ++this.connectionAttemptCount;
            }
            this.nextAttemptTime = this.connectionAttemptCount < 5 ? time + 100L : (this.connectionAttemptCount < 20 ? time + 250L : (this.connectionAttemptCount < 100 ? time + 1000L : time + 5000L));
            log.log((Level)LogLevel.SPAM, "Failed to get state from node " + this.toString() + ", scheduling next attempt in " + (this.nextAttemptTime - time) + " ms.");
        } else {
            this.connectionAttemptCount = 0;
            this.timeOfFirstFailingConnectionAttempt = 0L;
            this.reportedState = state;
            if (this.version == 0 || state.getState().equals((Object)State.STOPPING)) {
                this.nextAttemptTime = time + (long)this.cluster.getPollingFrequency();
                log.log((Level)LogLevel.SPAM, "Scheduling next attempt to get state from " + this.toString() + " in " + (this.nextAttemptTime - time) + " ms (polling freq).");
            } else {
                this.nextAttemptTime = time;
            }
        }
        log.log((Level)LogLevel.SPAM, "Set reported state of node " + this + " to " + this.reportedState + ". Next connection attempt is at " + this.nextAttemptTime);
    }

    public void setWantedState(NodeState state) {
        if (state == null) {
            state = new NodeState(this.node.getType(), State.UP);
        }
        NodeState newWanted = new NodeState(this.node.getType(), state.getState());
        newWanted.setDescription(state.getDescription());
        if (!newWanted.equals((Object)state)) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                log.warning("Attempted to set wanted state with more than just a main state. Extra data stripped. Original data '" + state.serialize(true) + ":\n" + sw.toString());
            }
        }
        this.wantedState = newWanted;
        log.log((Level)LogLevel.SPAM, "Set wanted state of node " + this + " to " + this.wantedState + ".");
    }

    public long getTimeForNextStateRequestAttempt() {
        return this.nextAttemptTime;
    }

    public boolean notifyNoSuchMethodError(String methodName, Timer timer) {
        if (methodName.equals("setdistributionstates")) {
            if (this.version == 3) {
                this.downgradeToRpcVersion(2, methodName, timer);
                return true;
            }
            if (timer.getCurrentTimeInMillis() - 2000L < this.adjustedVersionTime) {
                log.log((Level)LogLevel.DEBUG, () -> "Node " + this.toString() + " does not support " + methodName + " call. Version already downgraded, so ignoring it.");
                return true;
            }
        }
        log.log(LogLevel.WARNING, "Node " + this.toString() + " does not support " + methodName + " which it should.");
        return false;
    }

    private void downgradeToRpcVersion(int newVersion, String methodName, Timer timer) {
        log.log((Level)LogLevel.DEBUG, () -> String.format("Node %s does not support %s call. Downgrading to version %d.", this.toString(), methodName, newVersion));
        this.version = newVersion;
        this.nextAttemptTime = 0L;
        this.adjustedVersionTime = timer.getCurrentTimeInMillis();
    }

    public Target getConnection() {
        return this.connection;
    }

    public Target setConnection(Target t) {
        this.connection = t;
        this.connectionVersion = this.getLatestVersion();
        return t;
    }

    public int getVersion() {
        return this.version;
    }

    public int getConnectionVersion() {
        return this.connectionVersion;
    }

    public void setConnectionVersion(int version) {
        this.connectionVersion = version;
    }

    public ClusterState getNewestSystemStateSent() {
        ClusterState last = null;
        for (ClusterState s : this.systemStateVersionSent.values()) {
            if (last != null && last.getVersion() >= s.getVersion()) continue;
            last = s;
        }
        return last;
    }

    public int getNewestSystemStateVersionSent() {
        ClusterState last = this.getNewestSystemStateSent();
        return last == null ? -1 : last.getVersion();
    }

    public int getSystemStateVersionAcknowledged() {
        return this.systemStateVersionAcknowledged == null ? -1 : this.systemStateVersionAcknowledged.getVersion();
    }

    public void setSystemStateVersionSent(ClusterState state) {
        if (state == null) {
            throw new Error("Should not clear info for last version sent");
        }
        if (this.systemStateVersionSent.containsKey(state.getVersion())) {
            throw new IllegalStateException("We have already sent cluster state version " + state.getVersion() + " to " + this.node);
        }
        this.systemStateVersionSent.put(state.getVersion(), state);
    }

    public void setSystemStateVersionAcknowledged(Integer version, boolean success) {
        if (version == null) {
            throw new Error("Should not clear info for last version acked");
        }
        if (!this.systemStateVersionSent.containsKey(version)) {
            throw new IllegalStateException("Got response for cluster state " + version + " which is not tracked as pending for node " + this.node);
        }
        ClusterState state = this.systemStateVersionSent.remove(version);
        if (success && (this.systemStateVersionAcknowledged == null || this.systemStateVersionAcknowledged.getVersion() < state.getVersion())) {
            this.systemStateVersionAcknowledged = state;
            if (!(this.wentDownWithStartTime == 0L || this.wentDownAtClusterState != null && this.wentDownAtClusterState.getVersion() >= state.getVersion() || state.getNodeState(this.node).getState().oneOf("dsm"))) {
                log.log((Level)LogLevel.DEBUG, "Clearing going down timestamp of node " + this.node + " after receiving ack of cluster state " + state);
                this.wentDownWithStartTime = 0L;
            }
        }
    }

    public void setHostInfo(HostInfo hostInfo) {
        this.hostInfo = hostInfo;
    }

    public HostInfo getHostInfo() {
        return this.hostInfo;
    }

    public String getVtag() {
        return this.hostInfo.getVtag().getVersionOrNull();
    }
}

