/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.vdslib.state.ClusterState;
import com.yahoo.vdslib.state.Node;
import com.yahoo.vdslib.state.NodeState;
import com.yahoo.vdslib.state.NodeType;
import com.yahoo.vdslib.state.State;
import com.yahoo.vespa.clustercontroller.core.ContentCluster;
import com.yahoo.vespa.clustercontroller.utils.util.ComponentMetricReporter;
import com.yahoo.vespa.clustercontroller.utils.util.MetricReporter;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

public class MetricUpdater {
    private final ComponentMetricReporter metricReporter;

    public MetricUpdater(MetricReporter metricReporter, int controllerIndex) {
        this.metricReporter = new ComponentMetricReporter(metricReporter, "cluster-controller.");
        this.metricReporter.addDimension("controller-index", String.valueOf(controllerIndex));
    }

    public MetricReporter.Context createContext(Map<String, String> dimensions) {
        return this.metricReporter.createContext(dimensions);
    }

    private static int nodesInAvailableState(Map<State, Integer> nodeCounts) {
        return nodeCounts.getOrDefault(State.INITIALIZING, 0) + nodeCounts.getOrDefault(State.RETIRED, 0) + nodeCounts.getOrDefault(State.UP, 0) + nodeCounts.getOrDefault(State.MAINTENANCE, 0);
    }

    public void updateClusterStateMetrics(ContentCluster cluster, ClusterState state) {
        HashMap<String, String> dimensions = new HashMap<String, String>();
        dimensions.put("cluster", cluster.getName());
        for (NodeType type : NodeType.getTypes()) {
            dimensions.put("node-type", type.toString().toLowerCase());
            MetricReporter.Context context = this.createContext(dimensions);
            HashMap<State, Integer> nodeCounts = new HashMap<State, Integer>();
            for (Object s : State.values()) {
                nodeCounts.put((State)s, 0);
            }
            for (Integer i : cluster.getConfiguredNodes().keySet()) {
                NodeState s = state.getNodeState(new Node(type, i.intValue()));
                Integer count = (Integer)nodeCounts.get(s.getState());
                nodeCounts.put(s.getState(), count + 1);
            }
            for (Object s : State.values()) {
                String name = s.toString().toLowerCase() + ".count";
                this.metricReporter.set(name, (Number)nodeCounts.get(s), context);
            }
            int availableNodes = MetricUpdater.nodesInAvailableState(nodeCounts);
            int totalNodes = Math.max(cluster.getConfiguredNodes().size(), 1);
            this.metricReporter.set("available-nodes.ratio", (Number)((double)availableNodes / (double)totalNodes), context);
        }
        dimensions.remove("node-type");
        MetricReporter.Context context = this.createContext(dimensions);
        this.metricReporter.add("cluster-state-change", (Number)1, context);
    }

    public void updateMasterElectionMetrics(Map<Integer, Integer> data) {
        HashMap<Integer, Integer> voteCounts = new HashMap<Integer, Integer>();
        for (Integer i : data.values()) {
            int count = voteCounts.get(i) == null ? 0 : (Integer)voteCounts.get(i);
            voteCounts.put(i, count + 1);
        }
        TreeSet counts = new TreeSet(voteCounts.values());
        if (counts.size() > 1 && (Integer)counts.first() > (Integer)counts.last()) {
            throw new IllegalStateException("Assumed smallest count is sorted first");
        }
        int maxCount = counts.isEmpty() ? 0 : (Integer)counts.last();
        this.metricReporter.set("agreed-master-votes", (Number)maxCount);
    }

    public void becameMaster() {
        this.metricReporter.set("is-master", (Number)1);
        this.metricReporter.add("master-change", (Number)1);
    }

    public void noLongerMaster() {
        this.metricReporter.set("is-master", (Number)0);
        this.metricReporter.add("master-change", (Number)1);
    }

    public void addTickTime(long millis, boolean didWork) {
        if (didWork) {
            this.metricReporter.set("busy-tick-time-ms", (Number)millis);
        } else {
            this.metricReporter.set("idle-tick-time-ms", (Number)millis);
        }
    }

    public void recordNewNodeEvent() {
        this.metricReporter.add("node-event", (Number)1);
    }
}

