/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core.restapiv2.requests;

import com.yahoo.log.LogLevel;
import com.yahoo.vdslib.state.ClusterState;
import com.yahoo.vdslib.state.Node;
import com.yahoo.vdslib.state.NodeState;
import com.yahoo.vdslib.state.NodeType;
import com.yahoo.vdslib.state.State;
import com.yahoo.vespa.clustercontroller.core.ContentCluster;
import com.yahoo.vespa.clustercontroller.core.NodeInfo;
import com.yahoo.vespa.clustercontroller.core.NodeStateChangeChecker;
import com.yahoo.vespa.clustercontroller.core.RemoteClusterControllerTask;
import com.yahoo.vespa.clustercontroller.core.listeners.NodeStateOrHostInfoChangeHandler;
import com.yahoo.vespa.clustercontroller.core.restapiv2.Id;
import com.yahoo.vespa.clustercontroller.core.restapiv2.MissingIdException;
import com.yahoo.vespa.clustercontroller.core.restapiv2.Request;
import com.yahoo.vespa.clustercontroller.core.restapiv2.requests.WantedStateSetter;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.errors.InvalidContentException;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.errors.StateRestApiException;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.requests.SetUnitStateRequest;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.response.SetResponse;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.response.UnitState;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SetNodeStateRequest
extends Request<SetResponse> {
    private static final Logger log = Logger.getLogger(SetNodeStateRequest.class.getName());
    private final Id.Node id;
    private final Map<String, UnitState> newStates;
    private final SetUnitStateRequest.Condition condition;
    private final SetUnitStateRequest.ResponseWait responseWait;
    private final WantedStateSetter wantedState;

    public SetNodeStateRequest(Id.Node id, SetUnitStateRequest setUnitStateRequest) {
        this(id, setUnitStateRequest, SetNodeStateRequest::setWantedState);
    }

    public SetNodeStateRequest(Id.Node id, SetUnitStateRequest setUnitStateRequest, WantedStateSetter wantedState) {
        super(Request.MasterState.MUST_BE_MASTER);
        this.id = id;
        this.newStates = setUnitStateRequest.getNewState();
        this.condition = setUnitStateRequest.getCondition();
        this.responseWait = setUnitStateRequest.getResponseWait();
        this.wantedState = wantedState;
    }

    @Override
    public SetResponse calculateResult(RemoteClusterControllerTask.Context context) throws StateRestApiException {
        return this.wantedState.set(context.cluster, this.condition, this.newStates, this.id.getNode(), context.nodeStateOrHostInfoChangeHandler, context.currentConsolidatedState);
    }

    static NodeState getRequestedNodeState(Map<String, UnitState> newStates, Node n) throws StateRestApiException {
        State state;
        UnitState newState = newStates.get("user");
        if (newState == null) {
            throw new InvalidContentException("No new user state given in request");
        }
        switch (newState.getId().toLowerCase()) {
            case "up": {
                state = State.UP;
                break;
            }
            case "retired": {
                state = State.RETIRED;
                break;
            }
            case "maintenance": {
                state = State.MAINTENANCE;
                break;
            }
            case "down": {
                state = State.DOWN;
                break;
            }
            default: {
                throw new InvalidContentException("Invalid user state '" + newState.getId() + "' given.");
            }
        }
        return new NodeState(n.getType(), state).setDescription(newState.getReason());
    }

    @Override
    public boolean hasVersionAckDependency() {
        return this.responseWait == SetUnitStateRequest.ResponseWait.WAIT_UNTIL_CLUSTER_ACKED;
    }

    @Override
    public boolean isFailed() {
        return super.isFailed() || this.resultSet && !((SetResponse)this.result).getWasModified();
    }

    static SetResponse setWantedState(ContentCluster cluster, SetUnitStateRequest.Condition condition, Map<String, UnitState> newStates, Node node, NodeStateOrHostInfoChangeHandler stateListener, ClusterState currentClusterState) throws StateRestApiException {
        if (!cluster.hasConfiguredNode(node.getIndex())) {
            throw new MissingIdException(cluster.getName(), node);
        }
        NodeInfo nodeInfo = cluster.getNodeInfo(node);
        if (nodeInfo == null) {
            throw new IllegalArgumentException("Cannot set the wanted state of unknown node " + node);
        }
        NodeState wantedState = nodeInfo.getUserWantedState();
        NodeState newWantedState = SetNodeStateRequest.getRequestedNodeState(newStates, node);
        NodeStateChangeChecker.Result result = cluster.calculateEffectOfNewState(node, currentClusterState, condition, wantedState, newWantedState);
        log.log((Level)LogLevel.DEBUG, "node=" + node + " current-cluster-state=" + currentClusterState + " condition=" + condition + " wanted-state=" + wantedState + " new-wanted-state=" + newWantedState + " change-check=" + result);
        boolean success = SetNodeStateRequest.setWantedStateAccordingToResult(result, newWantedState, condition, nodeInfo, cluster, stateListener);
        String reason = success ? "ok" : result.getReason();
        return new SetResponse(reason, success);
    }

    private static boolean setWantedStateAccordingToResult(NodeStateChangeChecker.Result result, NodeState newWantedState, SetUnitStateRequest.Condition condition, NodeInfo nodeInfo, ContentCluster cluster, NodeStateOrHostInfoChangeHandler stateListener) {
        boolean success;
        if (result.settingWantedStateIsAllowed()) {
            SetNodeStateRequest.setNewWantedState(nodeInfo, newWantedState, stateListener);
        }
        boolean bl = success = result.settingWantedStateIsAllowed() || result.wantedStateAlreadySet();
        if (success && condition == SetUnitStateRequest.Condition.SAFE && nodeInfo.isStorage()) {
            SetNodeStateRequest.setDistributorWantedState(cluster, nodeInfo.getNodeIndex(), newWantedState, stateListener);
        }
        return success;
    }

    private static void setDistributorWantedState(ContentCluster cluster, int index, NodeState newStorageWantedState, NodeStateOrHostInfoChangeHandler stateListener) {
        State newState;
        Node distributorNode = new Node(NodeType.DISTRIBUTOR, index);
        NodeInfo nodeInfo = cluster.getNodeInfo(distributorNode);
        if (nodeInfo == null) {
            throw new IllegalStateException("Missing distributor at index " + distributorNode.getIndex());
        }
        switch (newStorageWantedState.getState()) {
            case MAINTENANCE: {
                newState = State.DOWN;
                break;
            }
            case RETIRED: {
                newState = State.UP;
                break;
            }
            default: {
                newState = newStorageWantedState.getState();
                if (newState.validWantedNodeState(distributorNode.getType())) break;
                throw new IllegalStateException("Distributor cannot be set to wanted state " + newState);
            }
        }
        NodeState newWantedState = new NodeState(distributorNode.getType(), newState);
        newWantedState.setDescription(newStorageWantedState.getDescription());
        NodeState currentWantedState = nodeInfo.getUserWantedState();
        if (newWantedState.getState() != currentWantedState.getState() || !Objects.equals(newWantedState.getDescription(), currentWantedState.getDescription())) {
            SetNodeStateRequest.setNewWantedState(nodeInfo, newWantedState, stateListener);
        }
    }

    private static void setNewWantedState(NodeInfo nodeInfo, NodeState newWantedState, NodeStateOrHostInfoChangeHandler stateListener) {
        nodeInfo.setWantedState(newWantedState);
        stateListener.handleNewWantedNodeState(nodeInfo, newWantedState);
    }
}

