/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core.restapiv2.requests;

import com.yahoo.vespa.clustercontroller.core.RemoteClusterControllerTask;
import com.yahoo.vespa.clustercontroller.core.RemoteClusterControllerTaskScheduler;
import com.yahoo.vespa.clustercontroller.core.restapiv2.ClusterControllerStateRestAPI;
import com.yahoo.vespa.clustercontroller.core.restapiv2.Id;
import com.yahoo.vespa.clustercontroller.core.restapiv2.OtherMasterIndexException;
import com.yahoo.vespa.clustercontroller.core.restapiv2.Request;
import com.yahoo.vespa.clustercontroller.core.restapiv2.Response;
import com.yahoo.vespa.clustercontroller.core.restapiv2.requests.ClusterStateRequest;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.errors.StateRestApiException;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.response.UnitResponse;
import java.util.Map;

public class ClusterListRequest
extends Request<UnitResponse> {
    private final int recursive;
    private final ClusterControllerStateRestAPI.FleetControllerResolver resolver;

    public ClusterListRequest(int recursive, ClusterControllerStateRestAPI.FleetControllerResolver resolver) {
        super(Request.MasterState.NEED_NOT_BE_MASTER);
        this.recursive = recursive;
        this.resolver = resolver;
    }

    @Override
    public UnitResponse calculateResult(RemoteClusterControllerTask.Context context) throws StateRestApiException, OtherMasterIndexException {
        return this.calculateResult();
    }

    private UnitResponse calculateResult() throws StateRestApiException, OtherMasterIndexException {
        Response.ClusterListResponse response = new Response.ClusterListResponse();
        for (Map.Entry<String, RemoteClusterControllerTaskScheduler> e : this.resolver.getFleetControllers().entrySet()) {
            Id.Cluster clusterId = new Id.Cluster(e.getKey());
            if (this.recursive > 0) {
                ClusterStateRequest csr = new ClusterStateRequest(clusterId, this.recursive - 1);
                e.getValue().schedule(csr);
                csr.waitForCompletion();
                response.addEntry("cluster", clusterId.getClusterId(), (UnitResponse)csr.getResult());
                continue;
            }
            response.addLink("cluster", clusterId.getClusterId(), clusterId.toString());
        }
        return response;
    }
}

