/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.vespa.clustercontroller.core.AggregatedClusterStats;
import com.yahoo.vespa.clustercontroller.core.ContentNodeStats;
import com.yahoo.vespa.clustercontroller.core.MergePendingChecker;

public class AggregatedStatsMergePendingChecker
implements MergePendingChecker {
    private final AggregatedClusterStats stats;
    private final double minMergeCompletionRatio;

    public AggregatedStatsMergePendingChecker(AggregatedClusterStats stats, double minMergeCompletionRatio) {
        this.stats = stats;
        this.minMergeCompletionRatio = minMergeCompletionRatio;
    }

    @Override
    public boolean mayHaveMergesPending(String bucketSpace, int contentNodeIndex) {
        if (!this.stats.hasUpdatesFromAllDistributors()) {
            return true;
        }
        ContentNodeStats nodeStats = this.stats.getStats().getContentNode(contentNodeIndex);
        if (nodeStats != null) {
            ContentNodeStats.BucketSpaceStats bucketSpaceStats = nodeStats.getBucketSpace(bucketSpace);
            return bucketSpaceStats != null && bucketSpaceStats.mayHaveBucketsPending(this.minMergeCompletionRatio);
        }
        return true;
    }
}

