/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core.rpc;

import com.yahoo.jrt.Acceptor;
import com.yahoo.jrt.Int32Value;
import com.yahoo.jrt.ListenFailedException;
import com.yahoo.jrt.Method;
import com.yahoo.jrt.Request;
import com.yahoo.jrt.Spec;
import com.yahoo.jrt.StringArray;
import com.yahoo.jrt.StringValue;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Transport;
import com.yahoo.jrt.Value;
import com.yahoo.jrt.slobrok.api.BackOffPolicy;
import com.yahoo.jrt.slobrok.api.Register;
import com.yahoo.jrt.slobrok.api.SlobrokList;
import com.yahoo.log.LogLevel;
import com.yahoo.net.HostName;
import com.yahoo.vdslib.state.ClusterState;
import com.yahoo.vdslib.state.Node;
import com.yahoo.vdslib.state.NodeState;
import com.yahoo.vdslib.state.NodeType;
import com.yahoo.vdslib.state.State;
import com.yahoo.vespa.clustercontroller.core.ContentCluster;
import com.yahoo.vespa.clustercontroller.core.MasterElectionHandler;
import com.yahoo.vespa.clustercontroller.core.NodeInfo;
import com.yahoo.vespa.clustercontroller.core.Timer;
import com.yahoo.vespa.clustercontroller.core.listeners.NodeAddedOrRemovedListener;
import com.yahoo.vespa.clustercontroller.core.listeners.NodeStateOrHostInfoChangeHandler;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RpcServer {
    private static Logger log = Logger.getLogger(RpcServer.class.getName());
    private final Timer timer;
    private final Object monitor;
    private final String clusterName;
    private final int fleetControllerIndex;
    private String[] slobrokConnectionSpecs;
    private int port = 0;
    private Supervisor supervisor;
    private Acceptor acceptor;
    private Register register;
    private final List<Request> rpcRequests = new LinkedList<Request>();
    private MasterElectionHandler masterHandler;
    private BackOffPolicy slobrokBackOffPolicy;
    private long lastConnectErrorTime = 0L;
    private String lastConnectError = "";

    public RpcServer(Timer timer, Object monitor, String clusterName, int fleetControllerIndex, BackOffPolicy bop) {
        this.timer = timer;
        this.monitor = monitor;
        this.clusterName = clusterName;
        this.fleetControllerIndex = fleetControllerIndex;
        this.slobrokBackOffPolicy = bop;
    }

    public void setMasterElectionHandler(MasterElectionHandler handler) {
        this.masterHandler = handler;
    }

    public int getPort() {
        if (this.acceptor == null) {
            return -1;
        }
        return this.acceptor.port();
    }

    public void shutdown() {
        this.disconnect();
    }

    public String getSlobrokName() {
        return "storage/cluster." + this.clusterName + "/fleetcontroller/" + this.fleetControllerIndex;
    }

    public void setSlobrokConnectionSpecs(String[] slobrokConnectionSpecs, int port) throws ListenFailedException, UnknownHostException {
        if (this.slobrokConnectionSpecs == null || !this.slobrokConnectionSpecs.equals(slobrokConnectionSpecs) || this.port != port) {
            this.slobrokConnectionSpecs = slobrokConnectionSpecs;
            this.port = port;
            this.disconnect();
            this.connect();
        }
    }

    public boolean isConnected() {
        return this.register != null;
    }

    public void connect() throws ListenFailedException, UnknownHostException {
        this.disconnect();
        log.log((Level)LogLevel.DEBUG, "Fleetcontroller " + this.fleetControllerIndex + ": Connecting RPC server.");
        if (this.supervisor != null) {
            this.disconnect();
        }
        this.supervisor = new Supervisor(new Transport());
        this.addMethods();
        log.log((Level)LogLevel.DEBUG, "Fleetcontroller " + this.fleetControllerIndex + ": Attempting to bind to port " + this.port);
        this.acceptor = this.supervisor.listen(new Spec(this.port));
        log.log((Level)LogLevel.DEBUG, "Fleetcontroller " + this.fleetControllerIndex + ": RPC server listening to port " + this.acceptor.port());
        StringBuffer slobroks = new StringBuffer("(");
        for (String s : this.slobrokConnectionSpecs) {
            slobroks.append(" ").append(s);
        }
        slobroks.append(" )");
        SlobrokList slist = new SlobrokList();
        slist.setup(this.slobrokConnectionSpecs);
        Spec spec = new Spec(HostName.getLocalhost(), this.acceptor.port());
        log.log(LogLevel.INFO, "Registering " + spec + " with slobrok at " + slobroks);
        this.register = this.slobrokBackOffPolicy != null ? new Register(this.supervisor, slist, spec, this.slobrokBackOffPolicy) : new Register(this.supervisor, slist, spec);
        this.register.registerName(this.getSlobrokName());
    }

    public void disconnect() {
        if (this.register != null) {
            log.log((Level)LogLevel.DEBUG, "Fleetcontroller " + this.fleetControllerIndex + ": Disconnecting RPC server.");
            this.register.shutdown();
            this.register = null;
        }
        if (this.acceptor != null) {
            this.acceptor.shutdown().join();
            this.acceptor = null;
        }
        if (this.supervisor != null) {
            this.supervisor.transport().shutdown().join();
            this.supervisor = null;
        }
    }

    public void addMethods() {
        Method m = new Method("getMaster", "", "is", (Object)this, "queueRpcRequest");
        m.methodDesc("Get index of current fleetcontroller master");
        m.returnDesc(0, "masterindex", "The index of the current master according to this node, or -1 if there is none.");
        m.returnDesc(1, "description", "A textual field, used for additional information, such as why there is no master.");
        this.supervisor.addMethod(m);
        m = new Method("getNodeList", "", "SS", (Object)this, "queueRpcRequest");
        m.methodDesc("Get list of connection-specs to all nodes in the system");
        m.returnDesc(0, "distributors", "connection-spec of all distributor-nodes (empty string for unknown nodes)");
        m.returnDesc(1, "storagenodes", "connection-spec of all storage-nodes, (empty string for unknown nodes)");
        this.supervisor.addMethod(m);
        m = new Method("getSystemState", "", "ss", (Object)this, "queueRpcRequest");
        m.methodDesc("Get nodeState of all nodes and the system itself");
        m.returnDesc(0, "systemstate", "nodeState string of system");
        m.returnDesc(1, "nodestate", "nodeState-string for distributor and storage-nodes");
        this.supervisor.addMethod(m);
        m = new Method("getNodeState", "si", "ssss", (Object)this, "queueRpcRequest");
        m.methodDesc("Get nodeState of a node");
        m.paramDesc(0, "nodeType", "Type of node. Should be 'storage' or 'distributor'");
        m.paramDesc(1, "nodeIndex", "The node index");
        m.returnDesc(0, "systemState", "This nodes state in the current system state");
        m.returnDesc(1, "nodeState", "This nodes state as it reports itself. (Or down if we can't reach it)");
        m.returnDesc(2, "wantedState", "This nodes wanted state");
        m.returnDesc(3, "rpcAddress", "This nodes RPC server address");
        this.supervisor.addMethod(m);
        m = new Method("setNodeState", "ss", "s", (Object)this, "queueRpcRequest");
        m.methodDesc("Set nodeState of a node");
        m.paramDesc(0, "slobrokAddress", "Slobrok address of node");
        m.paramDesc(1, "nodeState", "Desired nodeState of the node (complete nodeState string - [key:value ]*)");
        m.returnDesc(0, "status", "success/failure");
        this.supervisor.addMethod(m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueRpcRequest(Request req) {
        Object object = this.monitor;
        synchronized (object) {
            req.detach();
            this.rpcRequests.add(req);
            this.monitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleRpcRequests(ContentCluster cluster, ClusterState systemState, NodeStateOrHostInfoChangeHandler changeListener, NodeAddedOrRemovedListener addedListener) {
        boolean handledAnyRequests;
        block28: {
            handledAnyRequests = false;
            if (!this.isConnected()) {
                long time = this.timer.getCurrentTimeInMillis();
                try {
                    this.connect();
                }
                catch (ListenFailedException e) {
                    if (!e.getMessage().equals(this.lastConnectError) || time - this.lastConnectErrorTime > 60000L) {
                        this.lastConnectError = e.getMessage();
                        this.lastConnectErrorTime = time;
                        log.log(LogLevel.WARNING, "Failed to bind RPC server to port " + this.port + ": " + e.getMessage());
                    }
                }
                catch (Exception e) {
                    if (e.getMessage().equals(this.lastConnectError) && time - this.lastConnectErrorTime <= 60000L) break block28;
                    this.lastConnectError = e.getMessage();
                    this.lastConnectErrorTime = time;
                    log.log(LogLevel.WARNING, "Failed to initailize RPC server socket: " + e.getMessage());
                }
            }
        }
        for (int j = 0; j < 10; ++j) {
            Request req;
            Object e = this.monitor;
            synchronized (e) {
                if (this.rpcRequests.isEmpty()) {
                    break;
                }
                Iterator<Request> it = this.rpcRequests.iterator();
                req = it.next();
                it.remove();
                handledAnyRequests = true;
            }
            try {
                String message;
                Integer nodeIndex;
                if (req.methodName().equals("getMaster")) {
                    log.log((Level)LogLevel.DEBUG, "Resolving RPC getMaster request");
                    Integer master = this.masterHandler.getMaster();
                    String masterReason = this.masterHandler.getMasterReason();
                    req.returnValues().add((Value)new Int32Value(master == null ? -1 : master));
                    req.returnValues().add((Value)new StringValue(masterReason == null ? "No reason given" : masterReason));
                    req.returnRequest();
                    continue;
                }
                if (!this.masterHandler.isMaster()) {
                    throw new IllegalStateException("Refusing to answer RPC calls as we are not the master fleetcontroller.");
                }
                if (req.methodName().equals("getNodeList")) {
                    log.log((Level)LogLevel.DEBUG, "Resolving RPC getNodeList request");
                    ArrayList<String> slobrok = new ArrayList<String>();
                    ArrayList<String> rpc = new ArrayList<String>();
                    for (NodeInfo node : cluster.getNodeInfo()) {
                        String s1 = node.getSlobrokAddress();
                        String s2 = node.getRpcAddress();
                        assert (s1 != null);
                        slobrok.add(s1);
                        rpc.add(s2 == null ? "" : s2);
                    }
                    req.returnValues().add((Value)new StringArray(slobrok.toArray(new String[slobrok.size()])));
                    req.returnValues().add((Value)new StringArray(rpc.toArray(new String[rpc.size()])));
                    req.returnRequest();
                    continue;
                }
                if (req.methodName().equals("getSystemState")) {
                    log.log((Level)LogLevel.DEBUG, "Resolving RPC getSystemState request");
                    req.returnValues().add((Value)new StringValue(""));
                    req.returnValues().add((Value)new StringValue(systemState.toString(true)));
                    req.returnRequest();
                    continue;
                }
                if (req.methodName().equals("getNodeState")) {
                    log.log((Level)LogLevel.DEBUG, "Resolving RPC getNodeState request");
                    NodeType nodeType = NodeType.get((String)req.parameters().get(0).asString());
                    int nodeIndex2 = req.parameters().get(1).asInt32();
                    Node node = new Node(nodeType, nodeIndex2);
                    NodeState ns = systemState.getNodeState(node);
                    req.returnValues().add((Value)new StringValue(systemState.getNodeState(node).serialize()));
                    NodeInfo nodeInfo = cluster.getNodeInfo(node);
                    if (nodeInfo == null) {
                        throw new RuntimeException("No node " + node + " exists in cluster " + cluster.getName());
                    }
                    NodeState fromNode = nodeInfo.getReportedState();
                    req.returnValues().add((Value)new StringValue(fromNode == null ? "unknown" : fromNode.serialize()));
                    req.returnValues().add((Value)new StringValue(nodeInfo.getWantedState().serialize()));
                    req.returnValues().add((Value)new StringValue(nodeInfo.getRpcAddress() == null ? "" : nodeInfo.getRpcAddress()));
                    req.returnRequest();
                    continue;
                }
                if (!req.methodName().equals("setNodeState")) continue;
                String slobrokAddress = req.parameters().get(0).asString();
                int lastSlash = slobrokAddress.lastIndexOf(47);
                int nextButLastSlash = slobrokAddress.lastIndexOf(47, lastSlash - 1);
                if (lastSlash == -1 || nextButLastSlash == -1) {
                    throw new IllegalStateException("Invalid slobrok address '" + slobrokAddress + "'.");
                }
                NodeType nodeType = NodeType.get((String)slobrokAddress.substring(nextButLastSlash + 1, lastSlash));
                NodeInfo node = cluster.getNodeInfo(new Node(nodeType, (nodeIndex = Integer.valueOf(slobrokAddress.substring(lastSlash + 1))).intValue()));
                if (node == null) {
                    throw new IllegalStateException("Cannot set wanted state of node " + new Node(nodeType, nodeIndex.intValue()) + ". Index does not correspond to a configured node.");
                }
                NodeState nodeState = NodeState.deserialize((NodeType)nodeType, (String)req.parameters().get(1).asString());
                if (nodeState.getDescription().equals("") && !nodeState.getState().equals((Object)State.UP) && !nodeState.getState().equals((Object)State.RETIRED)) {
                    nodeState.setDescription("Set by remote RPC client");
                }
                NodeState oldState = node.getUserWantedState();
                String string = message = nodeState.getState().equals((Object)State.UP) ? "Clearing wanted nodeState for node " + node : "New wantedstate '" + nodeState.toString() + "' stored for node " + node;
                if (!oldState.equals((Object)nodeState) || !oldState.getDescription().equals(nodeState.getDescription())) {
                    if (!nodeState.getState().validWantedNodeState(nodeType)) {
                        throw new IllegalStateException("State " + nodeState.getState() + " can not be used as wanted state for node of type " + nodeType);
                    }
                    node.setWantedState(nodeState);
                    changeListener.handleNewWantedNodeState(node, nodeState);
                } else {
                    message = "Node " + node + " already had wanted state " + nodeState.toString();
                    log.log((Level)LogLevel.DEBUG, message);
                }
                req.returnValues().add((Value)new StringValue(message));
                req.returnRequest();
                if (nodeState.getState() != State.UP || node.getPrematureCrashCount() <= 0) continue;
                log.log(LogLevel.INFO, "Clearing premature crash count of " + node.getPrematureCrashCount() + " as wanted state was set to up");
                node.setPrematureCrashCount(0);
                continue;
            }
            catch (Exception e2) {
                String errorMsg;
                if (log.isLoggable((Level)LogLevel.DEBUG)) {
                    StringWriter sw = new StringWriter();
                    e2.printStackTrace(new PrintWriter(sw));
                    log.log((Level)LogLevel.DEBUG, "Failed RPC Request: " + sw);
                }
                if ((errorMsg = e2.getMessage()) == null) {
                    errorMsg = e2.toString();
                }
                req.setError(111, errorMsg);
                req.returnRequest();
            }
        }
        return handledAnyRequests;
    }
}

