/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.vdslib.distribution.ConfiguredNode;
import com.yahoo.vdslib.distribution.Distribution;
import com.yahoo.vdslib.distribution.Group;
import com.yahoo.vdslib.distribution.GroupVisitor;
import com.yahoo.vdslib.state.ClusterState;
import com.yahoo.vdslib.state.Node;
import com.yahoo.vdslib.state.NodeType;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;

class GroupAvailabilityCalculator {
    private final Distribution distribution;
    private final double minNodeRatioPerGroup;

    private GroupAvailabilityCalculator(Distribution distribution, double minNodeRatioPerGroup) {
        this.distribution = distribution;
        this.minNodeRatioPerGroup = minNodeRatioPerGroup;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static boolean isFlatCluster(Group root) {
        return root.isLeafGroup();
    }

    public Set<Integer> nodesThatShouldBeDown(ClusterState state) {
        if (this.distribution == null) {
            return Collections.emptySet();
        }
        if (GroupAvailabilityCalculator.isFlatCluster(this.distribution.getRootGroup())) {
            return new HashSet<Integer>();
        }
        InsufficientAvailabilityGroupVisitor visitor = new InsufficientAvailabilityGroupVisitor(state);
        this.distribution.visitGroups((GroupVisitor)visitor);
        return visitor.implicitlyDownNodeIndices();
    }

    private class InsufficientAvailabilityGroupVisitor
    implements GroupVisitor {
        private final Set<Integer> implicitlyDown = new HashSet<Integer>();
        private final ClusterState clusterState;

        public InsufficientAvailabilityGroupVisitor(ClusterState clusterState) {
            this.clusterState = clusterState;
        }

        private boolean nodeIsAvailableInState(int index, String states) {
            return this.clusterState.getNodeState(new Node(NodeType.STORAGE, index)).getState().oneOf(states);
        }

        private Stream<ConfiguredNode> availableNodesIn(Group g) {
            return g.getNodes().stream().filter(n -> this.nodeIsAvailableInState(n.index(), "uim"));
        }

        private Stream<ConfiguredNode> candidateNodesForSettingDown(Group g) {
            return g.getNodes().stream().filter(n -> this.nodeIsAvailableInState(n.index(), "ui"));
        }

        private double computeGroupAvailability(Group g) {
            long availableNodes = this.availableNodesIn(g).count();
            return (double)availableNodes / (double)g.getNodes().size();
        }

        private void markAllAvailableGroupNodeIndicesAsDown(Group group) {
            this.candidateNodesForSettingDown(group).forEach(n -> this.implicitlyDown.add(n.index()));
        }

        public boolean visitGroup(Group group) {
            if (group.isLeafGroup() && this.computeGroupAvailability(group) < GroupAvailabilityCalculator.this.minNodeRatioPerGroup) {
                this.markAllAvailableGroupNodeIndicesAsDown(group);
            }
            return true;
        }

        Set<Integer> implicitlyDownNodeIndices() {
            return this.implicitlyDown;
        }
    }

    public static class Builder {
        private Distribution distribution;
        private double minNodeRatioPerGroup = 1.0;

        Builder withDistribution(Distribution distribution) {
            this.distribution = distribution;
            return this;
        }

        Builder withMinNodeRatioPerGroup(double minRatio) {
            this.minNodeRatioPerGroup = minRatio;
            return this;
        }

        GroupAvailabilityCalculator build() {
            return new GroupAvailabilityCalculator(this.distribution, this.minNodeRatioPerGroup);
        }
    }
}

